
/*
 * m_setvis.c -- add/delete messages to/from unseen-sequence
 *
 * $Id$
 */

#include <h/mh.h>

/*
 * The messages to be acted upon are marked by UNSEEN flag
 *
 * If seen == 1, delete messages from unseen sequence.
 * If seen == 0, add messages to unseen sequence.
 */

void
m_setvis (struct msgs *mp, int seen)
{
    int msgnum;
    char **ap, *cp;
    char *dp = NULL;

    /* get the line for unseen messages and split it */
    if ((cp = m_find (usequence)) == NULL
	    || (ap = brkstring (dp = getcpy (cp), " ", "\n")) == NULL
	    || *ap == NULL) {
	if (dp)
	    free (dp);
	return;
    }

    for (; *ap; ap++) {
	if (seen) {
	    if (m_seqflag (mp, *ap))
		for (msgnum = mp->lowsel; msgnum <= mp->hghsel; msgnum++)
		    if (is_unseen (mp, msgnum))
			m_seqdel (mp, *ap, msgnum);
	} else {
	    for (msgnum = mp->lowmsg; msgnum <= mp->hghmsg; msgnum++)
		if (is_unseen (mp, msgnum))
		    m_seqadd (mp, *ap, msgnum, -1);
	}
    }

    if (dp)
	free (dp);
}
