
/*
 * seq_read.c -- read the .mh_sequence file and
 *            -- initialize sequence information
 *
 * $Id$
 */

#include <h/mh.h>

/*
 * static prototypes
 */
static int seq_init (struct msgs *, char *, char *);


/*
 * Get the sequence information for this folder from
 * .mh_sequence (or equivalent specified in .mh_profile)
 * or context file (for private sequences).
 */

void
seq_read (struct msgs *mp)
{
    int alen, i, j, plen, state;
    char *cp, name[NAMESZ], field[BUFSIZ * 2];
    struct node *np;
    FILE *fp;

    mp->msgattrs[i = 0] = getcpy (current);
    mp->msgattrs[++i] = NULL;
    make_all_public (mp);	/* initially, all public */

    m_getdefs ();
    if (mh_seq == '\0' || *mh_seq == '\0')
	goto private_only;

    /* read folder's sequences file */
    sprintf (field, "%s/%s", mp->foldpath, mh_seq);
    if ((fp = fopen (field, "r"))) {
	for (state = FLD;;) {
	    switch (state = m_getfld (state, name, field, sizeof(field), fp)) {
		case FLD: 
		case FLDEOF: 
		    seq_init (mp, getcpy (name), trimcpy (field));
		    if (state == FLDEOF)
			break;
		    continue;

		case BODY: 
		case BODYEOF: 
		    adios (NULL, "no blank lines are permitted in %s/%s",
			   mp->foldpath, mh_seq);	/* fall */

		case FILEEOF:
		    break;

		default: 
		    adios (NULL, "%s/%s is poorly formatted",
			   mp->foldpath, mh_seq);
	    }
	    break;
	}
	fclose (fp);
    }

private_only:;

    /*
     * Handle private sequences
     */
    alen = strlen ("atr-");
    plen = strlen (mp->foldpath) + 1;

    for (np = m_defs; np; np = np->n_next)
	if (ssequal ("atr-", np->n_name)
		&& (j = strlen (np->n_name) - plen) > alen
		&& *(np->n_name + j) == '-'
		&& strcmp (mp->foldpath, np->n_name + j + 1) == 0) {
	    cp = getcpy (np->n_name + alen);
	    *(cp + j - alen) = '\0';
	    if ((i = seq_init (mp, cp, getcpy (np->n_field))) != NOTOK)
		make_seq_private (mp, i);
	}
}


/*
 * Set the various message bits for this sequence
 */

static int
seq_init (struct msgs *mp, char *name, char *field)
{
    int i, j, k, hack;
    char *cp, **ap;

    hack = strcmp (current, name) == 0;	/* hack... */
    /* if we're going to use UNSEEN, it should be set here! */

    /*
     * If we've seen this sequence before, then
     * clear the bit for this sequence from
     * all the mesages in this folder.
     */
    for (i = 0; mp->msgattrs[i]; i++) {
	if (strcmp (mp->msgattrs[i], name) == 0) {
	    for (j = mp->lowmsg; j <= mp->hghmsg; j++)
		clear_sequence (mp, i, j);
	    break;
	}
    }

    if (i >= NUMATTRS) {
	free (name);
	free (field);
	return NOTOK;
    }

    if (mp->msgattrs[i]) {
	free (name);
    } else {
	mp->msgattrs[i] = name;
	mp->msgattrs[i + 1] = NULL;
    }

    /*
     * split up the different message ranges at whitespace
     */
    for (ap = brkstring (field, " ", "\n"); *ap; ap++) {
	if ((cp = strchr(*ap, '-')))
	    *cp++ = '\0';
	if ((j = m_atoi (*ap)) > 0) {
	    k = cp ? m_atoi (cp) : j;
#if 0
	    if (hack && j >= mp->lowmsg && j <= mp->hghmsg
		    && (mp->msgstats[j] & EXISTS))
		mp->curmsg = j;
#else
	    if (hack)
		mp->curmsg = j;
#endif
	    /*
	     * We iterate through messages in this range
	     * and flip on bit for this sequence.
	     */
	    for (; j <= k; j++) {
		if (j >= mp->lowmsg && j <= mp->hghmsg
			&& (mp->msgstats[j] & EXISTS))
		    add_sequence (mp, i, j);
	    }
	}
    }
    free (field);

    return i;
}
