/*
 *	Copyright 1988 by Rayan Zachariassen, all rights reserved.
 *	This will be free software, but only when it is finished.
 */

#include <stdio.h>
#include "sysprotos.h"
#include <ctype.h>
#include <pwd.h>
#include "libsupport.h"

/*
 * Routine to initialize the 'nobody' variable to contain a nonprivileged uid.
 *
 * There are three choices:
 * 1. Whatever is specified by the NOBODY key in the /etc/zmailer.conf file
 * 2. The uid of the 'nobody' user if any
 * 3. -2 if that works
 * 4. MAX_SIGNED_SHORT otherwise
 */


char *nouser = "nobody";
int nobody = -2;

static int nobodies[] = { 0, -2, 29999, 0 };

static int didnobody = 0;

int
getnobody()
{
	int i, factor = 1;
	struct passwd *pw;
	char *s;
	extern char *getzenv();

	if (didnobody)
		return nobody;

	if ((s = getzenv("NOBODY")) != NULL) {
		while (*s == '-')
			factor = -1, ++s;
		if (isdigit(*s) && atoi(s) != 0) {
			nobody = atoi(s) * factor;
			goto done;
		} else if (isalpha(*s) && (pw = getpwnam(s)) != NULL) {
			nobody = pw->pw_uid;
			goto done;
		}
	}

	if ((pw = getpwnam(nouser)) != NULL) {
		nobody = pw->pw_uid;
		goto done;
	}

	if (getuid() != 0)	/* it doesn't matter anyway */
		goto done;

	/* check that we can setuid(nobody) */
	for (i = 0; nobodies[i] != 0; ++i) {
		if (
#ifdef	USE_SETREUID
		    setreuid(-1, nobodies[i])
#else	/* !USE_SETREUID */
		    setuid(nobodies[i])
#endif	/* USE_SETREUID */
					== 0)
			break;
	}

	if (nobodies[i] == 0) {
		perror("setuid");
		fprintf(stderr, "Cannot determine 'nobody' uid\n");
		exit(2);
	}
	if (
#ifdef	USE_SETREUID
	    setreuid(-1, 0)
#else	/* !USE_SETREUID */
	    setuid(0)
#endif	/* USE_SETREUID */
				    < 0 || getuid() != 0) {
		perror("setuid");
		fprintf(stderr, "Cannot reset root uid\n");
		exit(3);
	}

	nobody = nobodies[i];
done:
	didnobody = 1;
	return nobody;
	
}

