/* Prototypes of ZMailer Scheduler component routines */

#ifndef __
# ifdef __STDC__
#  define __(x) x
# else
#  define __(x) ()
# endif
#endif

/* agenda.c */
extern time_t qipcretry;
extern void disentangle __((struct vertex *vp));
extern void reschedule __((struct vertex *vp, int factor, int index));
extern int doagenda __((void));
extern int unravel __((struct vertex *head));
extern void spool __((struct vertex *thread));
extern void fifoput __((struct vertex *vp));
extern void fifoschedule __((struct web *wp));

/* conf.c */
extern char *qlogdir;
extern char *qcf_suffix;
extern char *qdefaultdir;
extern char *qoutputfile;
extern char *replhost;
extern char *replchannel;
extern int  nobody;
extern int  sweepinterval;

/* msgerror.c */
extern void msgerror __((struct vertex *vp, long offset, char *message));
extern void reporterrs __((struct ctlfile *cfpi));
extern char *mail_alloc __((u_int n));
extern int  mail_free __((char *s));

/* qprint.c */
extern void qprint __((int fd));

/* readconfig.c */
extern struct config_entry *default_entry;
extern void   defaultconfigentry __((struct config_entry *ce, struct config_entry *defaults));
extern void   vtxprint __((struct vertex *vp));
extern struct config_entry *readconfig __((char *file));
extern struct config_entry *rereadconfig __((struct config_entry *head, char *file));

/* resources.c */
extern int  resources_query_nofiles  __((void));
extern void resources_maximize_nofiles __((void));
extern void resources_limit_nofiles __((int nfiles));
extern int  resources_query_pipesize __((int fildes));

/* scheduler.c */
extern int  transportmaxnofiles;
extern char *progname;
extern char *postoffice;
extern char *rendezvous;
extern char *pidfile;
extern char *mailshare;
extern char *mailbin;
extern char *log;
extern int  global_maxkids;
extern int  verbose;
extern int  querysocket;
extern struct ctlfile *slurp __((int fd, long ino));
extern void vtxdo __((struct vertex *, struct config_entry *, char *));
extern char *timestring __((void));
extern time_t now;

/* transport.c */
extern struct procinfo *cpids;
extern int  numkids;
extern void transport __((struct vertex *vhead, char *channel, char *host));
extern SIGNAL_TYPE sig_chld __((int sig));
extern int mux __((time_t timeout));
extern void queryipcinit __((void));
#if defined(USE_BINMKDIR) || defined(USE_BINRMDIR)
extern int system __((char*));
#endif
extern SIGNAL_TYPE sig_chld __((int));

/* update.c */
extern void update __((int, char *));
extern void unweb __((int i, struct web *wp));
extern void unctlfile __((struct ctlfile *cfp));
extern void deletemsg __((char *, struct ctlfile *));
extern char *saytime __((u_long, char *, int));
extern void expire __((struct vertex *, int));


/* Transport library */
extern int lockaddr __((int, long, char, char));
