#!/usr/sbin/perl
#
#   Darryl L. Miles (09/10/1995) quick bodge(TM)
#
#   BSD Install syntax in, converts and runs IRIX install out.
#	This will not work 100%, but enough for the zmailer installation.
#
#	If the destination pathname is specified as just a directory the
#	file is to be installed IN, it will fail.  Zmailer uses the
#	full (new and to be installed) pathname as the destination so
#	this is ok for us (for now).
#
$InstallBin='/sbin/install';

$strip=0;

while($arg = shift) {
	if($arg eq '-o') {
		$owner = shift;
	} elsif($arg eq '-g') {
		$group = shift;
	} elsif($arg eq '-m') {
		$mode = shift;
	} elsif($arg eq '-s') {
		$strip=1;
	} elsif($arg eq '-c') {
		;
	} elsif($arg eq '--') {
		last;
	} elsif($arg =~ /^\-./) {
		print STDERR "Unknown argument: $arg\n";
		exit 1;
	} else {
		unshift(@ARGV, $arg);
		last;
	}
}

if(($#ARGV+1) <= 1) {
	print STDERR "$0: Not enough arguments, need src and dest pathname\n";
	exit 1;
}

#$srcs="";
#@srcs=();
#$dest="";

while(($arg = shift)) {
	if(($#ARGV+1) == 0) {
		# The last so must be dest
		$dest=$arg;
	} else {
		# A src file
		push(@srcs, $arg);
#		$srcs="$srcs $arg";
	}
}


if(!defined(@srcs)) {
	print STDERR "$0: Destination file or directory has not been specifie\n";
	exit 1;
}

if(!defined($dest) || ("$dest" eq "")) {
	print STDERR "$0: Source file(s) has not been specified\n";
	exit 1;
}


# Work out the command line args for IRIX install proggie
#@arg=();

if("$owner" ne "") {
	push(@arg, "-u");
	push(@arg, "$owner");
}

if("$group" ne "") {
	push(@arg, "-g");
	push(@arg, "$group");
}

if("$mode" ne "") {
	push(@arg, "-m");
	push(@arg, "$mode");
}


# Take the dest and workout -F xxx.
if($dest =~ q#^(.+)/([^/]+)\s*$#) {
	$ddir=$1;
	$dest=$2;
}

if($srcs[0] =~ q#^(.+)/([^/]+)\s*$#) {
	$sdir=$1;
	$sfile=$2;
} else {
	$sfile=$srcs[0];
}


# Debugging...
#if(defined($sdir)) {
#	print STDERR "  Src Dir: $sdir\n";
#}
#print STDERR " Src File: $sfile\n";
#print STDERR " Dest Dir: $ddir\n";
#print STDERR "Dest File: $dest\n";
#print STDERR "  Srcs[0]: $srcs[0]\n";


if(($dest ne $sfile) || defined($sdir)) {
	if(($#srcs+1) != 1) {
		print STDERR "$0: You can't rename the dest with multiple files\n";
		exit 1;
	}
 	if(defined($sdir)) {
		$altname = "$sdir" . "/" . "$sfile";
	} else {
		$altname = "$sfile";
	}
#	undef(@srcs);
##	$srcs[0] = "$sfile";
}

#if(($dest eq "") || ($dest eq $sdir)) {
#   $dest=$sfile;
#}

# IRIX install uses -F to specify the path if you wish the dirs to be
#   created, and -f is you don't.  We assume -F.
if(defined($ddir)) {
	push(@arg, "-F");
	push(@arg, "$ddir");
}

# If dest name is different to the src name then rename it.
#   I hope this will do the trick...
if(defined($altname)) {
	undef(@srcs);
#	$srcs[0] = "$sfile";

	push(@arg, "-src");
	push(@arg, "$altname");
}

# We don't implement symbol stripping at the mo, IRIX install doesn't
#   appear to have this functionallity, do we'd have to run the 'strip'
#   util after /sbin/install.


foreach $i (@srcs) {
	push(@arg, $i);
}

push(@arg, $dest);


# More debugging...
print STDERR "Would exec: /sbin/install";
foreach $i (@arg) {
	print STDERR " $i";
}
print STDERR "\n";

exec $InstallBin, @arg;
