/* **************************************************************** *
 *	ANSI-C (GCC) prototypes for Zmailer  libz.a -routines	    *
 *  Written by Matti Aarnio <mea@utu.fi> for Zmailer 2.2	    *
 * **************************************************************** */

#ifndef __
# ifdef __STDC__
#  define __(x) x
# else
#  define __(x) ()
# endif
#endif

/* allocate.c */
extern memtypes	 stickymem;
extern int       blockmen __((const memtypes memtype, univptr_t up));
extern univptr_t tmalloc __((const size_t n));
extern univptr_t smalloc __((const memtypes memtype, const size_t n));
extern void      memstats __((const memtypes memtype));
extern void      memcontents __((void));
extern void      tfree __((const memtypes memtype));
extern univptr_t getlevel __((const memtypes memtype));
extern void      setlevel __((const memtypes memtype, univptr_t s));
extern char *    strsave __((const char *s));
extern char *    strnsave __((const char *s, const size_t n));

/* cleanenv.c */
extern char *    nukelist[];
extern void      cleanenv __((void));

/* detach.c */
extern void detach __((void));

/* die.c */
extern void die __((int status, char *message));

/* dottedquad.c */
#ifdef HAVE_NETINET_IN_H
# include <netinet/in.h>
#endif
extern char *dottedquad __((struct in_addr *inp));

/* esyslib.c */
extern int eopen __((char *s, int f, int m));
extern int eread __((int fd, char *buf, int len));
extern int epipe __((int fdarr[2]));
extern univptr_t emalloc __((size_t len));
extern univptr_t erealloc __((univptr_t buf, size_t len));
extern int efstat __((int fd, struct stat *stbuf));
extern int estat __((char *path, struct stat *stbuf));
extern long elseek __((int fd, long pos, int action));
extern int elink __((char *file1, char *file2));
extern int eunlink __((char *file));
extern int eclose __((int fd));
extern int echdir __((char *file));
extern int emkdir __((char *file, int mode));
extern int ermdir __((char *file));
extern int erename __((char *from, char *to));

#ifdef	HOST_NOT_FOUND	/* If we have  <netdb.h> included */
/* hostent.c */
extern void hp_init __((struct hostent *hp));
extern void hp_setalist __((struct hostent *hp));
extern char **hp_getaddr __((void));
extern char **hp_nextaddr __((void));
extern void hp_addr_randomize __((struct hostent *hp));
#endif

/* killprev.c */
extern int killprevious __((int sig, char *pidfile));

/* linebuffer.c */
extern void initline __((long blksize));
extern int  getline __((FILE *fp));
extern void repos_getline __((FILE *fp, long pos));
extern int  getrest __((void));
extern long offset __((FILE *fp));

/* loginit.c */
extern int loginit __((void));

/* nobody.c */
extern int getnobody __((void));

/* prversion.c */
extern void prversion __((char *progname));

#ifdef USE_ZGETPWNAM
/* pwdgrp.c */
extern struct passwd	*zgetpwnam __((const char *name));
extern struct passwd	*zgetpwuid __((const char *uid));
extern struct group	*zgetgrnam __((const char *name));
#endif

/* ranny.c */
extern u_int ranny __((u_int m));

/* rfc822date.c */
extern char *rfc822tz __((struct tm *ts, int prettyname));
extern char *rfc822date __((time_t *timep));

/* rfc822scan.c */
extern int    hdr_status __((u_char *cp, u_char *lbuf, int n));
extern u_long _hdr_compound __((u_char *cp, long n, u_char cstart, u_char cend,
				TokenType type, struct token *tp,
				struct token **tlist, struct token **tlistp));
extern u_char * _unfold __((u_char *start, u_char *end, struct token *t));
extern struct token * scan822 __((u_char **cpp, long n, int c1, int c2,
				  int allowcomments, struct token **tlistp));

/* splay.c */
/* .... much ... */

/* stringlib.c */
extern int cistrcmp __((char *a, char *b));
extern int cistrncmp __((char *a, char *b, int n));
extern int ci2strncmp __((char *a, char *b, int n));

/* strmatch.c */
extern int strmatch __((unsigned char *pattern, unsigned char *term));

/* symbol.c */
extern spkey_t symbol __((u_char *s));
extern char *pname __((u_int id));
#ifdef MALLOC_TRACE
extern int icpname __((struct spblk *spl));
extern void prsymtable __((void))
#endif

/* token.c */
extern struct token *makeToken __((u_char *s, int n));
extern struct token *copyToken __((struct token *t));
extern char *formatToken __((struct token *t));
extern char *formatAddr __((AddrComponent d));
extern int printToken __((u_char *buf, u_char *eob,
			  struct token *t, struct token *tend,
			  int quotespecials));
extern int fprintToken __((FILE *fp, struct token *t, int onlylength));
extern int fprintFold __((FILE *fp, struct token *t, int col));
extern void freeTokens __((struct token *t, int memtype));

/* trusted.c */
extern void	settrusteduser	 __((void));
extern int	runastrusteduser __((void));
extern int	runasrootuser	 __((void));
