/*
 * tasyslog() -- support routine for ZMailer transport agents.
 * Copyright 1997, Matti Aarnio <mea@nic.funet.fi>
 *
 * The purpose of this routine is to produce similar syslog entries
 * to those that sendmail(8) does for its message processing.
 *
 */

#include "hostenv.h"
#include <stdio.h>
#include <sysexits.h>
#ifdef HAVE_STDARG_H
# include <stdarg.h>
#else
# include <varargs.h>
#endif
#include <sys/types.h>
#include <fcntl.h>
#include <sys/stat.h>
#include "syslog.h"
#include "mail.h"
#include "ta.h"

void
tatimestr(buf,dt)
char *buf;
int dt;
{
	int hours, mins, secs;

	secs  = dt % 60;
	dt    = dt / 60;
	mins  = dt % 60;
	hours = dt / 60;

	sprintf(buf,"%02d:%02d:%02d", hours, mins, secs);
}

void
tasyslog(rp,xdelay,wtthost,stat,msg)
struct rcpt *rp;
int xdelay;
char *wtthost;
char *stat;
char *msg;
{
  char linebuf[8000];		/* Should be aplenty..		*/
  char spoolid[30];		/* Min. space: 6+8+1 chars	*/
  char delays[16], xdelays[16]; /* Min. space: 8+1 chars	*/
  time_t now;

  taspoolid(spoolid, sizeof(spoolid), rp->desc->msgmtime, rp->desc->msgfile);

  time(&now);

  tatimestr(delays,(int)(now - rp->desc->msgmtime));
  tatimestr(xdelays,xdelay);

  /* to='rp->addr->user'
     ctladdr=`getpwuid(rp->addr->misc)`
     mailer='rp->addr->channel' */

  if (wtthost == NULL)
    sprintf(linebuf, "%s: to=%.200s, delay=%s, xdelay=%s, mailer=%.200s, stat=%.200s %.400s",
	    spoolid, rp->addr->user, delays, xdelays, rp->addr->channel, stat, msg);
  else
    sprintf(linebuf, "%s: to=%.200s, delay=%s, xdelay=%s, mailer=%.200s, relay=%s, stat=%.200s %.400s",
	    spoolid, rp->addr->user, delays, xdelays, rp->addr->channel, wtthost, stat, msg);

  syslog(LOG_INFO, "%s", linebuf);
}
