.\" Whoson API manual page
.\" 
.\" $Id: whoson.man,v 1.4 1998/07/12 16:43:57 crosser Exp $
.\" 
.\" $Log: whoson.man,v $
.\" Revision 1.4  1998/07/12 16:43:57  crosser
.\" fix prefix
.\"
.\" Revision 1.3  1998/07/05 23:24:12  crosser
.\" fix typos
.\"
.\" Revision 1.2  1998/07/05 21:49:38  crosser
.\" fix Log
.\"
.\" 
.\" WHAT IS IT:
.\"	Implementation of "whoson" protocol
.\" AUTHOR:
.\"	Eugene G. Crosser <crosser@average.org>
.\" COPYRIGHT:
.\"	Public domain
.\" 
.TH WHOSON 3 "06 Jun 1998" WHOSON WHOSON
.SH NAME
wso_login, wso_logout, wso_query, wso_version \- API functions to access whoson database
.SH SYNOPSYS
.B #include <whoson.h>
.sp
.BI "int wso_login(char " *addr ", char " *name ", char " *retbuf ", int " buflen)
.sp
.BI "int wso_logout(char " *addr ", char " *retbuf ", int " buflen)
.sp
.BI "int wso_query(char " *addr ", char " *retbuf ", int " buflen)
.sp
.BI "char *wso_version(void)
.sp
.SH DESCRIPTION
.B wso_login()
adds an entry to the whoson database (or replaces existing entry with
the same key)
.sp
.B wso_logout()
deletes entry from the database
.sp
.B wso_query()
requests the database entry
.sp
.B wso_version()
returns the character string with the version number of the API and
build date.
.sp
.I addr
is the IP address of the remote system specified as a character
string in dotted quad notation (e.g. "123.45.67.89"), and
.I name
is the user accounting information (e.g. userid).  Upon completion,
.B wso_login()
.B wso_logout()
and
.B wso_query()
return integer return code, and the buffer
.I retbuf
is filled with relevant information.  Return code
.B -1
means that the request could not be completed, return code
.B 0
or
.B +1
mean that the request was successfully completed.  For
.B wso_query()
function, return code 0 means that the
requested address is present in the database.  In this case,
.I retbuf
may contain the data that was previously passed to the
.B wso_login()
with the same
.I addr
value in the
.I name
parameter.  In other cases, retbuf may or may not contain description of
the situation, e.g. the text "Access denied" or "Not found" or something
like that.  If
.I retbuf
parameter is NULL or
.I buflen
is zero, no attempt is made to fill the buffer.
.sp
Normally, when filling the database, you can blindly call
.B wso_login()
(and
.B wso_logout()
if appropriate) and ignore the return code.  When querying the
database, return code
.B 0
means that the address is in the database, return code
.B +1
means that the address is not in the database, and return code
.B -1
means that the information is unavailable or inaccessable.
.sp
The file
.BR /etc/whoson.conf "(5)
defines how the API functions should contact the
.BR whosond "(8)
server.
.SH COPYRIGHT
Public domain
.SH SEE ALSO
.BR whosond "(8), " whoson.conf "(5)
