#! /bin/sh -u
#	GetRelease.sh [1.7] from /preflight/src/nav/SCCS/s.GetRelease.sh
#		Retrieved 16:26:11 88/07/07; latest mod 16:04:23 88/07/07
#
#	Get the source for a particular release
#	GetRelease.sh [-v] <ReleaseNumber>
#	-v		Verbose operation
#	ReleaseNumber	Number of the release whose sources are to be
#			retrieved
#
#	Alan M. Marcum		marcum@nescorna.Sun.COM
#
#	@(#)GetRelease.sh	Revision 1.7	88/07/07

PATH=/usr/ucb:/bin:/usr/bin

# Definitions for accessing commands (makes debugging easier)
ERROR=echo
OPTIONS="-v"
BASENAME=basename
AWK=awk
SED=sed
ECHO=echo
GREP=grep
RM=rm
SH=sh
SCCSGET="sccs get"
TRUE=true
FALSE=false

# Following for no NEWLINEs on echo.  Settings are for BSD UNIX
#	[i.e. echo -n "..." ]; for System V UNIX [i.e. echo "...\c"],
#	reverse the comments.
ECHO_NL_ARG="-n"
#ECHO_NL_ARG=""
ECHO_NL_STR=""
#ECHO_NL_STR="\c"

# Variables used
Name=`$BASENAME $0`
Verbose=$FALSE

# Configuration variables
ReleaseMap=ReleaseMap
ReleaseFile=LatestRelease
Syntax="Syntax: $Name [$OPTIONS] <ReleaseNumber>"

# Process the arguments
case $# in
2 )	case $1 in
		-v )	Verbose=$TRUE
			ReleaseNumber=$2
			;;
		* )	$ERROR 1>&2 $Name: Unknown option $1.
			$ERROR 1>&2 $Syntax
			exit 1
			;;
	esac
	;;
1 )
	ReleaseNumber=$1
	;;
* )
	$ERROR 1>&2 "$Name: Incorrect number of arguments ($#)"
	$ERROR 1>&2 $Syntax
	exit 1
	;;
esac

# We have the arguments processed; go find the revision of ReleaseFile
if $Verbose
then
	$ECHO $ECHO_NL_ARG "Looking for Release $ReleaseNumber...$ECHO_NL_STR"
fi

# Escape any .s in the ReleaseNumber (e.g. 2.6), to eliminate their
# special meaning to grep
ReleaseNumber1=`$ECHO $ReleaseNumber | $SED -e 's/\./\\\./g'`

if $GREP "^Release[ 	][ 	]*$ReleaseNumber1[ 	][ 	]*" \
	$ReleaseMap > GetRelease.tmp$$
then
	if $Verbose
	then
		$ECHO $ECHO_NL_ARG "Found Release $ReleaseNumber;$ECHO_NL_STR"
		$ECHO $ECHO_NL_ARG " $ReleaseFile$ECHO_NL_STR"
		$SED -e 's/Release ..*[ 	]/ Revision /' GetRelease.tmp$$
	fi

# Have the revision number; go fetch it
	$SCCSGET -r`awk '{printf $3}{exit}' GetRelease.tmp$$` \
		$ReleaseFile > /dev/null 2>&1

# Process ReleaseFile, extracting the module name and SCCS revision number.
#   Feed these to the shell, to extract the stuff.  If we're running verbose,
#   the extraction will print something of the form
#		Makefile	Revision 2.21 292 lines
#   If no SCCS ID keywords are found, a notation to that effect will
#   be appended to the line.
	if $Verbose
	then
		$AWK \
'/Module: ..*\//{dirstart = index($2, ":"); \
		 dirend = (index($2, "/") - start) - 1; \
		 dir = substr($2, dirstart + 1, dirend-dirstart); \
		 file = substr($2, dirend + 2); \
		 printf "(cd ./" dir "; "; \
		 dir = sprintf(dir "/") }; \
/Module: /	{if (0 == index($2, "/")) { \
			dir = ""; \
			file = $2; }; \
		 print "echo " dir file \
		 	"\tRevision `sccs get -r" $3 " " file " 2>&1`)"}' \
			$ReleaseFile | $SH
	else
		$AWK \
'/Module: ..*\//{dirstart = index($2, ":"); \
		 dirend = (index($2, "/") - dirstart) - 1; \
		 dir = substr($2, dirstart + 1, dirend-dirstart); \
		 file = substr($2, dirend + 2); \
		 printf "(cd ./" dir "; "; }; \
/Module: /	{if (0 == index($2, "/")) { \
			file = $2; }; \
		 print "sccs get -r" $3 " " file " > /dev/null 2>&1)"}' \
			$ReleaseFile | $SH
	fi

# Be sure we have an up-to-date ReleaseFile after all that
	$SCCSGET -r`awk '{printf $3}{exit}' GetRelease.tmp$$` \
		$ReleaseFile > /dev/null 2>&1

# Clean up and go home
	$RM GetRelease.tmp$$
	exit 0

else

# Oops... No such release found
if $Verbose
then
	$ERROR 1>&2 ""
fi
	$ERROR 1>&2 $Name: Could not find Release $ReleaseNumber in $ReleaseMap
	if $Verbose
	then
# Verbose; print the known releases
		$ECHO -n 1>&2 "Known releases: "
		$AWK '/^Release/{printf $2 " "}' $ReleaseMap
		$ECHO ""
	fi

	$RM GetRelease.tmp$$
	exit 1
fi
