#! /bin/sh -u
#	Aviation navigation program
#	Shell script for generating SED script for massaging
#	top-level Makefile.  The SED script is needed because
#	the file 'release' has no trailing newline; the shell
#	script is needed because of SHAR issues which make it
#	impossible to pack, in a straightforward manner, the
#	SED script itseld.
#
#	build_sed.sh [1.8] from /preflight/src/nav/SCCS/s.build_sed.sh
#		Retrieved 16:26:12 88/07/07; latest mod 16:04:24 88/07/07
#	Alan M. Marcum		marcum@nescorna.Sun.COM
#

PROGRAM_NAME="`basename $0`"

ECHO=echo
ERROR=echo

DEFAULT_OUTPUT_FILE=massage_shar.sed
USAGE="${PROGRAM_NAME} [-h | <filename>]
	-h elicits usage message
	Default <filename> is $DEFAULT_OUTPUT_FILE"

case $# in
    0 )
    	OutputFile=$DEFAULT_OUTPUT_FILE
    	;;
    1 )
    	case $1 in
	    -h )
		$ECHO "$USAGE"
		exit 0
		;;
	    * )
		OutputFile=$1
		;;
	esac
    	;;
    * )
	$ERROR 1>&2 "${PROGRAM_NAME}: Too many arguments."
	$ERROR 1>&2 "Usage: $USAGE"
	exit 1
	;;
esac

$ECHO "/^\\(..*\\)Funky_Stuff\$/{" > ${OutputFile}
$ECHO "	s/^\\(..*\\)Funky_Stuff\$/\\1/" >> ${OutputFile}
$ECHO "	a\\" >> ${OutputFile}
$ECHO "Funky_Stuff" >> ${OutputFile}
$ECHO "	a\\" >> ${OutputFile}
$ECHO "echo -n \`cat release\` > Release.nav\$\$" >> ${OutputFile}
$ECHO "	a\\" >> ${OutputFile}
$ECHO "mv Release.nav\$\$ release" >> ${OutputFile}
$ECHO "}" >> ${OutputFile}
