#! /bin/sh -u
#	Convert old-style NAV databases to new-style
#	nav_dbs.sh [1.7] from /preflight/src/nav/SCCS/src/s.nav_dbs.sh
#		Retrieved 16:27:02 88/07/07; latest mod 16:02:49 88/07/07
#
#	Alan M. Marcum		marcum@nescorna.Sun.COM
#
#	@(#)nav_dbs.sh	Revision 1.7	88/07/07
#
# Old-style NAV databases contained unsorted variable-length records, with
# comments interspersed (denoted by a leading #).  New-style NAV databases
# contain sort fixed-length records, with comments in an ancilary file
# with a .doc suffix.
#
# Usage: nav_dbs.sh database_name database_type
#
# This shell script will convert an old-style NAV database into a new-style
# nav database.  If the database is called 'FILE1', it will be copied into
# ',FILE1', the comments in it will go into 'FILE1.doc', and 'FILE1' will
# contain the new database.

# Miscellaneous definitions
ECHO=echo
GREP=grep
SORT=sort
PAD=padit
RM=rm
MV=mv

AIRPORTS_RECORD_LENGTH=112
AIRWAYS_RECORD_LENGTH=0
VORS_RECORD_LENGTH=96

temp_file=/tmp/amm$$.navdb
usage_message="usage: $0 database_name database_type
	Valid types:	airports	vors	airways"

# Check arguments
if [ 2 != $# ]
then
	$ECHO "${usage_message}"
	exit 1
fi
db_name=$1
db_type=$2
case $db_type in
	airport | airports | AIRPORT | AIRPORTS)
		record_length=$AIRPORTS_RECORD_LENGTH
		;;
	vor | vors | VOR | VORS)
		record_length=$VORS_RECORD_LENGTH
		;;
	airway | airways | AIRWAY | AIRWAYS)
		record_length=$AIRWAYS_RECORD_LENGTH
		;;
	*)
		$ECHO "${usage_message}"
		exit 2
		;;
esac

# Put comments into .doc
if [ -s ${db_name}.doc ]
then
	$ECHO "Will not overwrite existing ${db_name}.doc"
	exit 3
fi

$GREP "^#" $db_name > ${db_name}.doc
if [ ! $? ]
then
	$ECHO $GREP returned status $?
	exit $?
fi

# Strip comments, sort, and pad
$GREP -v "^#" $db_name | $SORT | $PAD  $record_length > $temp_file
if [ ! $? ]
then
	$ECHO The sorting and padding returned status $?
	exit $?
fi

if [ -z $temp_file ]
then
	$ECHO "Database would be empty; original remains"
	$RM $temp_file ${db_name}.doc
	exit 4
fi
$MV $db_name ,$db_name
$MV $temp_file $db_name
exit 0
