/*
 *	Aviation navigation program
 *	padit utility
 *	padit.c [1.8] from /preflight/src/nav/SCCS/dbs/s.padit.c
 *		Retrieved 16:27:49 88/07/07; latest mod 16:03:55 88/07/07
 *
 * The padit utility takes files with "variable-length records" delimited
 * by newlines and pads them to "fixed-length record" (also delimited by
 * newlines).  This is used to build the databases NAV uses from something
 * more readily useable by a person.
 *
 *	Alan M. Marcum		marcum@nescorna.Sun.COM
 */

#include <stdio.h>

void	usage();

#define PADCHAR		'\0'
#define TRUE	1
#define FALSE	0

#ifndef	LINT
static char *SCCSid = "@(#)padit.c\tRevision 1.8\t88/07/07";
#endif

main (argc, argv)
int	argc;
char	*argv[];
{
	register int	op_len,		/* How long we want */
			line_len;	/* How long the line is */
	char	buf[BUFSIZ];
	int	toolong = FALSE;	/* Have we found a line too long? */

	if (argc < 2) {
	        usage(argv[0]);
		(void)exit(2);
	}
	if (-1 > (op_len = atoi(argv[1]) - 1) || op_len == 0) {
		(void)fprintf(stderr,
			"%s: Pad-to length (%d) must be = 0 or > 1.\n",
			argv[0], op_len + 1);
	        usage(argv[0]);
		(void)exit(2);
	}

	while (NULL != gets(buf)) {	/* Go to EOF */
		fputs(buf, stdout);	/* Avoid puts's trailing nl */
		if (op_len != -1) {
			if (op_len < (line_len = strlen(buf))) {
			        (void)fprintf(stderr,
					"%s: line longer than desired.\n",
				        argv[0]);
				(void)fprintf(stderr,
			   "%s: length is %d; desired is %d (note NL).\n",
				        argv[0], line_len + 1, op_len + 1);
				(void)fprintf(stderr,
				        "%s: line is -%s-\n", argv[0], buf);
				toolong = TRUE;
			}
			for (line_len = strlen(buf);
			     line_len < op_len;
			     line_len++)
			        putchar(PADCHAR);
		}
		putchar('\n');
	}
	if (toolong)
	        (void)exit(1);
}

void
usage(str)
{
	(void)fprintf(stderr, "usage: %s line_length\n", str);
	(void)fprintf(stderr,
		      "%s: Pad to n-1 chars/line (so n incl. NL).\n", str);
	(void)fprintf(stderr, "%s: line_length == 0 means no pad.\n", str);
}
