.\"	Aviation navigation program
.\"	nav.ms [1.8] from /preflight/src/nav/SCCS/doc/s.nav.ms
.\"		Retrieved 15:03:17 88/07/08; latest mod 16:03:23 88/07/07
.\"
.ie n \{\
.nr HM 2v
.nr FM 2v
.nr LL 7.5i
.ds LH
.ds CH
.ds RH
.ds LF
.ds CF
.ds RF \}
.el \{\
.ds LH Preflight Planning Program
.ds CH
.ds RH Description
.ds LF
.ds CF
.ds RF \}
.\"
.\" Force initialization so my bottom title macro is called
.IZ
.\"
.\" Set up to turn on page footers only after Page 1
.wh -\\n(FMu/2u+1 Bt
.\"
.\" My bottom title macro, which will be called only for Page 1
.de Bt
.ie n \{\
.ds RF Page % \}
.el \{\
.ds LF Release 4 of 88/07/07
.ds RF Page % \}
.\" Only need to do this junk once
.wh 1 Nl
..
.\" Macro to supplant Bt after it is first called
.de Nl
..
.\"
.ad l
.DS C
Aviation Navigation Program and Database
nav.ms	88/07/07
Release 4
.sp 1
Alan M. Marcum
marcum@nescorna.Sun.COM
.DE
.wh 1 Bt
.LP
This program will compute the rhumbline equivalent of a great
circle route between two points.  \fBnav\fP uses three
databases: \fIairports.nav, vors.nav,\fP and \fIairways.nav\fP.
They contain,
respectively, information on airports, information on navaids,
waypoints, fixes, and intersections, and information about airways.
.LP
\fBnav\fP will
compute either an RNAV course from waypoint to waypoint or will
plan a course from VOR to VOR.  In the RNAV mode any VORs given
(as opposed to VORTACS) will be used as the waypoint. If a flight
uses a mixture of Vortacs, Vors or intersections in RNAV mode,
the program will use intermediate Vors or intersections as
temporary 'to' points when computing direct flight lines in order to
route the flight directly over the Vor or intersection.
.SH
Running nav
.LP
Additional information is provided below.  Simply, invoke \fBnav\fP by
providing arguments describing your proposed flight.  For example:
.sp 1
.ce
nav -from pao -to lax
.sp 1
This will yield output such as
.if t .ig Nr
.DS L
                           Flight Plan - Release 4
+---------------------------+-------------------------------------------------+
| Origin/Fix/Destination    |                Navigation Log                   |
| Comments                  |                                                 |
| Freq  / Alt / Type        |  CRS | Freq|      | TAS | Leg  |  Total |Fuel/hr|
|---------------------------|  HDG | Rad |      | EGS | ETE  |   ETA  |  Leg  |
| Palo Alto            PAO  |Airway| NM  |  ID  | AGS | ATE  |   ATA  | Total |
| Gnd 125.0, ATIS 120.6     |------+-----+------+-----+------+--------+-------|
| 118.6      5       Airport|  122 |  0.0|      |   0 | 277.9|  277.9 |   0.0 |
+--------------------------->  122 |  000|      |   0 |      |        |   0.0 |
| Los Angeles Int      LAX  |      |  0.0|   LAX|     |   :  |    :   |   0.0 |
|                           |------+-----+------+-----+------+--------+-------|
| 0.0      126       Airport|
+----------------------------
.DE
.Nr
.if n .ig Tr
.\"
.\"  In the following flight plan, COMMENT COMMANDS
.\"  separate the physical output lines
.\"
.DS L
.ce 1
Flight Plan \- Release 4
.tr -\-
.lc \-
+----------------------------\kA+----------------------\kB\
-----------------------------------\kZ+
.nr A +(\w'+'/2)
.nr Z +(\w'+'/2)
\(br\h'1'Origin\h'1'/\h'1'Fix\h'1'/\h'1'Destination\h'|\nAu'\
\(br\h'|\nBu'Navigation Log\h'|\nZu'\(br
.\"
\(br\h'1'Comments\h'|\nAu'\(br\h'|\nZu'\(br
.\"
\(br\h'1'Freq\h'2'/\h'1.5'\k(L1Alt\h'1.5'/\h'1.3'\k(L2Type\h'|\nAu'\(br\
\h'1.5'CR\k(T1S\h'1'\kB\(br\
\h'1'Fr\k(T2eq\h'1'\kC\(br\
\h'2'\k(T3\h'2'\kD\(br\
\h'1.5'T\k(T4AS\h'1'\kE\(br\
\h'1'Le\k(T5g\h'1'\kF\(br\
\h'1'To\k(T6tal\h'1'\kG\(br\
\h'0.7'Fue\k(T7l/hr\h'|\nZu'\(br
.ta	\nAu \
 \n(T1uC \nBuL \
 \n(T2uC \nCuL \
 \n(T3uC \nDuL \
 \n(T4uC \nEuL \
 \n(T5uC \nFuL \
 \n(T6uC \nGuL \
 \n(T7uC \nZuL
\(br\a\(br\tHDG\t\(br\tRad\t\(br\t\t\(br\tEGS\t\
\(br\tETE\t\(br\tETA\t\(br\tLeg\t\(br
.\"
\(br Palo Alto\h'|\n(L2u'PAO\t\(br\tAirway\t\(br\tNM\t\(br\tID\t\
\(br\tAGS\t\(br\tATE\t\(br\tATA\t\(br\tTotal\t\(br
.\"
\(br Gnd 125.0, ATIS 120.6\h'|\nAu'\(br\
.\"
\a\a+\a\a+\a\a+\a\a+\a\a+\a\a+\a\a\(br
.\"
.\" This is the end of the preamble shared by both examples
.\"
\(br 118.6\h'|\n(L1u'5\h'|\n(L2u'Airport\t\(br\t122\t\(br\t0.0\t\
\(br\t\t\(br\t0\t\(br\t277.9\t\(br\t277.9\t\(br\t0.0\t\(br
.\"
+\a>\t122\t\(br\t000\t\(br\t\t\(br\t0\t\(br\t\t\(br\t\t\(br\t0.0\t\(br
.\"
\(br Los Angeles Int\h'|\n(L2u'LAX\t\(br\t\t\(br\t0.0\t\(br\tLAX\t\
\(br\t\t\(br\t:\t\(br\t:\t\(br\t0.0\t\(br
.\"
\(br\h'|\nAu'\(br\a\a+\a\a+\a\a+\a\a+\a\a+\a\a+\a\a\(br
.\"
\(br\h'1'0.0\h'|\n(L1u'126\h'|\n(L2u'Airport\t\(br
.\"
+\a
.\"
.tr --
.DE
.Tr
For a more complex example:
.sp 1
.ce
nav -from pao -to lax -via ave rom -speed 115 -alt 7500 -wind 2810
.sp 1
which produces something akin to
.if t .ig Nr
.DS L
                           Flight Plan - Release 4
+---------------------------+-------------------------------------------------+
| Origin/Fix/Destination    |                Navigation Log                   |
| Comments                  |                                                 |
| Freq  / Alt / Type        |  CRS | Freq| Wind | TAS | Leg  |  Total |Fuel/hr|
|---------------------------|  HDG | Rad |  Alt | EGS | ETE  |   ETA  |  Leg  |
| Palo Alto            PAO  |Airway| NM  |  ID  | AGS | ATE  |   ATA  | Total |
| Gnd 125.0, ATIS 120.6     |------+-----+------+-----+------+--------+-------|
| 118.6      5       Airport|  120 |117.1|280@10| 115 | 149.9|  149.9 |   0.0 |
+--------------------------->  123 |  000|  7500| 123 |  1:13|   1:13 |   0.0 |
| Avenal               AVE  |      |  0.0|   AVE|     |   :  |    :   |   0.0 |
| H Bakersfield FSS         |------+-----+------+-----+------+--------+-------|
| 117.1    710        VorTac|  296 |110.0|280@10| 115 |  44.6|  194.5 |   0.0 |
+--------------------------->  293 |  000|  7500| 106 |  0:25|   1:38 |   0.0 |
| Priest               ROM  |      |  0.0|   ROM|     |   :  |    :   |   0.0 |
| L Paso Robles FSS         |------+-----+------+-----+------+--------+-------|
| 110.0      0           VOR|  124 |  0.0|280@10| 115 | 172.3|  366.8 |   0.0 |
+--------------------------->  127 |  000|  7500| 122 |  1:24|   3:02 |   0.0 |
| Los Angeles Int      LAX  |      |  0.0|   LAX|     |   :  |    :   |   0.0 |
|                           |------+-----+------+-----+------+--------+-------|
| 0.0      126       Airport|
+----------------------------
.DE
.Nr
.if n .ig Tr
.DS L
.\"
.\"  In the following flight plan, COMMENT COMMANDS
.\"  separate the physical output lines
.\"
.ce 1
Flight Plan \- Release 4
.tr -\-
.lc \-
+----------------------------\kA+----------------------\kB\
-----------------------------------\kZ+
.nr A +(\w'+'/2)
.nr Z +(\w'+'/2)
\(br\h'1'Origin\h'1'/\h'1'Fix\h'1'/\h'1'Destination\h'|\nAu'\
\(br\h'|\nBu'Navigation Log\h'|\nZu'\(br
.\"
\(br\h'1'Comments\h'|\nAu'\(br\h'|\nZu'\(br
.\"
\(br\h'1'Freq\h'2'/\h'1.5'\k(L1Alt\h'1.5'/\h'1.3'\k(L2Type\h'|\nAu'\(br\
\h'1.5'CR\k(T1S\h'1'\kB\(br\
\h'1'Fr\k(T2eq\h'1'\kC\(br\
\h'2'\k(T3\h'2'\kD\(br\
\h'1.5'T\k(T4AS\h'1'\kE\(br\
\h'1'Le\k(T5g\h'1'\kF\(br\
\h'1'To\k(T6tal\h'1'\kG\(br\
\h'0.7'Fue\k(T7l/hr\h'|\nZu'\(br
.ta	\nAu \
 \n(T1uC \nBuL \
 \n(T2uC \nCuL \
 \n(T3uC \nDuL \
 \n(T4uC \nEuL \
 \n(T5uC \nFuL \
 \n(T6uC \nGuL \
 \n(T7uC \nZuL
\(br\a\(br\tHDG\t\(br\tRad\t\(br\t\t\(br\tEGS\t\
\(br\tETE\t\(br\tETA\t\(br\tLeg\t\(br
.\"
\(br Palo Alto\h'|\n(L2u'PAO\t\(br\tAirway\t\(br\tNM\t\(br\tID\t\
\(br\tAGS\t\(br\tATE\t\(br\tATA\t\(br\tTotal\t\(br
.\"
\(br Gnd 125.0, ATIS 120.6\h'|\nAu'\(br\
\a\a+\a\a+\a\a+\a\a+\a\a+\a\a+\a\a\(br
.\"
.\" This is the end of the preamble shared by both examples
.\"
\(br 118.6\h'|\n(L1u'5\h'|\n(L2u'Airport\t\(br\t120\t\(br\t117.1\t\
\(br\t280@10\t\(br\t115\t\(br\t149.9\t\(br\t149.9\t\(br\t0.0\t\(br
.\"
+\a>\t123\t\(br\t000\t\(br\t7500\t\(br\t123\t\(br\t1:13\t\(br\t1:13\t\
\(br\t0.0\t\(br
.\"
\(br Avenal\h'|\n(L2u'AVE\t\(br\t\t\(br\t0.0\t\(br\tAVE\t\(br\t\t\
\(br\t:\t\(br\t:\t\(br\t0.0\t\(br
.\"
\(br H Bakersfield FSS\t\(br\a\a+\a\a+\a\a+\a\a+\a\a+\a\a+\a\a\(br
.\"
\(br 117.1\h'|\n(L1u'710\h'|\n(L2u'VorTac\t\(br\t296\t\(br\t110.0\t\
\(br\t280@10\t\(br\t115\t\(br\t44.6\t\(br\t194.5\t\(br\t0.0\t\(br
.\"
+\a>\t293\t\(br\t000\t\(br\t7500\t\(br\t106\t\(br\t0:25\t\
\(br\t1:38\t\(br\t0.0\t\(br
.\"
\(br Priest\h'|\n(L2u'ROM\t\(br\t\t\(br\t0.0\t\(br\tROM\t\(br\t\t\
\(br\t:\t\(br\t:\t\(br\t0.0\t\(br
.\"
\(br L Paso Robles FSS\t\(br\a\a+\a\a+\a\a+\a\a+\a\a+\a\a+\a\a\(br
.\"
\(br 110.0\h'|\n(L1u'0\h'|\n(L2u'VOR\t\(br\t124\t\(br\t0.0\t\
\(br\t280@10\t\(br\t115\t\(br\t172.3\t\(br\t366.8\t\(br\t0.0\t\(br
.\"
+\a>\t127\t\(br\t000\t\(br\t7500\t\(br\t122\t\(br\t1:24\t\
\(br\t3:02\t\(br\t0.0\t\(br
.\"
\(br Los Angeles Int\h'|\n(L2u'LAX\t\(br\t\t\(br\t0.0\t\
\(br\tLAX\t\(br\t\t\(br\t:\t\(br\t:\t\(br\t0.0\t\(br
.\"
\(br\t\(br\a\a+\a\a+\a\a+\a\a+\a\a+\a\a+\a\a\(br
.\"
\(br 0.0\h'|\n(L1u'126\h'|\(L2u'Airport\t\(br
.\"
+\a
.\"
.DE
.Tr
.SH
Program Output
.LP
The  output  of the program consists of a Flight Plan that
provides navigation information for each leg of the planned flight.
Included are:
.RS
.IP "\fIcourse\fP - " 4
Magnetic course between the two fixes defining the leg.
.IP "\fIheading\fP - "
Magnetic heading for this leg, given the speed and winds aloft provided.
(If either winds aloft are omitted, a no wind condition is assumed.)
.IP "\fIairway\fP or \fIwaypoint number\fP - "
If an RNAV flight plan is requested, the waypoint number is prointed;
otherwise, the Victor Airway or Jet Route for this segment is printed
(if appropriate).
.IP "\fInavaid frequency\fP, and \fIwaypoint information\fP - "
The frequency of the navaid being used, if appropriate, and, if a
user-specified waypoint or an RNAV flight
is specified, the waypoint information (radial
and distance from the navaid).  Note that if altitude is provided and
this is an RNAV flight plan, slant range rather than distance from the
navaid will be provided for automatically generated waypoints.
.IP "\fIwinds aloft\fP - "
The winds aloft forecast provided for this leg.
.IP "\fIaltitude\fP - "
The altitude to be flown on this leg.
.IP "\fIfix\fP or \fInavaid identification\fP - "
The identifier for the fix or navaid defining the termination of the
leg.
.IP "\fItrue air speed\fP and \fIestimated ground speed\fP - "
True airspeed, if provided (zero otherwise), and estimated ground speed.
Estimated ground speed will be the same as TAS if no winds aloft
information is provided.  In addition, space is provided for writing in
the actual ground speed for the leg.
.IP "\fIdistance\fP and \fItime\fP - "
Length of the leg, and estimated time enroute, plus space to fill in the
actual time enroute.  Duplicated, then, for a running total.
.IP "\fIfuel burn\fP or \fIcost\fP - "
Depending on the specified option, the fuel burn or cost: rate, for the
leg, and cumulative total.
.RE
.sp 1
.SH
Database Files
.LP
The \fIairports.nav, vors.nav,\fP and \fIairways.nav\fP
files are ASCII text files. The
format for each file is given in a companion file, which has
a \fI.doc\fP suffix (e.g. airports.doc describes airports.nav).
You may
add airports, VORs, VORTACs, NDBs, TACANs, and intersections, and airways
to the files.  The current files include coverage for California,
Oregon and Nevada. Intersections may be added to the VORS file as
if the were vors with an altitude of -1; NDBs may be added to the
VORs file as if they were non-DME VORs.
.SH
Creating the Program
.LP
See the file \fIREADME.doc\fP for detailed instructions on building
\fBnav\fP.  The essence of it, though, is to use the \fImake\fP utility,
and type either
.sp 1
.ce
make
.sp 1
to create just the \fBnav\fP program, or
.sp 1
.ce
make All
.sp 1
to create the program, all documentation, and all the databases.
.SH
Options to nav
.LP
Options to the program are passed on the command line during
invocation.  Keywords are preceeded by "-" and followed by  zero,
one or more parameters.  Items enclosed in "<" and ">"  indicate
data to be supplied by the user.  Items enclosed by "[" and  "]"
indicate optional items that need not be present.
.sp 1
.DS
.ti -3
Synopsis:
nav [-from <id>] [-to <id>] [-[r]via <id> [...<id>]]
.in +4
[-speed <kts> [...<kts>]]
[-alt <feet> [...<feet>]]
[-wind <winds aloft> [...<winds aloft>]]
[-fuel <flow> [...<flow>] | -cost <rate> [...<rate>]]
[-com] [-form1 | -form2] [-nearest | -nearestall]
[-pos | -possec]
.sp 1
[-airports | -vors | -airways]
[-k <"character string">]
.sp 1
.in
Note that \fI-k, -airports, -vors,\fP and \fI-airways\fP each preclude
the use of any other options.
.DE
.LP
Descriptions of each option:
.RS
.IP "-from <id>" 1
the <id> of the airport from which the flight starts.  -from
is optional, if -to and -via (NOT -rvia) are specified.
.IP "-to <id>"
the <id> of the airport at which the flight terminates.  -to is
optional, if -from and -via (NOT -rvia) are specified.
.IP "-via <id> [ ...<id> ]"
the <id>s of the VORs, NDBs, VOR-DMEs, VORTACs, Intersections,
User Waypoints, and Victor Airways or Jet Routes to use for
navigation.  A User Waypoint is specified by a specification
such as Navaid/Radial/Distance (eg. sjc/145/10.6).  When airways
are used, -alt, -speed, and -wind data apply to those legs in
their entirety (see the examples for clarification).
\fIUse either -via or -rvia, not both.\fP
.IP "-rvia <id> [ ...<id> ]"
the  <id>s  of VORTACs to use for RNAV.  If an <id> is not  a
VOR-DME or VORTAC,  the waypoint will be over the VOR, NDB, or Intersection.
Use of Victor Airways or Jet Routes is not supported with -rvia.
If a waypoint should be over a VORDME/VORTAC, prepend an _ to
the navaid's name (eg. _OSI); if a User Waypoint (specified as
Navaid/Radial/Distance) is supplied, the plan will assume flight
over that waypoint is desired, rather than using that navaid as
the source for an RNAV waypoint.
\fIUse either -rvia or -via, not both.\fP
.IP "-alt <feet> [ ...<feet>]"
the altitude in feet for each leg of the flight. If
the -alt option is used, the RNAV distance from the
VORTAC will be actual slant range. If -alt is not
used, the RNAV distance with be horizontal range.
If there are fewer altitudes listed than legs then
the last supplied altitude will be used for the
remaining legs of the flight. If the numeric values
entered are less than 1000 they will be multiplied by 100.
.IP "-speed <kts> [ ...<kts>]"
the expected TAS in knots for each leg of the flight.
If the -speed option is used, the output will show
expected ground speed and time for each leg, as well
as elapsed time for the flight. If there are fewer
speeds listed than legs then the last speed supplied
will be used for the remainder of the legs.
.IP "-wind <wind> [ ...<wind>]"
the <wind> is in the same format as the "winds aloft"
forcast. For instance, 3320 is read as winds from 330
degrees (true north) at 20 knots. The <wind> is used
to adjust both the magnetic course and ground speed
for each leg of the flight. If there are fewer wind
entries supplied than legs for the flight then the
last supplied wind entry will be used for each
remaining leg of the flight.
.IP "-fuel <fuel flow> [ ...<fuel flow>]"
<fuel flow> designates the fuel flow rate for each leg of
the flight.  The -fuel option is valid only if -speed is
provided.  <fuel flow> can be in either pounds per hour
or gallons per hour (or liters per hour, for that matter),
as long as the units used are consistent for all legs.  The
flight log will show fuel flow for that leg, fuel used for
that leg, and cumulative fuel used.  Note that fuel information
is printed only if -form2 (the default) is specified, and that
-fuel is incompatible with -cost.
.IP "-cost <rate> [...<rate>]"
<rate> indicates the cost per hour of operating the airplane.
This option is similar to -fuel, though only one <rate>
specification is needed for a Hobbs or flight-hour rental.
The -cost option is incompatible with the -fuel option.
.IP "-pos"
print the position (latitude and longitude) of each
airport, navaid, intersection, and waypoint used.
.IP "-possec"
print position information as degrees:minutes:seconds,
rather than degrees:minutes.tenths
.IP "-com"
print the comments that apply to each <id>.
.IP "-form1"
select output format 1. Each line represents one
leg of the planned flight. NOTE: This option is
considered obsolete; continued support uncertain
(eg. fuel usage only shown on -form2).
.IP "-form2"
select output format 2. This is the default format.
This output resembles a Jeppeson Navigation Log.
.IP "-nearest"
print the two nearest navaids to the departure and
destination airports.  If both the departure (\fI-from\fP) and
destination (\fI-to\fP) airports are found in the user's local airports
database, only the local VORs database is searched.
.IP "-nearestall"
print the two nearest navaids to the departure and destination airports,
searching both the local and global databases.
.LP
The following options are incompatible with any other option, and must
be invoked alone.
.IP "-airports"
print the airports databases.
.IP "-vors"
print the vors databases.
.IP "-airways"
print the airways databases.
.IP "-k <string>"
search the airports and vors databases for <string>
and print any lines found containing <string>.
.RE
.LP
.DS
.ti 0
Following are some examples of program invocation.
nav -from lax -to pdx -rvia fim rom sck ila fjs eug -form1
.sp 1
nav -from pao -to rno -via sck hnw lta -speed 95 120 120 125
.sp 1
nav -from sjc -to sac -speed 125 -wind 2420 -com
.sp 1
.\" ***Note trailing space after backslash on following line
nav -from sfo -to lax -rvia sjc prb smo -alt 5000 15000 15000 \\\\
.ti +5
5000 -speed 250 400 400 200 -wind 2510 2740 2835 3015
.sp 1
nav -from emt -to sba -via vny -speed 100 -wind 2730 -nearest
.sp 1
.\" ***Note trailing space after backslash on following line
nav -from apc -to lax -via oak v107 sadde vtu -alt 85 190 70 30 \\\\ 
.ti +5
-speed 110 175 190 140 -wind 2810 3650 2715 -fuel 18 15.5 11.8
.sp 1
nav -from pao -to tvl -rvia oak sac _lta
.sp 1
nav -from pao -to ccr -via sfo/090/16.5 oak/093/10 -possec
.sp 1
nav -airports
.sp 1
nav -k gus
.DE
.LP
This program was initially posted by Linn Hower.  He got it from an
anonymous source.  Linn modified the program somewhat, and then Bob
Evans modified it substantially (many, many thanks to Bob for his
modifications, and for his help with this release).  I am always happy
to have suggestions for new features, clean-ups, etc.  Please remember:
ALWAYS check the output for reasonable results by comparing the output
against a WAC or Sectional chart.
.LP
.B
The pilot in command of an aircraft is directly responsible for, and is
the final authority as to, the operation of that aircraft (FAR 91.3).
Each pilot shall, before beginning a flight, familiarize him- or herself
with all available information concerning that flight (FAR 91.5).
.P
.LP
If you have any suggestions, enhancements, bug fixes (or bug reports),
please let me know.  Happy flying!
