/*
 *	Aviation navigation program
 *	Nav.h [2.16] from /preflight/src/nav/SCCS/hdr/s.Nav.h
 *		Retrieved 16:26:31 88/07/07; latest mod 16:02:04 88/07/07
 *	Defines and structs for nav navigation program
 *	Alan M. Marcum		sun!nescorna!marcum
 *	Robert J. Evans		pyramid!tolerant!procase!rje
 */
/* *********************************************************************** */
/*                                                                         */
/* Navigation Flight Plan Program                     NAV.H                */
/*                                                                         */
/* This program is public domain software.  No claim is made for the       */
/* accurracy of either the program or the databases used by the program.   */
/* Always check the flight plan provided by the program for reasonable     */
/* results.  The pilot in command of an aircraft is directly responsible   */
/* for, and is the final authority as to, the operation of that aircraft.  */
/* (FAR 91.3)  Each pilot in command shall, before beginning a flight,     */
/* familiarize himself with all available information concerning that      */
/* flight. (FAR 91.5)                                                      */
/*                                                                         */
/* *********************************************************************** */

#ifdef notdef
char	*sprintf();
#endif
char	*malloc();

#ifndef SysV
char	*strtok();
#endif	!SysV

#ifndef	BSD
#define index(s,c) strchr(s,c)
#endif	!BSD

extern int	errno;

#ifndef	NULL
#define		NULL	0
#endif
#ifndef TRUE
#define		TRUE	1
#endif
#ifndef FALSE
#define		FALSE	0
#endif

#define AIRPORTS        "airports.nav"
#define VORS            "vors.nav"
#define AIRWAYS		"airways.nav"

/*
 * Note that the array of database file descriptors is assumed to be
 * in order by preference -- we search the file descriptor array IN
 * ORDER, from 0 to MAX_DBs.
 */
#define PVT	0		/* Index of the private database file
				 * descriptors in the file descriptor array */
#define PUB	1		/* Index of the public descriptors */
#define MAX_DBs	2

#define RNAV_OVER_VORTAC	'_'	/* Precede VORTAC name with this
					 * character for RNAV routing
					 * directly over the VORTAC */
#define AIRWAY_SEPARATOR	'|'	/* Internal separator for airway
					 * identification */
#define AIRWAY_SEPARATOR_STG	"|"	/* Same, as a string */

/* Layout of nearest VORs array [note: currently N_NEAREST_VORS must be 2]*/
#define FROM_VORS_ORIG	0	/* Start of FROM's nearest VORs */
#define N_NEAREST_VORS	2	/* Number of nearest VORs */
#define TO_VORS_ORIG	(FROM_VORS_ORIG + N_NEAREST_VORS) /* TO's nearest */
#define TOT_NEAREST_VORS (TO_VORS_ORIG + N_NEAREST_VORS)

#define AWY_DELIMS	" :\t\n"	/* AIRWAYs token delimeters */
#define VOR_DELIMS	":"		/* VORs token delimeters */
#define COMMENT_CHAR	'#'		/* Comment line in databases */
#define RADSEP		'/'		/* Separator between VOR and RADIAL */
#define DMESEP		'/'		/* Ditto, between RADIAL and DME */

#define pi (3.1415926535897932384626433)

/* Exit codes for Find_Airway */
#define FindAirway_Error	0	/* Non-specific error */
#define FindAirway_NotFound	-1	/* Airway not found in airways file */
#define FindAirway_NoEntry	-2	/* Entry fix not on designated airway*/
#define FindAirway_NoExit	-3	/* Exit fix not on designated airway */

/* Various configuration size parameters */
#define MAXVIA 50        /* Maximum number of VORs in ViaArray */
#define MAXAPTS 2	 /* Just FROM and TO for now */
#define MAXVOR 50	 /* Maximum number of VORs in airway segment */
#define NAMLEN 33        /* Size of name field + EOS */
#define COMLEN 65        /* Size of comment field + EOS */
#define IDLEN 6          /* Size of ID field + EOS */
#define WPLEN 6          /* Size of WP field + EOS */
#define AWYLEN WPLEN	 /* Size of an Airway ID + EOS */
#define RADLEN 6	 /* Size of Radial spec (xxx.x) + EOS or separator */
#define DMELEN 6	 /* Size of DME spec (xxx.x) + EOS or separator */
#define VIALEN (IDLEN + RADLEN + DMELEN + 1) /* Potential size of a VIA name */
/*	Eg. SFO/126/10.3 is the 126 radial, 10.3 dme from SFO */

#define RECLEN_APTS	112		/* Record length for AIRPORTs file */
#define RECLEN_VORS	 96		/* 	"	     VORs	"  */


/* Codes for posflg (how to display -pos output) */
#define POS_TENTHS	1	/* ddd:mm.t */
#define POS_SECONDS	2	/* ddd:mm:ss */

/* Codes for output style */
#define FORMAT_OLD	1	/* Old style, line-per-leg format */
#define FORMAT_NEW	2	/* New style, flight-log format */

struct lat_lon {
        double rad;       /* radians */
        double deg;       /* decimal degrees */
};

struct fix {
        double radial;
        double nm;
        struct lat_lon lat;
        struct lat_lon lon;
};

struct vor {
        double var;               /* Magnetic variation in decimal degrees */
        struct fix loc;           /* Location of the VOR */
        float freq;               /* Radio frequency */
        int alt;                  /* Altitude of vor in feet */
	int rnavable;		  /* Can be used for RNAV waypoints */
	int on_airway;		  /* TRUE if this is on a selected airway */
	int vor_type;		  /* Type of navaid */
	int file_found;		/* Index of file where VOR found */
#define TYPELEN		13	/* Length+1 of the longest type string */
#define TYPE_UNDEFINED	-1	/* This is an unused VOR record */
#define CTYPE_UNDEFINED	"---"	/* Completeness...*/
#define LTYPE_UNDEFINED "*Undefined*"
#define TYPE_UNKNOWN	0	/* Who knows? */
#define CTYPE_UNKNOWN	"UNK"
#define LTYPE_UNKNOWN	"Unknown"
#define TYPE_NDB	1	/* An NDB */
#define CTYPE_NDB	"NDB"
#define LTYPE_NDB	"NDB"
#define TYPE_VOR	2	/* A VOR without any DME */
#define CTYPE_VOR	"VOR"
#define LTYPE_VOR	"VOR"
#define TYPE_VORTAC	3	/* A VOR-DME or VORTAC */
#define CTYPE_VORTAC	"DME"
#define LTYPE_VORTAC	"VorTac"
#define	TYPE_TACAN	4	/* A Military TACAN */
#define CTYPE_TACAN	"TAC"
#define LTYPE_TACAN	"Tacan"
#define TYPE_ILS	5	/* A Localizer */
#define CTYPE_ILS	"ILS"
#define LTYPE_ILS	"Localizer"
#define TYPE_INTERSECTION 6	/* An intersection */
#define CTYPE_INTERSECTION "INT"
#define LTYPE_INTERSECTION "Intersection"
#define TYPE_WAYPOINT	7	/* An RNAV waypoint */
#define CTYPE_WAYPOINT	"WPT"
#define LTYPE_WAYPOINT	"Waypoint"
#define TYPE_LOM	8	/* An Outer-Marker Compass-Locater */
#define CTYPE_LOM	"LOM"
#define LTYPE_LOM	"LocOutr Mkr"
#define TYPE_LMM	9	/* A Middle-Marker Compass-Locater */
#define CTYPE_LMM	"LMM"
#define LTYPE_LMM	"LocMid Mkr"
#define TYPE_AIRPORT	10	/* This is an airport */
#define CTYPE_AIRPORT	"APT"
#define LTYPE_AIRPORT	"Airport"
#define TYPE_TURNPOINT	11	/* An airway turning point */
#define CTYPE_TURNPOINT	"TPT"
#define LTYPE_TURNPOINT	"Turn Point"
#define TYPE_CROSSOVER	12	/* An airway cross-over point */
#define CTYPE_CROSSOVER	"CVR"
#define LTYPE_CROSSOVER	"Cross Over"
#define TYPE_USERWAYPOINT 13	/* A user-defined waypoint */
#define CTYPE_USERWAYPOINT "UWP"
#define LTYPE_USERWAYPOINT "User Wpt"
        char id[IDLEN];           /* Three letter ID */
        char name[NAMLEN];        /* Full name of VOR */
        char comments[COMLEN];    /* Comments (optional) */
        char waypoint[WPLEN];     /* Waypoint (not in VORS entry) */
};

#define TACAN_MIN	17	/* Lowest numbered TACAN channel */
#define TACAN_MAX	126	/* ...and the highest */

struct apt {
        double var;               /* Magnetic variation in decimal degrees */
        struct fix loc;           /* Location of the airport */
	float freq;		  /* Tower frequency */
        int alt;                  /* Altitude of airport in feet */
	int file_found;		  /* Index of file where airport was found */
        char id[IDLEN];           /* Three letter ID */
        char city[NAMLEN];        /* Name of nearest city */
        char name[NAMLEN];        /* Name of airport */
        char comments[COMLEN];    /* Comments (optional) */
};

typedef struct {		/* A course-speed vector */
	double	course,
		speed;
} vector;
