/*
 *	Aviation navigation program
 *	NavFormat.h [1.8] from /preflight/src/nav/SCCS/hdr/s.NavFormat.h
 *		Retrieved 16:26:30 88/07/07; latest mod 16:02:08 88/07/07
 *	Formatting strings for output of NAV navigation program
 *	See the end of this file (following the #ifdef COMMENT_TIME) for
 *	sample program output.
 *	Alan M. Marcum		marcum@nescorna.Sun.COM
 */
/* *********************************************************************** */
/*                                                                         */
/* Navigation Flight Plan Program                     FORMAT.H		   */
/*                                                                         */
/* This program is public domain software.  No claim is made for the       */
/* accurracy of either the program or the databases used by the program.   */
/* Always check the flight plan provided by the program for reasonable     */
/* results.  The pilot in command of an aircraft is directly responsible   */
/* for, and is the final authority as to, the operation of that aircraft.  */
/* (FAR 91.3)  Each pilot in command shall, before beginning a flight,     */
/* familiarize himself with all available information concerning that      */
/* flight. (FAR 91.5)                                                      */
/*                                                                         */
/* *********************************************************************** */

/* Sizes for some strings used in formatting things */

#define ALTSIZE	7
#define ETESIZE	7
#define ETASIZE	8

/*
 *	Header format strings
 */

/*	Global title for the output */
#define Title \
    "%48s %s"
/*	Flight Guide - Version X */


/*	Strings for Format 1 (old format) output */
#define F1Header1 \
    "| %-16s| CRS | Wind  |  Leg  |TAS | Rad | Dist  |  %-16.16s|\n"
/*	FROM						  TO */

#define F1Header2 \
    "| %-16s| HDG | Alt.  |  Time | GS | NM  | Time  |  %-16.16s|\n"
/*	FREQ/ID/ALT					FREQ/ID/ALT */


/*	Strings for Format 2 (new format) output */
#define F2Title1 \
    "| %-26.26s|%26.26s %-22.22s|\n"
/*	Origin/Fix/Destination		Navigation Log */

#define F2Title2 \
    "| %-26.26s|%50.50s\n"
/*	Comments	| */

#define F2Header1 \
    "| %-26.26s|  CRS | Freq| %-4.4s | TAS | Leg  |  Total |%s/hr|\n"
/*	Freq / Alt / Type	{Wind,}			    {Cost,Fuel} */

#define F2Header2 \
    "|---------------------------|  HDG | Rad |  %-3.3s | EGS | ETE  |\
   ETA  |  Leg  |\n"
/*						{Alt,} */



/*
 *	Individual leg format strings
 */

/*	Strings for Format 1 (old format) output */
#define F1Leg1 \
   "| %%-16.16s| %%03.0f | %s| %%5.1f |%%3d | %%03.0f | %%5.1f | %%-16.16s |\n"
/*   From_Name   Course  Wind  LegNM    TAS    WptRad  TotalNM     To_Name */

#define F1Leg2 \
    "|%%5.1f/%%5s/%%-5d| %%03.0f | %s | %%s |%%3d |%%4.1f |\
 %%s | %%5.1f/%%5s/%%-5d|\n"
/* From_Freq/Ident/Alt   Heading   Alt	  LegTime      GS    WptNM
 TotalTime   To_Freq/Ident/Alt */


/*	Strings for Format 2 (new format) output */
#define F2LegHeader \
   "| %%-20.20s %%-5.5s|%s| NM  |  ID  | AGS | ATE  |   ATA  | Total |\n"
/*	Name    Ident   {WP#,Airway} */

#define F2Leg1 \
    "| %%-5.1f  %%5d  %%12.12s|  %%03.0f |%%5.1f|%s| %%3d |%%6.1f| %%6.1f\
 |%s |\n"
/*     Freq    Alt    Type       Course    Freq  {Wind,} TAS  LegNM  TotNM
   {HrCost,HrFuel} */

#define F2Leg2a \
    "+--------------------------->  %%%%03.0f |  %%%%03.0f| %%s| %%%%3d |\
 %%%%s|  %%%%s |%s |\n"
/*				    Heading	WptRad  {Alt,FL}  EGS
   ETE    ETA  {LegCost,LegFuel} */

#define F2Leg3 \
    "| %%-20.20s %%-5.5s| %%-5.5s| %%4.1f| %%5.5s|     |   :  |\
    :   |%s |\n"
/*	Name	Ident  {Airway,WP#,} WptNM  ID
	 {TotCost,TotFuel} */

#define F2Leg4 \
    "| %-26.26s|------+-----+------+-----+------+--------+-------|\n"
/*	Comments */

#define F2Leg5 \
    "| %-5.1f  %5d  %12.12s|\n+----------------------------\n"
/*	Freq	Alt  Type */


/*
 * Format for elapsed times
 */

#define TimeFmt \
	"%2d:%.2d"


/*
 * Lat-Lon printing formats
 */

#define LLHeader \
    "\nFix Name                           Latitude   Longitude\n\
----------------                   --------   ---------\n"

#define LL1 \
    "%s %%3.0f:%%04.1f    %%3.0f:%%04.1f\n"
/*  Name [ID]  Lat (DD:MM.t)	Lon (DDD:MM.t) */

#define LL2 \
    "%s%%3.0f:%%02.0f:%%02.0f   %%3.0f:%%02.0f:%%02.0f\n"
/*  Name [ID]  Lat (DD:MM:SS)	Lon (DDD:MM:SS) */



/*
 * Nearest navaid formats
 */

#define NearestHeader \
    "\nAirport Name              Two Nearest Vors              Rad.    NM\n\
------------------------  ----------------------------  -----  ----\n"
#define Nearest1 \
    "%-16.16s [%3s]    %-16.16s (%3s/%5.1f)"
/*	Name  [ID]	Name	(ID/Freq) */

#define Nearest2 \
    "%-16.16s  %4s    %-16.16s (%3s/%5.1f)"
/*			Name	(ID/Freq) */

#define Nearest3 \
    "  %05.1f  %4.1f\n"
/*	Radial	NM */



#ifdef	COMMENT_TIME

Following output produced from
	nav -from pao -to lax -via ave -speed 140 190 -alt 110 200 -wind 3015 \
		-fuel 17 14.3 -pos -nearest

                        Flight Guide - Version 13
+---------------------------+-------------------------------------------------+
| Origin/Fix/Destination    |                Navigation Log                   |
| Comments                  |                                                 |
| Freq  / Alt / Type        |  CRS | Freq| Wind | TAS | Leg  |  Total |Fuel/hr|
|---------------------------|  HDG | Rad |  Alt | EGS | ETE  |   ETA  |  Leg  |
| Palo Alto            PAO  |Airway| NM  |  ID  | AGS | ATE  |   ATA  | Total |
| Gnd 125.0, ATIS 120.6     |------+-----+------+-----+------+--------+-------|
| 118.6      5       Airport|  120 |117.1|300@15| 140 | 149.9|  149.9 |  17.0 |
+--------------------------->  121 |  000| 11000| 154 | 00:58|  00:58 |  16.5 |
| Avenal               AVE  |      |  0.0|   AVE|     |   :  |    :   |  16.5 |
| H Bakersfield FSS         |------+-----+------+-----+------+--------+-------|
| 117.1    710        VorTac|  127 |  0.0|300@15| 190 | 128.3|  278.1 |  14.3 |
+--------------------------->  129 |  000| FL200| 204 | 00:37|  01:35 |   9.0 |
| Los Angeles Int      LAX  |      |  0.0|   LAX|     |   :  |    :   |  25.5 |
|                           |------+-----+------+-----+------+--------+-------|
| 0.0      126       Airport|
+---------------------------+

Fix Name                           Latitude   Longitude
----------------                   --------   ---------
Palo Alto               [PAO]       37:27.7    122:06.8
      Avenal            [AVE]       35:38.8    119:58.6
Los Angeles Int         [LAX]       33:56.5    118:24.4

Airport Name              Two Nearest Vors              Rad.  NM
------------------------  ----------------------------  ---- ----
Palo Alto        [PAO]    Moffett NAS      (NUQ/117.6)  287   3.2
                          Woodside         (OSI/113.9)  045   9.0

Los Angeles Int  [LAX]    Santa Monica     (SMO/110.8)  136   4.8
                          Los Angeles      (LAX/113.6)  053   1.3


And the following from the same, using -form1, without -pos and -nearest

                        Flight Guide - Version 13
+-----------------+-----+-------+-------+----+-----+-------+------------------+
| FROM            | CRS | Wind  |  Leg  |TAS | Rad | Dist  |  TO              |
| FREQ/ID/ALT     | HDG | Alt.  |  Time | GS | NM  | Time  |  FREQ/ID/ALT     |
+-----------------+-----+-------+-------+----+-----+-------+------------------+
| Palo Alto       | 120 | 300@15| 149.9 |140 | 000 | 149.9 | Avenal           |
|118.6/  PAO/5    | 121 | 11000 |  0:58 |154 | 0.0 | 00:58 | 117.1/  AVE/710  |
+-----------------+-----+-------+-------+----+-----+-------+------------------+
| Avenal          | 127 | 300@15| 128.3 |190 | 000 | 278.1 | Los Angeles Int  |
|117.1/  AVE/710  | 129 | FL200 |  0:37 |204 | 0.0 | 01:35 |   0.0/  LAX/126  |
+-----------------+-----+-------+-------+----+-----+-------+------------------+

#endif	COMMENT_TIME
