/*
 *	Aviation navigation program
 *	NavGlobals.h [1.5] from /preflight/src/nav/SCCS/hdr/s.NavGlobals.h
 *		Retrieved 16:26:33 88/07/07; latest mod 16:02:11 88/07/07
 *	Alan M. Marcum		marcum@nescorna.Sun.COM
 */

/* *********************************************************************** */
/*                                                                         */
/* Navigation Flight Plan Program                     NAVGLOBALS.H         */
/*                                                                         */
/* This program is public domain software.  No claim is made for the       */
/* accurracy of either the program or the databases used by the program.   */
/* Always check the flight plan provided by the program for reasonable     */
/* results.  The pilot in command of an aircraft is directly responsible   */
/* for, and is the final authority as to, the operation of that aircraft.  */
/* (FAR 91.3)  Each pilot in command shall, before beginning a flight,     */
/* familiarize himself with all available information concerning that      */
/* flight. (FAR 91.5)                                                      */
/*                                                                         */
/* *********************************************************************** */

#ifdef	GLOBAL_SPACE
#	define GLOBAL	extern
#else	!GLOBAL_SPACE
#	define GLOBAL
#endif	GLOBAL_SPACE

GLOBAL	void	ShowUsage(),	/* Print out some help */
		oops(),		/* Print out an error message */
		print_lat_lon(), /* Print out a lat-lon */
		print_vor(),	/* Print out a navaid's info */
		unparse_type();	/* Turn TYPE code into something readable */

GLOBAL	char	/**index(),*/
		*getenv();

GLOBAL	double	Radians(),	/* Convert degrees to radians */
		Degrees(),	/* ...and radians to degrees */
		Distance(),	/* Distance between two lat-lon points */
		Bearing(),	/* ...and bearing */
		Magnetic(),	/* Convert true to magnetic */
		LatIntercept();	/* Determine latitude intercept */

GLOBAL	float	tac_to_dme(),	/* Convert a TACAN channel into a DME freq */
		get_degrees(),	/* Extract degrees from decimal degrees */
		get_minutes(),	/* Extract minutes from dec. deg. */
		get_seconds();	/* Extract seconds from dec. deg. */

#if	(!defined(Sun) || defined(BSD4_3))
GLOBAL	double	rint();
#endif

GLOBAL	struct apt AptRecord;	/* airport record parsed from database */
GLOBAL	struct apt From, To;	/* airport record for origin, destination */
GLOBAL	struct vor VorRecord;	/* vor record parsed from database */
GLOBAL	struct vor ViaArray[MAXVIA];	/* vor records used for flight plan */
GLOBAL	struct vor Vors[TOT_NEAREST_VORS]; /* contains nearest N vor records
					    * for origin and destination
					    * airport.
					    * See nav.h for details. */
GLOBAL	struct fix WpFromLoc,	/* Used while computing RNAV waypoints */
		   WpToLoc;	/* Used while computing RNAV waypoints */

GLOBAL	int	AltArray[MAXVIA],	/* altitude for each leg of flight */
		WindArray[MAXVIA*2],	/* winds aloft for each leg */
		SpeedArray[MAXVIA];	/* speed in knots for each leg */
GLOBAL	float	FuelArray[MAXVIA];	/* Fuel flow for each leg */

GLOBAL	int AltC,                      /* number of entries in AltArray */
	    SpeedC,		/* number of entries in SpeedArray */
	    ViaC,		/* number of entries in ViaArray */
	    WindC,		/* number of entries in WindArray */
	    FuelC,		/* number of entries in FuelArray */
	    format,		/* controls report format - default = 2 */
	    apt_vors,		/* > 0, report vors nearest airport */
	    fromflg,		/* > 0 if command line has -from option */
	    toflg,		/* > 0 if command line has -to option */
	    viaflg,		/* > 0 if command line has -via option */
	    rviaflg,		/* > 0 if command line has -rvia option */
	    windflg,		/* > 0 if command line has -wind option */
	    speedflg,		/* > 0 if command line has -speed option */
	    fuelflg,		/* > 0 if command line has -fuel or -cost */
	    costflg,		/* > 0 if -cost used instead of -fuel */
	    altflg,		/* > 0 if command line has -alt option */
	    comflg,		/* > 0 if command line has -com option */
	    posflg,		/* > 0 if command line has -pos option */
	    AltDiff,		/* difference in altitude between vortac
				 * and flight altitude. */
	    nearestall,		/* Does user want all nearest, or just
				 * nearest in analogous file? */
	    v, v1, v2;		/* scratch counter */

GLOBAL	char	*p_airports,	/* File name for private airports database */
		*p_vors,	/* Ditto, vors */
		*p_airways;	/* Ditto, airways */

GLOBAL	FILE *fpa[MAX_DBs],	/* airport database files */
	     *fpv[MAX_DBs],	/* vor database files */
	     *fpw[MAX_DBs];	/* airways database files */

GLOBAL	double	dist_f[N_NEAREST_VORS],	/* distance from airports to... */
		dist_t[N_NEAREST_VORS],	/* ...nearest two vors, in nm. */
		rad_f[N_NEAREST_VORS],	/* radial from nearest vors to... */
		rad_t[N_NEAREST_VORS];	/* origin and destination airports */

GLOBAL	char VorIDs[MAXVIA][VIALEN],	/* list of vors from -via or -rvia */
	     AptIDs[2][IDLEN];		/* [0] = origin airport
					 * [1] = destination airport */

GLOBAL	char    *dir,		/* Directory where the stuff is */
		*pgm_name;	/* Name of program (argv[0]) */
