#! /bin/sh -u
#	Prototype preflight planner
#	newvers.sh [1.11] from /preflight/src/nav/SCCS/s.newvers.sh
#		Retrieved 16:26:10 88/07/07; latest mod 16:04:17 88/07/07
#
#	Create vers.c, to provide program release information
#	Syntax: newvers [-n | -m] [-r release_filename] [-p program_filename]
#		-n:	Do not update release_filename
#		-m:	Minor release (add 0.1 instead of 1)
#
#	Alan M. Marcum		marcum@nescorna.Sun.COM
#	@(#)newvers.sh	Revision 1.11	88/07/07

PATH=/usr/ucb:/bin:/usr/bin

ERROR=echo
BASENAME=basename
AWK=awk
ECHO=echo
CAT=cat
DATE=date

# Following settings are of echo's options, for BSD vs. SysV
# This is set up for BSD; if you have SysV, reverse the comments
UCBECHO=-n
SYS5ECHO=
#UCBECHO=
#SYS5ECHO='\c'

OPTIONS="[-n | -m] [-r release_filename] [-p program_filename]"

MAJOR_SCRIPT="{printf \$1 + 1 > \""
MAJOR_ARGS='-f.'

MINOR_SCRIPT="{printf \$1 + 0.1 > \""
MINOR_ARGS='-f '

CURRENT_SCRIPT=
CURRENT_ARGS='-f '

Name=`$BASENAME $0`

# Set up defaults
Release=release
Filename=NavVers.h
MinorRelease=0
NoUpdate=0

# Process arguments
while [ $# -ne 0 ]; do
	case "$1" in
	    -h ) # User wants help
		$ERROR 1>&2 $Name: Syntax: $Name $OPTIONS
		exit 0
		;;
	    -n ) # No update to release number
		if [ $MinorRelease -eq 1 ]; then
			$ERROR 1>&2 $Name: -n and -m incompatible
			exit 1
		fi
		NoUpdate=1
		shift
		;;
	    -m ) # Minor release
		if [ $NoUpdate -eq 1 ]; then
			$ERROR 1>&2 $Name: -n and -m incompatible
			exit 1
		fi
		MinorRelease=1
		shift
		;;
	    -r ) # Release filename
		if [ $# -lt 2 ]; then
			$ERROR 1>&2 $Name: -r requires filename
			exit 1
		fi
		Release=$2
		shift 2
		;;
	    -p ) # Program filename
		if [ $# -lt 2 ]; then
			$ERROR 1>&2 $Name: -p requires filename
			exit 1
		fi
		Filename=$2
		shift 2
		;;
	    * )	# User goofed
		$ERROR 1>&2 "$Name: Unknown option ($1)"
		$ERROR 1>&2 $Name: Syntax: $Name $OPTIONS
		exit 1
		;;
	esac
done

if [ $MinorRelease -eq 1 ]; then
	AwkScript="$MINOR_SCRIPT$Release\"}"
	AwkArgs="$MINOR_ARGS"
elif [ $NoUpdate -eq 1 ]; then
	AwkScript="$CURRENT_SCRIPT"
	AwkArgs="$CURRENT_ARGS"
else
	AwkScript="$MAJOR_SCRIPT$Release\"}"
	AwkArgs="$MAJOR_ARGS"
fi

if [ ! -r $Release ]; then $ECHO $UCBECHO 0$SYS5ECHO > $Release; fi
$AWK "$AwkArgs" "$AwkScript" < $Release
if [ $? -ne 0 ]; then exit 1; fi

$ECHO "#ifndef	LINT" > $Filename
$ECHO "static char Release[] = " >> $Filename
$ECHO -n '	"@(#)Aviation Navigation Program Release ' >> $Filename
$ECHO -n "`$CAT $Release` of `$DATE +%d%h%y\ %T`" >> $Filename
$ECHO '";' >> $Filename
$ECHO "#endif	LINT" >> $Filename
$ECHO -n 'char	*RELEASE = "' >> $Filename
$ECHO -n "`$CAT $Release`" >> $Filename
$ECHO '";' >> $Filename
