/*
 *	Aviation navigation program
 *	file.c [2.26] from /preflight/src/nav/SCCS/src/s.file.c
 *		Retrieved 16:26:43 88/07/07; latest mod 16:02:51 88/07/07
 *	Alan M. Marcum		marcum@nescorna.Sun.COM
 *	Robert J. Evans		tolerant!procase!rje
 */

#ifndef	LINT
static char *SCCSid = "@(#)file.c\tRevision 2.26\t88/07/07";
#endif

/***************************************************************************
 *
 * Navigation Flight Plan Program
 *
 * This program is public domain software.  No claim is made for the
 * accurracy of either the program or the databases used by the program.
 * Always check the flight plan provided by the program for reasonable
 * results.  The pilot in command of an aircraft is directly responsible
 * for, and is the final authority as to, the operation of that aircraft.
 * (FAR 91.3)  Each pilot in command shall, before beginning a flight,
 * familiarize himself with all available information concerning that
 * flight. (FAR 91.5)
 *
 ***************************************************************************/

#include <stdio.h>
#include <ctype.h>
#ifdef	SysV
#include	<string.h>
#else	!SysV
#include	<strings.h>
#endif	SysV
#include <Nav.h>
#include <NavGlobals.h>

#define min(x, y)	((x) < (y) ? (x) : (y))
#define max(x, y)	((x) > (y) ? (x) : (y))
#define abs(x)		((x) < 0 ? (-(x)) : (x))

#define DEFAULT_CTAF	0.0		/* 122.8 sometime? */
#define UNKNOWN_CTAF	0.0

char	*binary_search();
double	atof();
int	extend_int(),
	extend_dbl(),
	copy_arr_c(),
	copy_arr_i(),
	copy_arr_f();
void	uppit();

/* *********************************************************************** */
/*  LineToVor converts a line from the vors databases file to a Vor record.*/
/*  Returns: Vor record or NULL.                                           */
/*  Parameter: line record from vor database.                              */
/*  Side Effects: none.                                                    */
/* *********************************************************************** */
struct vor *
LineToVor(s)
char	*s;
{ /* LineToVor() */
	struct vor	*buf;
        char	*p,
		*q;
        double	minutes;

	char	tbuf[BUFSIZ];		/* For holding the user's line */
	int	ssize;

	if (NULL == (buf = (struct vor *)malloc(sizeof(struct vor)))) {
	        (void)perror("LineToVor: could not allocate space");
		(void)fprintf(stderr, "%s: aborting.\n");
		(void)exit(1);
	}

	ssize = strlen(s);
	(void)strncpy(tbuf, s, ssize);	/* Keep it safe */

        p = s;
        q = index(p,':');
        if (q == NULL) {
		(void)strncpy(s, tbuf, ssize);	/* Restore the line */
		return(NULL);			/* Say it's bad */
	}
        q[0] = '\0';
        (void)strcpy(buf->id,p);                /* copy in the id */
        (void)strncpy(buf->waypoint, "      ", WPLEN);
        p = q+1;
        q = index(p,':');
        if (q == NULL) {
		(void)strncpy(s, tbuf, ssize);
		return(NULL);
	}
        q[0] = '\0';
        (void)strcpy(buf->name,p);                /* copy in the name */
        p = q+1;
        q = index(p,':');
        if (q == NULL) {
		(void)strncpy(s, tbuf, ssize);
		return(NULL);
	}
        q[0] = '\0';
        buf->freq = (float)atof(p);        /* frequency */
        p = q+1;
        q = index(p,':');
        if (q == NULL) {
		(void)strncpy(s, tbuf, ssize);
		return(NULL);
	}
        q[0] = '\0';
        buf->alt = atoi(p);                /* vor altitude in feet */
        p = q+1;
        q = index(p,':');
        if (q == NULL) {
		(void)strncpy(s, tbuf, ssize);
		return(NULL);
	}
        q[0] = '\0';
        buf->var = atof(p);                /* variation in degrees */
        p = q+1;
        q = index(p,':');
        if (q == NULL) {
		(void)strncpy(s, tbuf, ssize);
		return(NULL);
	}
        q[0] = '\0';
        minutes = atof(p) / 60;                /* add variation minutes */
        buf->var += buf->var<0 ? (0. - minutes) : minutes;
        p = q+1;
        q = index(p,':');
        if (q == NULL) {
		(void)strncpy(s, tbuf, ssize);
		return(NULL);
	}
        q[0] = '\0';
        buf->loc.lat.deg = atof(p);        /* north degrees */
        p = q+1;
        q = index(p,':');
        if (q == NULL) {
		(void)strncpy(s, tbuf, ssize);
		return(NULL);
	}
        q[0] = '\0';
        minutes = atof(p) / 60;                /* add north minutes */
        buf->loc.lat.deg += buf->loc.lat.deg<0 ? (0. - minutes) : minutes;
        buf->loc.lat.rad = Radians(buf->loc.lat.deg);
        p = q+1;
        q = index(p,':');
        if (q == NULL) {
		(void)strncpy(s, tbuf, ssize);
		return(NULL);
	}
        q[0] = '\0';
        buf->loc.lon.deg = atof(p);        /* west degrees */
        p = q+1;
        q = index(p,':');
        if (q == NULL) {
		(void)strncpy(s, tbuf, ssize);
		return(NULL);
	}
        q[0] = '\0';
        minutes = atof(p) / 60;                /* add west minutes */
        buf->loc.lon.deg += buf->loc.lon.deg<0 ? (0. - minutes) : minutes;
        buf->loc.lon.rad = Radians(buf->loc.lon.deg);

        p = q+1;
        q = index(p,':');
        if (q == NULL) {
                buf->vor_type = TYPE_UNKNOWN;	/* Default */
		(void)strncpy(buf->comments, "", sizeof(buf->comments));
	} else {
	        q[0] = '\0';
	        buf->vor_type = parse_type(p);           /* Set the type */
	        p = q+1;
		if (! *p)
			return NULL;
		if (NULL != (q = index(p,'\n')))
			q[0] = '\0';
		else	p[strlen(p)] = '\0';
	        (void)strncpy(buf->comments, p, sizeof(buf->comments));
	}
	buf->rnavable = TYPE_VORTAC == buf->vor_type;
	(void)strncpy(s, tbuf, ssize);
	buf->file_found = -1;	/* Initialize */
        return(buf);
} /* LineToVor() */


/* *********************************************************************** */
/*  LineToApt converts a line from the airport database file to an Airport */
/*            record.                                                      */
/*  Returns: Airport record or NULL.                                       */
/*  Parameter: line record from Airport database.                          */
/*  Side Effects: none.                                                    */
/* *********************************************************************** */
struct apt *
LineToApt(s)
char	*s;
{ /* LineToApt() */

        struct apt	*buf;
        char	*p,
		*q;
        double	minutes;

	char	tbuf[BUFSIZ];
	int	ssize;

	if (NULL == (buf = (struct apt *)malloc(sizeof(struct apt)))) {
	        (void)perror("LineToApt: could not allocate space");
		(void)fprintf(stderr, "%s: aborting.\n");
		(void)exit(1);
	}

	ssize = strlen(s);
	(void)strncpy(tbuf, s, ssize);	/* Save for diagnostics later */

        p = s;
        q = index(p,':');
        if (q == NULL) {
		(void)strncpy(s, tbuf, ssize);	/* Restore user's line */
		return(NULL);			/* Say we have a problem */
	}
        q[0] = '\0';
        (void)strcpy(buf->id,p);                /* copy in the id */
        p = q+1;
        q = index(p,':');
        if (q == NULL) {
		(void)strncpy(s, tbuf, ssize);
		return(NULL);
	}
        q[0] = '\0';
        (void)strcpy(buf->city,p);                /* city closest to airport */
        p = q+1;
        q = index(p,':');
        if (q == NULL) {
		(void)strncpy(s, tbuf, ssize);
		return(NULL);
	}
        q[0] = '\0';
        (void)strcpy(buf->name,p);                /* name of airport */
        p = q+1;
        q = index(p,':');
        if (q == NULL) {
		(void)strncpy(s, tbuf, ssize);
		return(NULL);
	}
        q[0] = '\0';
        buf->alt = atoi(p);                /* airport altitude in feet */
        p = q+1;
        q = index(p,':');
        if (q == NULL) {
		(void)strncpy(s, tbuf, ssize);
		return(NULL);
	}
        q[0] = '\0';
        buf->var = atof(p);                /* variation in decimal degrees */
        p = q+1;
        q = index(p,':');
        if (q == NULL) {
		(void)strncpy(s, tbuf, ssize);
		return(NULL);
	}
        q[0] = '\0';
        minutes = atof(p) / 60;                /* add variation minutes */
        buf->var += buf->var<0 ? (0. - minutes) : minutes;
        p = q+1;
        q = index(p,':');
        if (q == NULL) {
		(void)strncpy(s, tbuf, ssize);
		return(NULL);
	}
        q[0] = '\0';
        buf->loc.lat.deg = atof(p);        /* north degrees */
        p = q+1;
        q = index(p,':');
        if (q == NULL) {
		(void)strncpy(s, tbuf, ssize);
		return(NULL);
	}
        q[0] = '\0';
        minutes = atof(p) / 60;                /* add north minutes */
        buf->loc.lat.deg += buf->loc.lat.deg<0 ? (0. - minutes) : minutes;
        buf->loc.lat.rad = Radians(buf->loc.lat.deg);
        p = q+1;
        q = index(p,':');
        if (q == NULL) {
		(void)strncpy(s, tbuf, ssize);
		return(NULL);
	}
        q[0] = '\0';
        buf->loc.lon.deg = atof(p);        /* west degrees */
        p = q+1;
        q = index(p,':');
        if (q == NULL) {
		(void)strncpy(s, tbuf, ssize);
		return(NULL);
	}
        q[0] = '\0';
        minutes = atof(p) / 60;                /* add west minutes */
        buf->loc.lon.deg += buf->loc.lon.deg<0 ? (0. - minutes) : minutes;
        buf->loc.lon.rad = Radians(buf->loc.lon.deg);

        p = q+1;
        q = index(p,':');
        if (q == NULL) {
                buf->freq = UNKNOWN_CTAF;
		(void)strncpy(buf->comments, "", sizeof(buf->comments));
	} else {
		q[0] = '\0';
		if (strlen(p) == 0)
		        buf->freq = DEFAULT_CTAF;
		else	buf->freq = atof(p);            /* CTAF */
	        p = q+1;
	        if (! *p)		/* No comments */
			(void)strncpy(buf->comments,
				      "",
				      sizeof(buf->comments));
		else {
			if (NULL != (q = index(p,'\n')))
				q[0] = '\0';
			else	p[strlen(p)] = '\0';
		        (void)strncpy(buf->comments, p, sizeof(buf->comments));
		}
	}
	(void)strncpy(s, tbuf, ssize);	/* Restore user's line */
	buf->file_found = -1;	/* Initialize */
        return(buf);
} /* LineToApt() */

/* Determine the type of this navaid, returning same. */
int
parse_type(string)
char	*string;
{
        if (uplowcmp(string, CTYPE_UNKNOWN, 3)) return(TYPE_UNKNOWN);
	else if (uplowcmp(string, CTYPE_NDB, 3)) return(TYPE_NDB);
	else if (uplowcmp(string, CTYPE_VOR, 3)) return(TYPE_VOR);
	else if (uplowcmp(string, CTYPE_VORTAC, 3)) return(TYPE_VORTAC);
	else if (uplowcmp(string, CTYPE_TACAN, 3)) return(TYPE_TACAN);
	else if (uplowcmp(string, CTYPE_ILS, 3)) return(TYPE_ILS);
	else if (uplowcmp(string, CTYPE_INTERSECTION, 3))
		return(TYPE_INTERSECTION);
	else if (uplowcmp(string, CTYPE_WAYPOINT, 3)) return(TYPE_WAYPOINT);
	else if (uplowcmp(string, CTYPE_LOM, 3)) return(TYPE_LOM);
	else if (uplowcmp(string, CTYPE_LMM, 3)) return(TYPE_LMM);
	else if (uplowcmp(string, CTYPE_TURNPOINT, 3)) return(TYPE_TURNPOINT);
	else if (uplowcmp(string, CTYPE_CROSSOVER, 3)) return(TYPE_CROSSOVER);
	else return(TYPE_UNKNOWN);
} /* parse_type */


/* Compares two strings, each of N characters.  Returns TRUE if they are the
 * same, ignoring case.
 */
int
uplowcmp(s1, s2, n)
char	*s1,
	*s2;
int	n;
{ /* uplowcmp() */
	char	*buf1,
		*buf2;
	int	tmp;

	if (NULL == (buf1 = malloc((unsigned)n)) ||
	    NULL == (buf2 = malloc((unsigned)n)))
		oops("Cannot allocate needed space");
	(void)strncpy(buf1, s1, n);		uppit(buf1);
	(void)strncpy(buf2, s2, n);		uppit(buf2);
	tmp = strncmp(buf1, buf2, n);
	(void)free(buf1);
	(void)free(buf2);

	return(0 == tmp);
} /* uplowcmp() */
