/*
 *	Aviation navigation program
 *	getairports.c [1.2] from /preflight/src/nav/SCCS/src/s.getairports.c
 *		Retrieved 16:26:57 88/07/07; latest mod 16:03:01 88/07/07
 *	Alan M. Marcum		marcum@nescorna.Sun.COM
 *	Robert J. Evans		tolerant!procase!rje
 */

#ifndef	LINT
static char *SCCSid = "@(#)getairports.c\tRevision 1.2\t88/07/07";
#endif

/***************************************************************************
 *
 * Navigation Flight Plan Program
 *
 * This program is public domain software.  No claim is made for the
 * accurracy of either the program or the databases used by the program.
 * Always check the flight plan provided by the program for reasonable
 * results.  The pilot in command of an aircraft is directly responsible
 * for, and is the final authority as to, the operation of that aircraft.
 * (FAR 91.3)  Each pilot in command shall, before beginning a flight,
 * familiarize himself with all available information concerning that
 * flight. (FAR 91.5)
 *
 ***************************************************************************/

#include <stdio.h>
#include <ctype.h>
#ifdef	SysV
#include	<string.h>
#else	!SysV
#include	<strings.h>
#endif	SysV
#include <Nav.h>
#include <NavGlobals.h>

char	*binary_search();
void	uppit();
struct	apt	*LineToApt();

/**************************************************************************
 * GetApts reads lines from the airport database and looks for a match on
 *         the id field for the From and to_ap airport id.
 * Returns: number of airports found.
 * Parameters: from_ap - airport record for origin airport.
 *             to_ap   - airport record for destination airport.
 *             apt_ids - airport ids for origin and destination airports.
 *                      [0] = origin airport id.
 *                      [1] = destination airport id.
 *             scratch_ap - scratch airport record to pass to LineToApt.
 *             fp   - file pointers to airport database files.
 * Side Effects: stores airport records into from_ap, to_ap, and
 *		 scratch_ap; puts NULL into apt_ids[n][0] if the ID is
 *		 matched.
 ***************************************************************************/
int
GetApts(from_ap, to_ap, apt_ids, scratch_ap, fp, napts)
struct apt	*from_ap,
		*to_ap,
		*scratch_ap;
char	apt_ids[2][IDLEN];
FILE	*fp[MAX_DBs];
int	napts;			/* Number of airports to be found */
{ /* GetApts() */
#ifdef	BIN_SEARCH
char	*line;
#else	!BIN_SEARCH
char	line[BUFSIZ];
#endif	BIN_SEARCH

int	cnt,
	i;
#ifdef	BIN_SEARCH
int	j;
struct apt	*airports[MAXAPTS];
#endif	BIN_SEARCH

if (napts > MAXAPTS) {
        (void)fprintf(stderr,
	        "napts (%d) > MAXAPTS (%d) in GetApts; something is wrong\n", 
		 napts, MAXAPTS);
	(void)exit(1);
}

cnt = 0;

#ifdef	BIN_SEARCH
if (NULL == (line = malloc(BUFSIZ))) {
        (void)perror("nav: GetApts could not allocate space");
	(void)exit(1);
}
for (i = 0; i < MAXAPTS; i++) airports[i] = NULL;
#endif	BIN_SEARCH

for (i = 0; i < MAXAPTS; i++) uppit(apt_ids[i]);

for (i = 0; i < MAX_DBs; i++)		/* Go through all available databases*/
    if (fp[i] != NULL)			/* If something's there, use it */
#ifdef	BIN_SEARCH
	for (j = 0; j < MAXAPTS; j++) {		/* Find each airport */
		if (airports[j] == NULL && 0 != strlen(apt_ids[j])) {
			if (NULL != (line = binary_search(fp[i],
							  apt_ids[j], 
							  RECLEN_APTS))) {
				scratch_ap = LineToApt(line);
				if (scratch_ap == NULL) {
					(void)printf(
				    "\nLineToApt returned NULL on line\n%s\n",
						     line);
					return(NULL);
				}
				airports[j] = scratch_ap;
				airports[j]->file_found = i;
				cnt++;
				apt_ids[j][0] = '\0';
			}
		}
	}
	if (airports[0] != NULL) *from_ap = *airports[0];
	if (airports[1] != NULL) *to_ap = *airports[1];
	return(cnt);
#else	!BIN_SEARCH
        while ((fgets(line, sizeof line, fp[i]) != NULL) && cnt < napts) {
                if (line[0] == '#') continue;	/* Comment line */
                scratch_ap = LineToApt(line);
                if (scratch_ap == NULL){
                        (void)printf("\nLineToApt returned NULL on line\n%s\n",
			       line);
                        return(NULL);
                }
                if (strcmp(scratch_ap->id,apt_ids[0]) == 0)
                {
                        cnt++;
                        apt_ids[0][0] = '\0';
                        *from_ap = *scratch_ap;
			from_ap->file_found = i;
                }
                if (strcmp(scratch_ap->id,apt_ids[1]) == 0)
                {
                        cnt++;
                        apt_ids[1][0] = '\0';
                        *to_ap = *scratch_ap;
			to_ap->file_found=i;
                }
        }
        return cnt;
#endif	BIN_SEARCH
} /* GetApts() */
