/*
 *	Aviation navigation program
 *	Obtain the command line arguments
 *	getargs.c [1.2] from /preflight/src/nav/SCCS/src/s.getargs.c
 *		Retrieved 16:26:52 88/07/07; latest mod 16:02:47 88/07/07
 *	Alan M. Marcum		marcum@nescorna.Sun.COM
 *	Robert J. Evans		tolerant!procase!rje
 */

#ifndef	LINT
static char *SCCSid = "@(#)getargs.c\tRevision 1.2\t88/07/07";
#endif

/* *********************************************************************** */
/*                                                                         */
/* Navigation Flight Plan Program                     GETARGS.C            */
/*                                                                         */
/* This program is public domain software.  No claim is made for the       */
/* accurracy of either the program or the databases used by the program.   */
/* Always check the flight plan provided by the program for reasonable     */
/* results.  The pilot in command of an aircraft is directly responsible   */
/* for, and is the final authority as to, the operation of that aircraft.  */
/* (FAR 91.3)  Each pilot in command shall, before beginning a flight,     */
/* familiarize himself with all available information concerning that      */
/* flight. (FAR 91.5)                                                      */
/*                                                                         */
/* *********************************************************************** */
#include <stdio.h>
#ifdef	SysV
#include	<string.h>
#else	!SysV
#include	<strings.h>
#endif	SysV
#include <Nav.h>
#include <NavGlobals.h>

/* Despite appearances, this is a subroutine, NOT a main routine */
void
scan_command_line(argc, argv)
int	argc;
char	*argv[];
{ /* scan_command_line */

/* Search command for -k option */
#define SEARCH_CMD	"grep -i"

        /* Scan the command line and parse the options */

	int	result,			/* Temps for SYSTEM results */
	        result1;
	int	temp;			/* Temp result for comparisons */
	char	sysbuf[BUFSIZ];		/* used for system calls */


        argc--;argv++;
        while(argc){
		/*
		 * -from <origin airport id>
		 */
                if (strcmp(*argv,"-from") == 0){
                        argc--;argv++;
                        if(!argc || **argv == '-')
                                ShowUsage("from: Missing departure ID");
                        if (fromflg)
                                ShowUsage("from: Two departure points?");
                        (void)strcpy(AptIDs[0], *argv);
                        fromflg++;
                        argc--;argv++;
		/*
		 * -to <destination airport id>
		 */
                }else if (strcmp(*argv,"-to") == 0){
                        argc--;argv++;
                        if(!argc || **argv == '-')
                                ShowUsage("to: Missing destination ID");
                        if (toflg)
                                ShowUsage("to: Two destinations?");
                        (void)strcpy(AptIDs[1], *argv);
                        toflg++;
                        argc--;argv++;
		/*
		 * -via <vor id ... vor id>
		 */
                }else if (strcmp(*argv,"-via") == 0){
                        argc--;argv++;
                        if(!argc || **argv == '-')
                                ShowUsage("via: Missing VOR ID(s)");
                        if (viaflg)
                                ShowUsage("via: One set of 'via' VORs please");
                        for(ViaC=0;
                        argc && (**argv != '-') && (ViaC < MAXVIA);
                        ViaC++){
                                (void)strcpy(VorIDs[ViaC], *argv);
                                argc--;argv++;
                        }
                        viaflg++;
		/*
		 * -rvia <vor id ... vor id>
		 */
                }else if (strcmp(*argv,"-rvia") == 0){
                        argc--;argv++;
                        if(!argc || **argv == '-')
                                ShowUsage("rvia: Missing VOR ID(s)");
                        if (rviaflg)
                                ShowUsage("rvia: One set of 'rvia' VORs.");
                        for(ViaC=0;
                        argc && (**argv != '-') && (ViaC < MAXVIA);
                        ViaC++){
                                (void)strcpy(VorIDs[ViaC], *argv);
                                argc--;argv++;
                        }
                        rviaflg++;
		/*
		 * -alt <altitude ... altitude>
		 */
                }else if (strcmp(*argv,"-alt") == 0){
                        argc--;argv++;
                        if(!argc || **argv == '-')
                                ShowUsage("alt: Missing ALTITUDE ");
                        if (altflg)
                                ShowUsage("alt: One set of ALTITUDEs.");
                        for(AltC=0;
                            argc && (**argv != '-') && (AltC < MAXVIA);
                            AltC++){
                                if (0 != StoreAlt(AltArray,AltC,*argv)){
                                        (void)fprintf(stderr,
                                            "alt: Altitude not found\n",*argv);
                                        (void)exit(1);
                                }
                                argc--;argv++;
                        }
                        altflg++;
		/*
		 * -wind <winds aloft ... winds aloft>
		 */
                }else if (0 == strcmp(*argv,"-wind")){
                        argc--;argv++;
                        if(!argc || **argv == '-')
                                ShowUsage("wind: Missing WINDS ALOFT ");
                        if (windflg)
                                ShowUsage("wind: One set of WINDS ALOFT.");
                        for(WindC=0;
                            argc && (**argv != '-') && (WindC < MAXVIA);
                            WindC += 2){
                                if (0 != StoreWind(WindArray, &WindC, *argv)){
                                        (void)fprintf(stderr,
                                            "wind: WINDS ALOFT error\n",*argv);
                                        (void)exit(1);
                                }
                                argc--;argv++;
                        }
                        windflg++;
		/*
		 * -speed <knots .. knots>
		 */
                }else if (0 == strcmp(*argv,"-speed")) {
                        argc--;argv++;
                        if (!argc || **argv == '-')
                                ShowUsage("speed: Missing AIRSPEED ");
                        if (speedflg)
                                ShowUsage("speed: One set of AIRSPEEDs.");
                        for (SpeedC=0;
			     argc && (**argv != '-') && (SpeedC < MAXVIA);
			     SpeedC++){
                                if (0 != StoreSpeed(SpeedArray,SpeedC,*argv)) {
                                        (void)fprintf(stderr,
                                                "speed: AIRSPEED not found\n",
						*argv);
                                        (void)exit(1);
                                }
                                argc--;argv++;
                        }
                        speedflg++;
		/*
		 * -fuel <gph/pph ... gph/pph> and -cost <rate ... rate>
		 */
                }else if ((temp = (0 == strcmp(*argv, "-cost"))) ||
			   0 == strcmp(*argv, "-fuel")) {
                        argc--;argv++;
			costflg = temp;
                        if (!argc || **argv == '-')
				if (costflg)
					ShowUsage("cost: Missing RATE");
                                else	ShowUsage("fuel: Missing FUEL FLOW");
                        if (fuelflg)
				ShowUsage(
				  "cost/fuel: One set of RATEs or FUEL FLOWs");
                        for (FuelC=0;
			     argc && (**argv != '-') && (FuelC < MAXVIA);
			     FuelC++) {
				if (0 != StoreFuel(FuelArray, FuelC, *argv))
					if (costflg)
						ShowUsage(
						      "cost: RATEs not found");
                                        else	ShowUsage(
                                                 "fuel: FUEL FLOWs not found");
                                argc--;argv++;
                        }
                        fuelflg++;
		/*
		 * -pos
		 */
		}else if (0 == strcmp(*argv, "-pos")) {
		        posflg = POS_TENTHS;
			argc--;
			argv++;
		/*
		 * -possec
		 */
		}else if (0 == strcmp(*argv, "-possec")) {
			posflg = POS_SECONDS;
			argc--;
			argv++;
		/*
		 * -com
		 */
                }else if (0 == strcmp(*argv,"-com")){
                        comflg++;
                        argc--;argv++;
		/*
		 * -form1
		 */
                }else if (0 == strcmp(*argv, "-form1")) {
                        format = 1;
                        argc--;argv++;
		/*
		 * -form2
		 */
                }else if (0 == strcmp(*argv, "-form2")) {
                        format = 2;
                        argc--;argv++;
		/*
		 * -nearest
		 */
                }else if (0 == strcmp(*argv, "-nearest")) {
                        apt_vors = 1;
			nearestall = 0;
                        argc--;argv++;
		/*
		 * -nearestall
		 */
                }else if (0 == strcmp(*argv, "-nearestall")) {
                        nearestall = 1;
			apt_vors = 1;
                        argc--;argv++;
		/*
		 * -airports
		 */
                }else if (0 == strcmp(*argv, "-airports")) {
                        (void)sprintf(sysbuf, "cd %s; /usr/ucb/more %s %s",
				      dir, p_airports, AIRPORTS);
                        (void)exit(system(sysbuf));
		/*
		 * -vors
		 */
                }else if (0 == strcmp(*argv, "-vors")) {
                        (void)sprintf(sysbuf, "cd %s; /usr/ucb/more %s %s",
				      dir, p_vors, VORS);
                        (void)exit(system(sysbuf));
		/*
		 * -airways
		 */
                }else if (0 == strcmp(*argv, "-airways")) {
                        (void)sprintf(sysbuf, "cd %s; /usr/ucb/more %s %s",
				      dir, p_airways, AIRWAYS);
                        (void)exit(system(sysbuf));
		/*
		 * -k	[search databases]
		 */
                }else if (0 == strcmp(*argv,"-k")){ 
                        argc--;argv++;
                        if (!argc) ShowUsage("-k: missing keyword or pattern");
			result = 0;
			if (NULL != p_airports) {
	                        (void)sprintf(sysbuf,"%s %s %s",
					      SEARCH_CMD, *argv, p_airports);
			        result = system(sysbuf);
			}
			if (NULL != p_vors) {
	                        (void)sprintf(sysbuf,"%s %s %s",
					      SEARCH_CMD, *argv, p_vors);
			        if (0 != (result1 = system(sysbuf)))
					result = result1;
			}
			if (NULL != p_airways) {
	                        (void)sprintf(sysbuf,"%s %s %s",
					      SEARCH_CMD, *argv, p_airways);
			        if (0 != (result1 = system(sysbuf)))
					result = result1;
			}

                        (void)sprintf(sysbuf,"cd %s; %s %s %s",
				      dir, SEARCH_CMD, *argv, AIRPORTS);
                        if (0 != (result1 = system(sysbuf)))
				result = result1;
                        (void)sprintf(sysbuf,"cd %s; %s %s %s",
				      dir, SEARCH_CMD, *argv, VORS);
                        if (0 != (result1 = system(sysbuf)))
				result = result1;
                        (void)sprintf(sysbuf,"cd %s; %s %s %s",
				      dir, SEARCH_CMD, *argv, AIRWAYS);
                        if (0 != (result1 = system(sysbuf)))
				result = result1;
                        (void)exit(result);
                }
                else
		/*
		 * Our user has a problem - give some help
		 */
                ShowUsage("How to invoke nav ...");
        }
} /* scan_command_line() */
