/*
 *	Aviation navigation program
 *	main.c [2.28] from /preflight/src/nav/SCCS/src/s.main.c
 *		Retrieved 16:26:39 88/07/07; latest mod 16:02:40 88/07/07
 *	Alan M. Marcum		marcum@nescorna.Sun.COM
 *	Robert J. Evans		tolerant!procase!rje
 */

#ifndef	LINT
static char *SCCSid = "@(#)main.c\tRevision 2.28\t88/07/07";
#endif

/* *********************************************************************** */
/*                                                                         */
/* Navigation Flight Plan Program                     MAIN.C               */
/*                                                                         */
/* This program is public domain software.  No claim is made for the       */
/* accurracy of either the program or the databases used by the program.   */
/* Always check the flight plan provided by the program for reasonable     */
/* results.  The pilot in command of an aircraft is directly responsible   */
/* for, and is the final authority as to, the operation of that aircraft.  */
/* (FAR 91.3)  Each pilot in command shall, before beginning a flight,     */
/* familiarize himself with all available information concerning that      */
/* flight. (FAR 91.5)                                                      */
/*                                                                         */
/* *********************************************************************** */
#include <stdio.h>
#include <math.h>
#ifdef	SysV
#include	<string.h>
#else	!SysV
#include	<strings.h>
#endif	SysV
#include <Nav.h>
#include <NavGlobals.h>

void	FlightGuide(),		/* Print the flight plan */
	FillInArrays(),		/* Fill up short arrays */
	ProcessArgs(),		/* Find all the navaids and such */
	DoRNAV(),		/* Handle R-Nav waypoints */
	scan_command_line();	/* Parse the command line arguments */

int
main(argc, argv)
int	argc;
char	*argv[];
{ /* Main */

	pgm_name = argv[0];

	/*
	 * Initialize variables
	 */
	posflg = comflg = fromflg = toflg = viaflg = rviaflg = 0;
        altflg = windflg = speedflg = fuelflg = costflg = 0;
        ViaC = 0;
        format = 2;
        apt_vors = 0;		/* Default: don't find, display nearest VORs */
	nearestall = 0;		/* Default: only nearest from analogous file */
        AptIDs[0][0] = '\0';
        AptIDs[1][0] = '\0';
	for (v = 0; v < MAXVIA; v++) {
		VorIDs[v][0] = '\0';
		WindArray[v*2] = 0;
		WindArray[(v*2)+1] = 0;
		SpeedArray[v] = 0;
		AltArray[v] = 0;
		FuelArray[v] = 0.0;
		ViaArray[v].vor_type = TYPE_UNDEFINED;
	}

	scan_command_line(argc, argv);
        if ((fromflg && !(toflg   || viaflg))	||
            (toflg   && !(fromflg || viaflg))	||
            (viaflg  && rviaflg)		||
            (rviaflg && !(fromflg || toflg))	||
            (windflg && !(speedflg))		||
	    (fuelflg && !(speedflg))		||
            ((!fromflg && !toflg) && !viaflg))
                  ShowUsage("Inconsistent nav options.");

	ProcessArgs();

        if (rviaflg) {
		DoRNAV();
	}
	
	if (ViaC > 0) {
		FillInArrays();
	}

	/*
	 * Compute the flight plan and print it out
	 */
        FlightGuide(format, &From, &To,
                    fromflg, toflg, posflg,
                    altflg, AltArray,
                    speedflg, SpeedArray,
                    windflg, WindArray,
		    fuelflg, costflg, FuelArray,
                    viaflg, rviaflg, ViaC, ViaArray,
                    apt_vors, Vors, dist_f, rad_f, dist_t, rad_t);

	return(0);

} /* main() */
