#! /bin/sh -u
#	nav_test.sh [1.6] from /preflight/src/nav/SCCS/src/s.nav_test.sh
#		Retrieved 16:27:01 88/07/07; latest mod 16:02:45 88/07/07
#
#	Aviation Navigation Program
#	Program testing script
#
#	Alan M. Marcum		marcum@nescorna.Sun.COM
#
#	@(#)nav_test.sh	Revision 1.6	88/07/07

PATH=/preflight/bin:/usr/local/bin:/usr/ucb:/usr/bin

ECHO=echo
DIFF=diff
BASENAME=basename
ERROR=echo
LINES='wc -l'
GBLNAV=nav
LCLNAV=./nav

INSTALLED=1
BASELINE=2
MAKEBASE=3

# Following variable is the number of lines in NavTest.DIFFS if there are
# no differences found.
NODIFFS=16

# Following variable is the number of lines in NavTest.DIFFS if only the
# Release Number changed.
RELEASEDIFFS=32

Name=`$BASENAME $0`

OPTIONS="[-b | -m]"

case $# in
    0 )	# Default; do testing against installed version
	Type=$INSTALLED
	Directory=/tmp
	set	$$	$$	$$	$$
	;;
    1 ) # Might want either help or baseline testing
	case "$1" in
	    -b ) # Wants baseline testing
	    	Type=$BASELINE
		Directory=.
		set	A	B	C	D
		;;
	    -m ) # Wants to make baseline
	    	Type=$MAKEBASE
		Directory=.
		set	A	B	C	D
		;;
	    -h ) # Wants help
	    	$ERROR 1>&2 $Name: Syntax: $Name $OPTIONS
		exit 0
		;;
	    * ) # User goofed
	    	$ERROR 1>&2 "$Name: Unknown option ($1)"
		$ERROR 1>&2 $Name: Syntax: $Name $OPTIONS
		exit 1
		;;
	    esac
	    ;;
    * ) # User goofed again
    	$ERROR 1>&2 "$Name: Unknown option ($1)"
	$ERROR 1>&2 $Name: Syntax: $Name $OPTIONS
	exit 1
	;;
esac

CheckIt()
{
	if [ $Type -eq $MAKEBASE ]; then
		Suffix=$1
		shift
		$LCLNAV $* > $Directory/NavTest.$Suffix
	else
		Suffix=$1
		shift
		if [ $Type -eq $INSTALLED ]; then
			$GBLNAV $* > $Directory/NavTest.$Suffix
		fi
		$LCLNAV $* > /tmp/NavTest1.$$
		$DIFF $Directory/NavTest.$Suffix /tmp/NavTest1.$$ >> \
			NavTest.DIFFS
	fi
}

$ECHO "Testing NAV in $PWD; `date`." > NavTest.DIFFS
$ECHO "" >> NavTest.DIFFS

$ECHO  "-from apc -to lax -via oak v107 sadde vtu -alt 85 190 70 30 \\" >> \
	NavTest.DIFFS
$ECHO -n "	-speed 110 175 190 140 -wind 2810 3650 2715 " >> \
	NavTest.DIFFS
$ECHO "-fuel 18 15.5 11.8" >> NavTest.DIFFS
CheckIt $1 -from apc -to lax -via oak v107 sadde vtu -alt 85 190 70 30 \
		     -speed 110 175 190 140 -wind 2810 3650 2715 \
		     -fuel 18 15.5 11.8
shift

$ECHO "" >> NavTest.DIFFS
$ECHO "-from pao -to lvk -via sfo/090/18.5 -nearest -possec" >> NavTest.DIFFS
CheckIt $1 -from pao -to lvk -via sfo/090/18.5 -nearest -possec
shift

$ECHO "" >> NavTest.DIFFS
$ECHO "-from oak -to s03 -via oak bessa v195 rbl v23 fjs v287 klama \\" >> \
	NavTest.DIFFS
$ECHO "	-speed 100 148 148 148 120 100 -alt 1 100 145 145 75 35 \\" >> \
	NavTest.DIFFS
$ECHO "	-wind 1105 1105 1908 1908 2216 -cost 93.96 83.52 76.56 \\" >> \
	NavTest.DIFFS
$ECHO "	-nearest" >> NavTest.DIFFS
CheckIt $1 -from oak -to s03 -via oak bessa v195 rbl v23 fjs v287 klama \
	-speed 100 148 148 148 120 100 -alt 1 100 145 145 75 35 \
	-wind 1105 1105 1908 1908 2216 -cost 93.96 83.52 76.56 -nearest
shift

$ECHO "" >> NavTest.DIFFS
$ECHO "-from pao -to cno -via sjc vinco v107 ave ehf v197 pdz lindn lka \\">> \
	NavTest.DIFFS
$ECHO -n "	-speed 110 125 150 180 180 195 140 120 " >> NavTest.DIFFS
$ECHO "-alt 30 50 150 150 150 80 30 9 \\" >> NavTest.DIFFS
$ECHO "	-wind 1810 1805 0910 1820 1820 1820 2310 2712 \\" >> NavTest.DIFFS
$ECHO "	-fuel 186 120 120 107 107 85 80 -pos" >> NavTest.DIFFS
CheckIt $1 -from pao -to cno -via sjc vinco v107 ave ehf v197 pdz lindn lka \
	-speed 110 125 150 180 180 195 140 120 -alt 30 50 150 150 150 80 30 9 \
	-wind 1810 1805 0910 1820 1820 1820 2310 2712 \
	-fuel 186 120 120 107 107 85 80 -pos
shift

if [ $Type -eq $INSTALLED ]; then
	rm $Directory/NavTest.$$
fi
if [ $Type -ne $MAKEBASE ]; then
	rm /tmp/NavTest1.$$
	set `$LINES NavTest.DIFFS`
	if [ $1 -eq $NODIFFS ]; then
		$ECHO $Name: no differences found.
	elif [ $1 -eq $RELEASEDIFFS ]; then
		$ECHO $Name: only \'Release Number\' differences found.
	else
		$ECHO $Name: $1 lines different in $2.
		$ECHO "	[$NODIFFS are for header information;"
		$ECHO "	 $RELEASEDIFFS are for header information plus"
		$ECHO "	 'Release Number' differences only.]"
	fi
else
	$ECHO $Name: Baseline test results built.
fi
