/*
 *	Aviation navigation program
 *	Utilities for Printing Things
 *	output_utils.c [1.2] from /preflight/src/nav/SCCS/src/s.output_utils.c
 *		Retrieved 16:26:56 88/07/07; latest mod 16:03:05 88/07/07
 *	Alan M. Marcum		marcum@nescorna.Sun.COM
 *	Robert J. Evans		tolerant!procase!rje
 */

#ifndef	LINT
static char *SCCSid = "@(#)output_utils.c\tRevision 1.2\t88/07/07";
#endif

/************************************************************************
 *
 * Navigation Flight Plan Program
 *
 * This program is public domain software.  No claim is made for the
 * accurracy of either the program or the databases used by the program.
 * Always check the flight plan provided by the program for reasonable
 * results.  The pilot in command of an aircraft is directly responsible
 * for, and is the final authority as to, the operation of that aircraft.
 * (FAR 91.3)  Each pilot in command shall, before beginning a flight,
 * familiarize himself with all available information concerning that
 * flight. (FAR 91.5)
 *
 ***************************************************************************/

#include <stdio.h>
#include <math.h>

#ifdef	SysV
#include	<string.h>
#else	/* !SysV */
#include	<strings.h>
#endif	/* SysV */

#if	defined(Sun) || defined(SysV) || defined(Xenix386)
#include <values.h>

#else	/* ! (defined(Sun) || defined(SysV) || defined(Xenix386)) */
#ifdef	MSC
#include <limits.h>
#define MAXINT INT_MAX

#else	/* ! MSC */
#define MAXINT	(~ (1 << ((8 * (int)sizeof(int)) - 1)) )

#endif	/* MSC */
#endif	/* defined(Sun) || defined(SysV) || defined(Xenix386) */

#include <Nav.h>
#include <NavGlobals.h>
#include <NavFormat.h>


/* Print a place's name, id, and position */
void
print_lat_lon(name, id, loc, fix_type, tenths_seconds)
char	name[],
	id[];
struct fix	loc;
int	fix_type,	/* airport, vor, ndb, etc. */
	tenths_seconds;		/* Format - dd:mm.t or dd:mm:ss */
{ /* print_lat_lon() */
char	*fmt,			/* Output formatting string */
	latlonfmt[BUFSIZ];	/* Lat-lon format */

switch (fix_type) {
case TYPE_INTERSECTION:
	fmt = "      %-16s  [%5s]   ";
        break;
case TYPE_AIRPORT:
	fmt = "%-16s        [%3s]     ";
        break;
default:	/* A nav aid */
	fmt = "      %-16s  [%3s]     ";
        break;
}

switch (tenths_seconds) {
default:
	(void)fprintf(stderr,
		      "%s: print_lat_lon() Internal error.\n",
		      pgm_name);
	(void)fprintf(stderr,
		      "%s: Unknown tenths_seconds [%d]; assuming TENTHS\n",
		      pgm_name, tenths_seconds);
case POS_TENTHS:
	(void)sprintf(latlonfmt, LL1, fmt);
	(void)printf(latlonfmt,
		name, id,
		get_degrees(loc.lat.deg), get_minutes(loc.lat.deg),
		get_degrees(loc.lon.deg), get_minutes(loc.lon.deg));
	break;
case POS_SECONDS:
	(void)sprintf(latlonfmt, LL2, fmt);
	(void)printf(latlonfmt,
		name, id,
		get_degrees(loc.lat.deg), floor(get_minutes(loc.lat.deg)),
			get_seconds(loc.lat.deg),
		get_degrees(loc.lon.deg), floor(get_minutes(loc.lon.deg)),
			get_seconds(loc.lat.deg));
	break;
}
}  /* print_lat_lon() */


/* Print out the contents of a VOR structure, in a reasonable fashion */
void
print_vor(Vor)
struct vor	Vor;
{
        (void)printf("\t%-20s [%s]\t(%s)\t%s\n\
\tType=%d, %s RNAVable.\t%d', %3.1fMHz, %2.1f variation.\n\
\t%3.0f:%04.1fN, %3.0f:%04.1fW  [%2.3fN, %2.3fW].\n", 
		Vor.name, Vor.id, Vor.waypoint, Vor.comments,
		Vor.vor_type, Vor.rnavable ? "is" : "isn't",
			Vor.alt, Vor.freq, Vor.var, 
		get_degrees(Vor.loc.lat.deg), get_minutes(Vor.loc.lat.deg),
		get_degrees(Vor.loc.lon.deg), get_minutes(Vor.loc.lon.deg),
		Vor.loc.lat.rad, Vor.loc.lon.rad);
}

/*
 * Turn the TYPE code into a nice, readable description
 */
void
unparse_type(type, from_type)
char	type[];
int	from_type;
{ /* unparse_type */
      switch (from_type) {
      case TYPE_NDB:
		(void)strcpy(type, LTYPE_NDB);
		break;
      case TYPE_VOR:
		(void)strcpy(type, LTYPE_VOR);
		break;
      case TYPE_VORTAC:
		(void)strcpy(type, LTYPE_VORTAC);
		break;
      case TYPE_TACAN:
		(void)strcpy(type, LTYPE_TACAN);
		break;
      case TYPE_ILS:
		(void)strcpy(type, LTYPE_ILS);
		break;
      case TYPE_INTERSECTION:
		(void)strcpy(type, LTYPE_INTERSECTION);
		break;
      case TYPE_WAYPOINT:
		(void)strcpy(type, LTYPE_WAYPOINT);
		break;
      case TYPE_LOM:
		(void)strcpy(type, LTYPE_LOM);
		break;
      case TYPE_LMM:
		(void)strcpy(type, LTYPE_LMM);
		break;
      case TYPE_AIRPORT:
		(void)strcpy(type, LTYPE_AIRPORT);
		break;
      case TYPE_TURNPOINT:
		(void)strcpy(type, LTYPE_TURNPOINT);
		break;
      case TYPE_CROSSOVER:
		(void)strcpy(type, LTYPE_CROSSOVER);
		break;
      case TYPE_USERWAYPOINT:
		(void)strcpy(type, LTYPE_USERWAYPOINT);
		break;
      case TYPE_UNKNOWN:
      default:
		(void)strcpy(type, LTYPE_UNKNOWN);
		break;
      }
} /* unparse_type() */
