/*
 *	Aviation navigation program
 *	Process arguments, performing appropriate manipulations
 *	procargs.c [1.2] from /preflight/src/nav/SCCS/src/s.procargs.c
 *		Retrieved 16:26:55 88/07/07; latest mod 16:02:56 88/07/07
 *	Alan M. Marcum		marcum@nescorna.Sun.COM
 *	Robert J. Evans		tolerant!procase!rje
 */

#ifndef	LINT
static char *SCCSid = "@(#)procargs.c\tRevision 1.2\t88/07/07";
#endif

/* *********************************************************************** */
/*                                                                         */
/* Navigation Flight Plan Program                     PROCARGS.C           */
/*                                                                         */
/* This program is public domain software.  No claim is made for the       */
/* accurracy of either the program or the databases used by the program.   */
/* Always check the flight plan provided by the program for reasonable     */
/* results.  The pilot in command of an aircraft is directly responsible   */
/* for, and is the final authority as to, the operation of that aircraft.  */
/* (FAR 91.3)  Each pilot in command shall, before beginning a flight,     */
/* familiarize himself with all available information concerning that      */
/* flight. (FAR 91.5)                                                      */
/*                                                                         */
/* *********************************************************************** */
#include <stdio.h>
#include <math.h>
#ifdef	SysV
#include	<string.h>
#else	!SysV
#include	<strings.h>
#endif	SysV
#include <Nav.h>
#include <NavGlobals.h>

void	open_databases(),	/* Open the database files for processing */
	close_files();		/* Close them up */

void
ProcessArgs()
{ /* ProcessArgs() */

	open_databases();


        /* Find the from and to airports by reading in the databases */

        v = GetApts(&From, &To, AptIDs, &AptRecord, fpa, fromflg + toflg);
        if (v < (fromflg + toflg)) {
		(void)printf("\nERROR: failed to find airport(s)");
		for (v = 0; v < 2; v++) (void)printf(" %s",AptIDs[v]);
		(void)printf(".\n");
		(void)exit(1);
        }

	/* Translate Victor Airways and Jet Routes to VORs */
	if (ViaC > 0 && !rviaflg)
		if (!GetRoutes(VorIDs, &ViaC, AltArray, &AltC,
			       WindArray, &WindC, SpeedArray, &SpeedC, 
			       FuelArray, &FuelC, fpw))
			(void)exit(1);

        /* Find the vors used for navigation by reading the database */
        v = GetVors(ViaArray, ViaC, VorIDs, &VorRecord, fpv,
                    &From, &To, fromflg, toflg, apt_vors,
                    Vors);
        if (v < ViaC) {
                (void)printf("\nERROR: failed to find vor(s)");
                for (v = 0; v <= ViaC; v++) (void)printf(" %s",VorIDs[v]);
                (void)printf(".\n");
                (void)exit(1);
	}

	close_files();
} /* ProcessArgs() */


/* Find the RNAV waypoints for each VOR */
void
DoRNAV()
{ /* DoRNAV() */

	double	WpLat,		/* Waypoint latitude */
		WpLon,		/* Waypoint longitude */
		WpDist,		/* Waypoint's distance from VORTAC */
		WpRad,		/* Waypoint's radial from VORTAC */
		A, B, C;	/* Temps for waypoint calculations */

           viaflg = rviaflg;
           if (fromflg)
           {
              WpFromLoc = From.loc;
              v1 = 0;
           }else
           {
              WpFromLoc = ViaArray[0].loc;
              v1 = 1;
           }
           B = 0;
           for (v = ViaC - 1; v >= 0; v--)
		if (!ViaArray[v].rnavable) {
			B = 1;
			WpToLoc = ViaArray[v].loc;
		}
           if (B == 0)
		WpToLoc = To.loc;

           for (v = v1; v < ViaC; v++) {
	      (void)sprintf(ViaArray[v].waypoint, "WP%-2.2d",v+1);
              if (ViaArray[v].rnavable) {
                /* Compute a point that lies on the Great Circle Route
                   at the same longitude as the vor that we are using
                */


		/* Following avoids a NaN situation below, when WP
		 * nav aid and FROM point are at the same longitude.
		 * It introduces a small (and acceptable?) error.
		 *	AMM	23Sep86
		 */
		if (WpFromLoc.lon.rad == ViaArray[v].loc.lon.rad) {
		        ViaArray[v].loc.lon.deg += .01;
			ViaArray[v].loc.lon.rad =
			        Radians(ViaArray[v].loc.lon.deg);
		}

                        WpLat =
                           LatIntercept(WpFromLoc.lat.rad, WpFromLoc.lon.rad,
                                        WpToLoc.lat.rad, WpToLoc.lon.rad,
                                        ViaArray[v].loc.lon.rad);
                /* 
		 * Compute the slope of the line from From to the
                 * point that is on the Great Circle Route
                 */

                        B = ViaArray[v].loc.lon.rad - WpFromLoc.lon.rad;
                        A = -(WpLat - WpFromLoc.lat.rad);
                        C = -((A*WpFromLoc.lon.rad)+(B*WpFromLoc.lat.rad));

                /*
		 * Compute the coordinates of a point on the Great
                 * Circle Route that is perpendicular to the VOR
                 */

                        WpLon = (((B*B)*ViaArray[v].loc.lon.rad) -
                                 (A*B*ViaArray[v].loc.lat.rad) - A*C) /
                                 ((A*A)+(B*B));

                        WpLat = -(((A*B*ViaArray[v].loc.lon.rad) -
                                   ((A*A)*ViaArray[v].loc.lat.rad) + B*C) /
                                   ((A*A)+(B*B)));
                 /*
		  * Compute the distance from the VOR to the point
                  * that lies on the Great Circle Route
                  */
                        WpDist = Distance(ViaArray[v].loc.lat.rad,
                                          ViaArray[v].loc.lon.rad,
                                          WpLat,
					  WpLon);
                        if (altflg) {
                            AltDiff = abs(ViaArray[v].alt - AltArray[v]);
                            AltDiff = AltDiff / (5280 * 1.15);
                            WpDist = sqrt((WpDist*WpDist) +
                                          (AltDiff*AltDiff));
                        }
                 /*
		  * Finally, compute the bearing from the VOR to
                  * the point that will be our WayPoint.
                  */
                        WpRad  = Bearing(WpFromLoc.lat.rad,
                                         WpFromLoc.lon.rad,
                                         WpToLoc.lat.rad,
                                         WpToLoc.lon.rad,
					 ViaArray[v].var);
                        if ((WpLat == ViaArray[v].loc.lat.rad) &&
                            (WpLon == ViaArray[v].loc.lon.rad))
                        {
                            WpRad = 360. - ViaArray[v].var;
                            WpDist = 0.0;
                        }
                        else
                        if ((WpRad > 0.) && (WpRad <= 90.))
                        {
                           if (WpLat > ViaArray[v].loc.lat.rad)
                              WpRad = WpRad + 270.;
                           else
                              WpRad = WpRad + 90.;
                        }
                        else
                        if ((WpRad > 90.) && (WpRad <= 180.))
                        {
                           if (WpLat > ViaArray[v].loc.lat.rad)
                              WpRad = WpRad - 90.;
                           else
                              WpRad = WpRad + 90.;
                        }
                        else
                        if ((WpRad > 180.) && (WpRad <= 270.))
                        {
                           if (WpLat > ViaArray[v].loc.lat.rad)
                              WpRad = WpRad + 90.;
                           else
                              WpRad = WpRad - 90;
                        }
                        else
                        if ((WpRad > 270.) && (WpRad <= 360.))
                        {
                            if (WpLat > ViaArray[v].loc.lat.rad)
                               WpRad = WpRad - 270.;
                            else
                               WpRad = WpRad - 90.;
                        }

                        WpRad = Magnetic(WpRad, ViaArray[v].var);

                        ViaArray[v].loc.lat.rad = WpLat;
                        ViaArray[v].loc.lat.deg = Degrees(WpLat);
                        ViaArray[v].loc.lon.rad = WpLon;
                        ViaArray[v].loc.lon.deg = Degrees(WpLon);
                        ViaArray[v].loc.radial  = WpRad;
                        ViaArray[v].loc.nm      = WpDist;
                } else {
                        WpFromLoc = WpToLoc;
                        B = 0;
                        for (v2 = ViaC - 1; v2 > v; v2--)
				if (!ViaArray[v2].rnavable) {
					B = 1;
					WpToLoc = ViaArray[v2].loc;
				}
                        if (B == 0)
				WpToLoc = To.loc;
		}
	   }
} /* DoRNAV() */

void
FillInArrays()
{ /* FillInArrays()

/* Fill in the SpeedArray, AltArray, WindArray for each leg */

	for (v = 0; v <= ViaC; v++) {
		if (speedflg &&
		    SpeedArray[v] == 0) {
			SpeedArray[v] = SpeedArray[v-1];
		}
		if (fuelflg &&
		    FuelArray[v] == 0.0) {
			FuelArray[v] = FuelArray[v-1];
		}
		if (altflg &&
		    AltArray[v] == 0) {
			AltArray[v] = AltArray[v-1];
		}
		if (windflg && 
		    WindArray[v*2] == 0) {
			WindArray[v*2] = (360 == WindArray[(v-1)*2] ?
						 0 :
						 WindArray[(v-1)*2]);
			WindArray[v*2+1] = WindArray[(v-1)*2+1];
		    }
	}
} /* FillInArrays() */
