/*
 *	Aviation navigation program
 *	scan.c [2.12] from /preflight/src/nav/SCCS/src/s.scan.c
 *		Retrieved 16:26:46 88/07/07; latest mod 16:02:31 88/07/07
 *	amm	Alan M. Marcum		marcum@nescorna.Sun.COM
 *	rje	Robert J. Evans		tolerant!procase!rje
 */

#ifndef	LINT
static char *SCCSid = "@(#)scan.c\tRevision 2.12\t88/07/07";
#endif	LINT

/* *********************************************************************** */
/*                                                                         */
/* Navigation Flight Plan Program                     SCAN.C               */
/*                                                                         */
/* This program is public domain software.  No claim is made for the       */
/* accurracy of either the program or the databases used by the program.   */
/* Always check the flight plan provided by the program for reasonable     */
/* results.  The pilot in command of an aircraft is directly responsible   */
/* for, and is the final authority as to, the operation of that aircraft.  */
/* (FAR 91.3)  Each pilot in command shall, before beginning a flight,     */
/* familiarize himself with all available information concerning that      */
/* flight. (FAR 91.5)                                                      */
/*                                                                         */
/* *********************************************************************** */
#include <ctype.h>
#include <math.h>
#include <Nav.h>
#include <stdio.h>
#include <NavGlobals.h>

double	atof();

/* *********************************************************************** */
/* StoreAlt converts an ascii string into an integer and stores the        */
/*          result into alt[c]. Alt[c] is the altitude for leg c of the    */
/*          flight plan.                                                   */
/* Returns: 0 (zero)                                                       */
/* Parameters: alt - array of altitude values (in feet).                   */
/*             c   - index to alt to be used.                              */
/*             s   - ascii string to convert to integer and store into     */
/*                   alt[c].                                               */
/* Side Effects: alt[c] is modified.                                       */
/* *********************************************************************** */
StoreAlt(alt,c,s)
int	alt[],
	c;
char	*s;
{
        if ((alt[c] = atoi (s)) < 1000) alt[c] = alt[c] * 100;
        return(0);
} /* StoreAlt */

/* *********************************************************************** */
/* StoreSpeed converts an ascii string into an integer and stores the      */
/*          result into speed[c]. Speed[c] is the speed for leg c of the   */
/*          flight plan.                                                   */
/* Returns: 0 (zero)                                                       */
/* Parameters: speed - array of speed values (in knots).                   */
/*             c   - index to speed to be used.                            */
/*             s   - ascii string to convert to integer and store into     */
/*                   speed[c]                                              */
/* Side Effects: speed[c] is modified.                                     */
/* *********************************************************************** */
StoreSpeed(speed, c, s)
int	speed[],
	c;
char	*s;
{
        speed[c] = atoi (s);
        return(0);
} /* StoreSpeed */

/* *********************************************************************** */
/* StoreFuel converts an ascii string into a float and stores the          */
/*          result into fuel[c], the fuel flow for leg c of the flight     */
/*          plan.                                                          */
/* Returns: 0 (zero)                                                       */
/* Parameters: fuel - array of fuel flow values (in pph or gph).           */
/*             c   - index to fuel to be used.                             */
/*             s   - ascii string to convert to float and store into       */
/*                   fuel[c]                                               */
/* Side Effects: fuel[c] is modified.                                      */
/* *********************************************************************** */
StoreFuel(fuel, c, s)
float	fuel[];
int	c;
char	*s;
{
        fuel[c] = atof(s);
        return(0);
} /* StoreFuel */

/* *********************************************************************** */
/* StoreWind converts an ascii string into an integer and stores the       */
/*          result into wind[c]. Wind[c] is the wind direction for leg c   */
/*          of the flight plan. Wind[c+1] is the speed of the wind.        */
/* Returns: 0 (zero)                                                       */
/* Parameters: wind - array of wind direction and speed values (in knots). */
/*                    wind direction is with respect to TRUE north.        */
/*             c   - index to wind to be used.                             */
/*             s   - ascii string to convert to integer and store into     */
/*                   wind[c]                                               */
/* Side Effects: wind[c] is modified.                                      */
/* *********************************************************************** */
StoreWind (wind, c, s)
int wind[], *c;
char *s;
{
int winds_aloft, direction, speed;
        winds_aloft = atoi(s);
        direction = (winds_aloft / 100) * 10;
        speed = winds_aloft % 100;
        wind[*c] = direction;
        wind[*c+1] = speed;
        return(0);
} /* StoreWind */

/* *********************************************************************** */
/* uppit will upcase an ascii string.                                      */
/* Returns: void.                                                          */
/* Parameters: s - pointer to an ascii string.                             */
/* Side Effects: the string pointer to by s will be converted to upper     */
/*               case characters.                                          */
/* *********************************************************************** */
void
uppit(s)
char *s;
{
        while ((*s != '\0') && (*s != '\n')){
                if ((isalpha(*s) && islower(*s))){
                        *s=toupper(*s);
                }
                if (isspace(*s)){
                        *s=' ';  /* Guarantee that it's a blank char */
                }
                s++;
        }
} /* uppit */


/*
 * Convert a lat-lon/radial/dme into lat-lon.
 *
 * Thanks to Bob Evans (rje@procase) and to Andrew Jay Schneider
 * (ajs@procase).
 */

struct fix *
rad_dme2lat_lon(vor_lat, vor_lon, radial, dist, variance)
double	vor_lat,	/* Navaid's latitude (in degrees) */
	vor_lon;	/* ...and longitude (in degress) */
double	radial,			/* Radial to waypoint */
	dist,			/* Distance to same */
	variance;		/* Magnetic variation */

{
	double	wp_lat,		/* Waypoint's latitude (degrees) */
		wp_lon;		/* ... and longitude (degrees) */
	struct fix	*waypoint;	/* The waypoint */

	double	Degrees(),
		Radians();

#define SIN(n)	(sin(Radians((n))))
#define COS(n)	(cos(Radians((n))))

	if (NULL == (waypoint = (struct fix *)malloc(sizeof(struct fix)))) {
		(void)perror("Could not allocate space in rad_dme2lat_lon");
		(void)exit(1);
	}

	waypoint->radial = radial;
	radial -= variance;

	wp_lon = vor_lon -
	    dist * COS(90.0 - radial) / (COS(vor_lat) * 60.0);

	wp_lat = vor_lat + dist * SIN(90.0 - radial) / 60.0;

	waypoint->lat.deg = wp_lat;
	waypoint->lat.rad = Radians(wp_lat);
	waypoint->lon.deg = wp_lon;
	waypoint->lon.rad = Radians(wp_lon);
	waypoint->nm = dist;
	return(waypoint);
} /* rad_dme2lat_lon */
