/*
 *	Aviation navigation program
 *	search.c [1.11] from /preflight/src/nav/SCCS/src/s.search.c
 *		Retrieved 16:26:50 88/07/07; latest mod 16:02:37 88/07/07
 *	Alan M. Marcum		marcum@nescorna.Sun.COM
 *		Thanks to Bob Evans (tolerant!procase!rje) and
 *		Jerry Fiddler (sun!wrs!jerry) for their help with
 *		this module.
 */

#ifndef	LINT
static char *SCCSid = "@(#)search.c\tRevision 1.11\t88/07/07";
#endif	/* LINT */

/* *********************************************************************** */
/*                                                                         */
/* Navigation Flight Plan Program                     SEARCH.C             */
/*                                                                         */
/* This program is public domain software.  No claim is made for the       */
/* accurracy of either the program or the databases used by the program.   */
/* Always check the flight plan provided by the program for reasonable     */
/* results.  The pilot in command of an aircraft is directly responsible   */
/* for, and is the final authority as to, the operation of that aircraft.  */
/* (FAR 91.3)  Each pilot in command shall, before beginning a flight,     */
/* familiarize himself with all available information concerning that      */
/* flight. (FAR 91.5)                                                      */
/*                                                                         */
/* *********************************************************************** */
#include <stdio.h>
#include <ctype.h>

#if	defined(Sun) || defined(SysV) || defined(Dynix)
#include <unistd.h>

#else	/* ! (defined(Sun) || defined(SysV) || defined(Dynix)) */
#ifdef	MSC
/* <stdio.h> already included; SEEK_* defined there */

#else	/* ! MSC */
#ifndef	SEEK_SET
#define SEEK_SET	0	/* Seek relative to beginning */
#endif

#ifndef	SEEK_CUR
#define SEEK_CUR	1	/* Seek relative to here */
#endif

#ifndef	SEEK_END
#define SEEK_END	2	/* Seek relative to end */
#endif

#endif	/* MSC */
#endif	/* defined(Sun) || defined(SysV) || defined(Dynix) */

#ifdef	SysV
#include	<string.h>
#else	/* !SysV */
#include	<strings.h>
#endif	/* SysV */

#include <Nav.h>
#include <NavGlobals.h>

/* Globals */
char	*line,		/* I/O buffer */ 
        *line1,		/* Work buffer for strtok() */
	*record_key;	/* Key for this record */
FILE	*file;		/* Stream reference */
int	record_length;	/* Length of a record */

/*
 * Perform a binary search on the file referenced by the specified file
 * descriptor, looking for the record denoted by the specified key.  The file
 * should already be opened; key is a character string, which will match the
 * first token in each record of the file.  The file must have essentially
 * fixed-length records, each of size record_length.
 */
char *
binary_search(filep, key, rlen)
FILE	*filep;
char	*key;
int	rlen;
{
	int	comparison;	/* Value of this comparison */
	long	low,		/* Lower limit of file, in records */
		mid,		/* Mid-point for this search, in records */
		high, 		/* Upper limit of file, in records */
		consistent();	/* Check consistency of file, and
				 * ability to allocate space */
	char	*record,	/* Current record */
		*this_key,	/* Key from current record */
		*get_record(),
		*get_key();
	
	low = 0L;
	if (0 == (high = consistent(filep, rlen))) return(NULL);

	while (TRUE) {		/* Go until done */
		if (low > high) return(NULL);	/* Not found */
		mid = (low + high) / 2;
		if (NULL == (record = get_record(mid))) return(NULL);
		if (NULL == (this_key = get_key(record))) return(NULL);
		comparison = strcmp(this_key, key);
		if (comparison < 0) {
		        low = mid + 1;
		} else	if (comparison == 0) {
		        return(record);
		} else	high = mid - 1;
	}
} /* binary_search() */

char *
get_record(record_no)
long	record_no;
{
	if (-1 == fseek(file,
			record_no * record_length,
			SEEK_SET)) {	/* Find the record */
		(void)perror("nav: could not seek");
		return(NULL);
	}
        if (NULL == fgets(line, record_length, file)) return(NULL);
#ifdef	PAD_IS_NOT_NULL
	else	if (record_length != strlen(line)) {
			(void)fprintf(stderr,
	    "nav: wrong length record (%d); is %d, should be %d.\n-%s-\n",
				      record_no, strlen(line),
				record_length, line);
			return(NULL);
		}
#endif	/* PAD_IS_NOT_NULL */
	return(line);
} /* get_record() */

long
consistent(filep, rlen)
FILE	*filep;
int	rlen;
{
	long	file_size,
		nrecords;

	file = filep;		/* Set globals */
	record_length = rlen;

       	if (file == NULL)	/* No file descriptor there */
	        return(FALSE);

	/* Do we have an integral number of records? */
	if (-1 == fseek(file, 0L, SEEK_END)) {	/* File length */
	        (void)perror("nav: could not seek");
		return(FALSE);
	} else	file_size = ftell(file);
	if (0 != file_size % record_length) {
	        (void)fprintf(stderr,
		   "nav: non-integral number of records; %d bytes extra\n", 
		   file_size % record_length);
		return(NULL);
	} else	nrecords = file_size / record_length;

	/* Do we have enough space to do this? */
	if (NULL == (line = malloc(BUFSIZ))	||
	    NULL == (line1 = malloc(BUFSIZ))	||
	    NULL == (record_key = malloc(VIALEN))) {
	        (void)perror("nav: cannot allocate space");
		(void)exit(1);
	}
	return(nrecords);
} /* consistent() */

char *
get_key(record)
char	*record;
{
	char	*the_key;

	(void)strncpy(line1, record, record_length); /* Working copy */
	the_key = strtok(line1, VOR_DELIMS);	   /* Get key */
	if (NULL == the_key) {	/* It's dead, Jim... */
		(void)fprintf(stderr,
			      "Mal-formed line: no key\n-%s-\n", record);
		return(NULL);
	} else	return(the_key);
} /* get_key() */


#if (!defined(SysV) && !defined(Sun))

/*
 * strtok.c - a generic version of the system V strtok routine
 *
 * Thanks to Jerry Fiddler at Wind River Systems for the implementation,
 * and to Bob Evans at Procase for some debugging help. 
 * NOTE: this code is NOT based on any AT&T-proprietary code.
 */

#define EOS	'\0'	/* c string terminator */

typedef int	BOOL;

char *
strtok(s1, s2)
char	*s1;
char	*s2;

{
	static char	*strptr = NULL;
	char	*eos;
	char	*token;
	BOOL	emptyString = TRUE;
/*	char	*index();*/

	if (s1 != NULL)
		token = s1;
	else	token = strptr;

	if (*token == '\0')
		return(NULL);

	/* skip over any white (actually delimiter) space at the beginning */

	while (index(s2, *token) != NULL) {
		token++;
		if (*token == EOS)
			return(NULL);
	}

	eos = token;
	while (NULL == index(s2, *eos)) {
		eos++;
		if(*eos == EOS)
			break;
	}
	
	/*
	 * Add a NULL at the end of the string, make strptr point to the
	 * following char, and return a pointer to this token.
	 */

	*eos = EOS;
	strptr = eos+1;
	return(token);
} /* strtok() */

#endif	(!defined(SysV) && !defined(Sun))
