#! /bin/sh -u
#	shar.sh [1.2] from /preflight/src/nav/SCCS/src/s.shar.sh
#		Retrieved 16:26:08 88/07/07; latest mod 16:02:19 88/07/07
#
#	Aviation Navigation Program
#	shell archive utility
#
#	Alan M. Marcum		marcum@nescorna.Sun.COM
#
#	@(#)shar.sh	Revision 1.2	88/07/07
#
#	shar [-subdir] <destination> <source1> <source2> ... <sourceN>
#
#	Written by an anoymous author; minimally modifed.

SHAR=$0
AR=$1
shift

if [ $AR = -help ]; then
  echo 1>&2 "$SHAR: Syntax: $SHAR [-subdir] <destination> <file1> ... <fileN>"
  exit 0
elif [ $AR = -subdir ] ; then
  AR=$1
  shift
else
  echo "#! /bin/sh -u" > $AR
  echo "# this is a shell archive" >> $AR
  echo "# The rest of this file is a shell script which will extract:" >> $AR
  for i in $* ; do
    if [ -d $i ] ; then
      echo "# $i (directory)" >> $AR
    else
      echo "# $i" >> $AR
    fi
  done
  echo "#" >> $AR
  echo "# to use, type:  sh $AR" >> $AR
  echo "#" >> $AR
  echo "#" >> $AR
fi

for i do
  echo a - $i
  echo "echo x - $i" >>$AR
  if [ -d $i ] ; then
    echo "echo creating directory $i" >> $AR
    echo "mkdir $i" >> $AR
    echo "cd $i" >> $AR
    cd $i
    $SHAR -subdir ../$AR *
    cd ..
    echo "cd .." >> $AR
    echo "echo done with directory $i" >> $AR
  else
    echo "cat > $i <<'Funky_Stuff'" >>$AR
    cat $i >> $AR
    echo "Funky_Stuff" >> $AR
    len=`wc -c < $i`
    echo "len=\`wc -c < $i\`" >> $AR
    echo "if [ \$len != $len ] ; then" >> $AR
    echo "  echo error: $i was \$len bytes long, should have been $len" >> $AR
    echo "fi" >> $AR
  fi
done
