/*
 *	Aviation navigation program
 *	Display a USAGE message
 *
 *	usage.c [1.5] from /preflight/src/nav/SCCS/src/s.usage.c
 *		Retrieved 16:26:51 88/07/07; latest mod 16:02:20 88/07/07
 *	Alan M. Marcum		marcum@nescorna.Sun.COM
 */

#ifndef	LINT
static char *SCCSid = "@(#)usage.c\tRevision 1.5\t88/07/07";
#endif

#include <stdio.h>
#include <Nav.h>
#include <NavGlobals.h>

#define OPTIONFMT	"%-32.32s "
#define DESCRIPTIONFMT	"%s\n"

#define NOPTIONS	18

extern	char	*pgm_name;

void
ShowUsage(message)
char	*message;
{ /* ShowUsage() */
	char	*options[NOPTIONS],		/* Command line option */
		*descriptions[NOPTIONS];	/* Descriptions of same */
	int	n = 0,
		i;
	extern char	*RELEASE;

options[n] = "-from <id>";
	descriptions[n] = "origin airport id.";
	n++;

options[n] = "-to <id>";
	descriptions[n] = "destination airport id.";
	n++;

options[n] = "-[r]via <id> [... <id>]";
	descriptions[n] = "intermediate navigation points";
	n++;

options[n] = "-speed <kts> [... <kts>]";
	descriptions[n] = "estimated speed for each leg.";
	n++;

options[n] = "-alt <feet> [... <feet>]";
	descriptions[n] = "planned cruising altitude for each leg.";
	n++;

options[n] = "-wind <wind> [... <wind>]";
	descriptions[n] = "forecast winds aloft for each leg.";
	n++;

options[n] = "-fuel <gph/pph> [... <gph/pph>]";
	descriptions[n] = "fuel flow, in gallons or pounds per hour.";
	n++;

options[n] = "-pos";
	descriptions[n] = "include lat-lon of airports & fixes (dd:mm.t).";
	n++;

options[n] = "-possec";
	descriptions[n] = "same as -pos, but print dd:mm:ss.";
	n++;

options[n] = "-com";
	descriptions[n] = "include comments for airports, vors, fixes.";
	n++;

options[n] = "-nearest";
	descriptions[n] = "nearest VORs report.";
	n++;

options[n] = "-nearestall";
	descriptions[n] = "search all databases for nearest.";
	n++;

options[n] = "-form1";
	descriptions[n] = "old format printout (obsolete).";
	n++;

options[n] = "-form2";
	descriptions[n] = "new format printout (default).";
	n++;

options[n] = "-k <string>";
	descriptions[n] = "grep <string> from database files.";
	n++;

options[n] = "-airports";
	descriptions[n] = "display airports databases.";
	n++;

options[n] = "-vors";
	descriptions[n] = "display vors databases.";
	n++;

options[n] = "-airways";
	descriptions[n] = "display airways databases.";
	n++;

	(void)fprintf(stderr, "%s: %s\n", pgm_name, message);
	(void)fprintf(stderr, "\tNavigation Flight Plan Usage (Release %s)\n",
			      RELEASE);
	(void)fprintf(stderr, 
		"Options are (-wind, -fuel must be accompanied by -speed):\n");

	for (i = 0; i < n; i++) {
		(void)fprintf(stderr,	OPTIONFMT,	options[i]);
		(void)fprintf(stderr,	DESCRIPTIONFMT,	descriptions[i]);
	}

	exit(1);

} /* ShowUsage() */
