/*
 *	Aviation navigation program
 *	Top-Level Utilities
 *	utils.c [1.2] from /preflight/src/nav/SCCS/src/s.utils.c
 *		Retrieved 16:26:54 88/07/07; latest mod 16:02:55 88/07/07
 *	Alan M. Marcum		marcum@nescorna.Sun.COM
 *	Robert J. Evans		tolerant!procase!rje
 */

#ifndef	LINT
static char *SCCSid = "@(#)utils.c\tRevision 1.2\t88/07/07";
#endif

/************************************************************************
 *
 * Navigation Flight Plan Program
 *
 * This program is public domain software.  No claim is made for the
 * accurracy of either the program or the databases used by the program.
 * Always check the flight plan provided by the program for reasonable
 * results.  The pilot in command of an aircraft is directly responsible
 * for, and is the final authority as to, the operation of that aircraft.
 * (FAR 91.3)  Each pilot in command shall, before beginning a flight,
 * familiarize himself with all available information concerning that
 * flight. (FAR 91.5)
 *
 ***************************************************************************/

#include <stdio.h>
#include <math.h>
#ifdef	SysV
#include	<string.h>
#else	!SysV
#include	<strings.h>
#endif	SysV
#include <Nav.h>
#include <NavGlobals.h>

void	file_error();		/* Print file-related error messages */

/* Print an error message */
void
oops(s)
char *s;
{
        (void)fprintf(stderr, "nav: %s\n", s);
        (void)exit(1);

} /* opps() */

/* Print a file-related error message */
void
file_error(s)
char *s;
{
	(void)perror(pgm_name);
        (void)fprintf(stderr, "%s: missing %s\n", pgm_name, s);
} /* file_error() */

/* Done with the database files */
void
close_files()
{
	int	i;

	for (i = 0; i < MAX_DBs; i++)
		if (NULL != fpa[i] && 0 != fclose(fpa[i]))
		        (void)perror(
				"Warning - close failed on an Airports file");
	for (i = 0; i < MAX_DBs; i++)
		if (NULL != fpv[i] && 0 != fclose(fpv[i]))
		        (void)perror(
			    "Warning - close failed on a VORs file");
	for (i = 0; i < MAX_DBs; i++)
		if (NULL != fpw[i] && 0 != fclose(fpw[i]))
		        (void)perror(
				"Warning - close failed on an Airways file");
} /* close_files() */

/* Prepare the databases for use */
void
open_databases()
{ /* open_databases */

/* Names of environment variables */
#define DIRVAR		"NAV"
#define HOME		"HOME"
#define PVT_AIRPORTS	"NAV_AIRPORTS"
#define PVT_VORS	"NAV_VORS"
#define PVT_AIRWAYS	"NAV_AIRWAYS"


#define	DIRECTORY	"/preflight"
	char *default_AIRPORTS = AIRPORTS,
	     *default_VORS = VORS,
	     *default_AIRWAYS = AIRWAYS,
	     *default_DIR=DIRECTORY, 
	     *airports,		/* Public airports database */
	     *vors,		/*	  vors		    */
	     *airways,		/*	  airways	    */
	     *home;		/* Home directory */

        if (NULL == (dir = getenv(DIRVAR))) {
           home = getenv(HOME);
	   (void)strcat(home, default_DIR);
           dir = home;
        }
        if (NULL == (airports = malloc((unsigned)2+strlen(dir)+
                     strlen(default_AIRPORTS)))) {
           (void)perror(pgm_name);
           (void)exit(1);
        }
	p_airports = getenv(PVT_AIRPORTS);
	if (NULL == (vors = malloc((unsigned)2+strlen(dir)+
                     strlen(default_VORS)))) {
           (void)perror(pgm_name);
           (void)exit(1);
        }
        p_vors = getenv(PVT_VORS);
	if (NULL == (airways = malloc((unsigned)2+strlen(dir)+
                     strlen(default_AIRWAYS)))) {
           (void)perror(pgm_name);
           (void)exit(1);
        }
	p_airways = getenv(PVT_AIRWAYS);
	(void)strcpy(airports, dir);
	(void)strcat(airports, "/");
	(void)strcat(airports, default_AIRPORTS);
	(void)strcpy(vors, dir);
	(void)strcat(vors, "/");
	(void)strcat(vors, default_VORS);
	(void)strcpy(airways, dir);
	(void)strcat(airways, "/");
	(void)strcat(airways, default_AIRWAYS);

        /*
         * Open the airport, vor, and airways database files
         */
        fpa[PUB] = fopen(airports,"r");
        if (NULL == (fpa[PUB] = fopen(airports, "r"))) file_error(airports);
	if (NULL != p_airports)
	        if (NULL == (fpa[PVT] = fopen(p_airports, "r")))
		        file_error(p_airports);
	if (fpa[PUB] == NULL && fpa[PVT] == NULL)
	        oops("Neither public nor private AIRPORTS databases found");

        if (NULL == (fpv[PUB] = fopen(vors, "r"))) file_error(vors);
	if (NULL != p_vors)
	        if (NULL == (fpv[PVT] = fopen(p_vors, "r")))
		        file_error(p_vors);
	if (fpv[PUB] == NULL && fpv[PVT] == NULL)
	        oops("Neither public nor private VORS databases found");

        if (NULL == (fpw[PUB] = fopen(airways, "r"))) file_error(airways);
	if (NULL != p_airways)
	        if (NULL == (fpw[PVT] = fopen(p_airways, "r")))
		        file_error(p_airways);
	if (fpw[PUB] == NULL && fpw[PVT] == NULL)
	        oops("Neither public nor private AIRWAYS databases found");

} /* open_databases() */


#if	(!(defined(Sun) || defined(BSD4_3)))

#ifdef notdef
double
rint(x)
double	x;
{ /* rint() */
	return(floor(x + 0.5));
} /* rint() */

#endif
#endif

/* Convert a TACAN channel into a DME-paired frequency.  TACAN channel 17
 * (the lowest number channel?) corresponds to frequency 108.0, 18 to 108.1,
 * and so on, up to channel 126.
 */
float
tac_to_dme(freq)
float	freq;
{ /* tac_to_dme */
	if (freq > TACAN_MAX || freq < TACAN_MIN) {
	        (void)fprintf(stderr, "TACAN channel %f out of range.");
		(void)exit(1);
	}
        return(107.0 +
		((freq - 17.0) * 0.1));
} /* tac_to_dme() */


/* Convert decimal degrees into degrees and minutes
 */
float
get_degrees(num)
float	num;
{ /* get_degrees() */
        return(floor(num));
} /* get_degrees() */

float
get_minutes(num)
float	num;
{ /* get_minutes() */
        return(60.0 * (num - floor(num)));
} /* get_minutes() */

float
get_seconds(num)
float	num;
{ /* get_seconds() */
	num = get_minutes(num);
        return(60.0 * (num - floor(num)));
} /* get_seconds() */
