/******************************************************************
*
*	aec.c
*	
*	This program reads the output that normally goes to the CMS LOG
*	printer and puts it in the 'cmslog' file. The maximum file size
*	is determined by LOGSIZE. When ever the file grows beyond this
*	size the oldest lines are deleted and the new lines are added to
*	the end of the file.
*
*	author: bsy
*       modified: dwm, bt
*	date: Friday Jan 11 1985 1:14 pm
*	
*******************************************************************/

#include <fcntl.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <ctype.h>
#include <signal.h>

#define	CMSPORT		"/dev/ttyd5"
#define CMSLOG		"/usr/local/logs/aeclog"
#define CMSTOT          "/usr/local/logs/aectot"
#define LOGSIZE		10000

char line[256] ="";

int count =0;

long filesize();
int fgetline();
char *malloc();
void write_entry();

main()
{
   FILE *term1;

   term1 = fopen(CMSPORT, "r+");
   if (term1 == (FILE *) 0) 
   {
      printf("\7Error opening port.\n");
      exit(1);
   }
   for (;;)
   {
      get_line(term1);   
      if(strncmp(line,"DATE",4) == 0)
      {
         write_total(line);
	 write_entry(line);
 	 get_line(term1);   
	 write_total(line); 
      }
      write_entry(line);
   }
}

long filesize(file)
FILE *file;
{
   int fd;
   struct stat buf;

   fstat(fileno(file),&buf);  
   return(buf.st_size);
}

int fgetline(file,line,numofchars)
FILE *file;
char line[256];
int numofchars;
{
   int count = 0;

   line[count++] = fgetc(file);

   while (!feof(file) &&
	  ((line[count] = fgetc(file)) != '\n') &&
	  (count < numofchars))
   {
       count++;
   }
   line[count] = '\0';

   return(count);
}

int fileread(file,line,numofchars)
FILE *file;
char line[256];
int numofchars;
{
   int count =0;

   while (!feof(file) && count < numofchars)
   {
       line[count++] = fgetc(file);
   }

   return(count);
}

void write_entry(line)
char line[256];
{
   FILE *logfile;
   int logf;
   char *ptr1, *tempfile;
   int i, lsize, delc, tempsize, dc, size;

   logfile = fopen(CMSLOG, "a+");

   fprintf(logfile,"%s",line);  

   fflush(logfile);
   lsize = filesize(logfile);
   fclose(logfile);


   if( lsize >= LOGSIZE)
   {
      dc = 0;
      tempsize = LOGSIZE + 1000;
      tempfile =  malloc(tempsize);
      if(tempfile == 0)
      {
	 printf("aec : Unable to get %d bytes \n" ,tempsize);
	 printf("aec : Must decrease LOGSIZE in aec.c\n");
	 printf("aec : Aeclog lines not deleted\n");
      }
      else
      {
	 ptr1 = tempfile;
         logfile = fopen(CMSLOG,"r+"); 

	 while(!feof(logfile))
	    *ptr1++ = getc(logfile);

         fclose(logfile);

	 ptr1 = tempfile + (lsize - LOGSIZE) + 2000;
	       
	 while(*ptr1 != '\n') 
	    ptr1++;

/*
         for (i=0;(ptr1 + i)<(tempfile+lsize);i++)
	 {
	    if (*(ptr1 + i) == '\0')
	       printf("Null Pointer\n");
	    printf("%c",*(ptr1 + i));
         }
	 getchar();
*/ 

	 logfile = fopen(CMSLOG,"w");
	 while (ptr1 <= tempfile + lsize -1)
	    fputc(*ptr1++,logfile);

	 fclose(logfile);
      }
   }
}



get_line(term1)
FILE *term1;
{
   char *ptr1,*ptr2;

   fgetline(term1,line,256);

   ptr2 = ptr1 = line;
   while (*ptr1 != '\0')
   {					/* Strip Ctr Chars  from string */
      if(*ptr1 >= 0x20 ) 
         *ptr2++ = *ptr1;
      ++ptr1;
   }
   *ptr2++ = '\n';			/* Copy Newline */
   *ptr2++ = '\0';			/* Copy Null Terminator */
   if (strlen(line) == 1) 
      get_line(term1);
}

write_total(line)
char line[256];
{
   FILE *logfile;

   logfile = fopen(CMSTOT, "a+");
   fprintf(logfile,"%s",line);
   fclose(logfile);
}

filewrite(f,buf,size)
FILE *f;
char *buf;
int size;
{
   while(size)
   {
      size--;
      fputc(buf++,f);
   }
}
