/*
 *  DATE:    09/04/90
 *
 *  AUTHOR:  John Stewart
 *
 *  USAGE:   circuit [ inputfile ]  [ outputfile ]
 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * 
 *
 *  This program reads in an SQL formatted file for circuits from the NMS
 *  system and does some changes to it so that it can be read in (also in
 *  SQL format) by HDMS.  The NMS format is as follows:
 *
 *       Order_Number | Order_Group | A-End | B-End |
 *            Circuit_I.D. Master_Name Descritption
 *
 *  The bars (|) mark off different SQL fields, but in HDMS some of these
 *  fields need to be "turned into" more than one.  For example, the last
 *  field for NMS will be turned into four fields for HDMS.  The four fields
 *  are Circuit I.D., Channel Number, Master Name, and Description.  The
 *  output produced from this program will have the folowing SQL format:
 *
 *       Order_Number | Order_Group | A-End | B-End | Circuit_I.D. |
 *            Channel Number | Master_Name | Description
 *
 *  In the event that there is no channel number, a 0 will be put into that
 *  field.
 *  
 *  The exit codes are:
 *            0 - Successful
 *            1 - Error opening input file for reading.
 *            2 - Error opening output file for writing.
 *
 *  IMPORTANT NOTES!!!!!!
 *
 *            The greatest number of digits that a channel number can
 *       have is two.  As a result, a channel number can only be between
 *       0 and 99.
 *
 *            Because of the way this program is written, when a record
 *       is added to NMS, when you get to the comment field where circuit
 *       i.d., master name and description is entered, you must use the
 *       following rule.  The circuit i.d. should have no spaces, and it
 *       should look like x.xxxxx.xxxx..DP if it has no channel number or
 *       x.xxxxx.xxxx.y.DP where y is the channel number.  In either case,
 *       the two dots are necessary before the DP (either with the channel
 *       number in between them or nothing in between).  The master name
 *       should have no spaces either, BUT if you would like spaces to
 *       appear in HDMS, you may enter the tilde (~) character.  For example,
 *       instead of KINGS CREEK RTU, you would enter KINGS~CREEK~RTU.  The
 *       description can be in virtually any form, the only restriction is
 *       that it cannot have any RETURN characters in it (i.e. it must all
 *       be at the end of the line).
 *
 *            Even though it is somewhat implied in the above paragraph, in
 *       addition to the format that the fields must be in, they must be
 *       present in the file.  This is necessary because if one is missing,
 *       it is indeterminate as to which field is missing (circuit i.d.,
 *       master or description).
 */

#include <stdio.h>
#define EOL '\n'

main(argc, argv)
   int argc;
   char *argv[];
{
   int c, c1, j, i, chan;
   char circuitid[20], infilename[20], outfilename[20];
   FILE *infile, *outfile;
   if (argc<2)
   {
      printf("\nPlease enter the name of the input file.\n---> ");
      scanf("%s",infilename);
   }
   if (argc<3)
   {
      printf("\nPlease enter the name of the output file.\n---> ");
      scanf("%s",outfilename);
   }
   if (argc==3)
   {
      strcpy(infilename,argv[1]);
      strcpy(outfilename,argv[2]);
   }
   infile=fopen(infilename, "r");
   if (infile==NULL)
   {
      printf("\nError opening file %s for reading.\n",infilename);
      exit(1);
   }
   outfile=fopen(outfilename, "w");
   if (outfile==NULL)
   {
      printf("\nError creating file %s for writing.\n",outfilename);
      exit(2);
   }
   while ((c=getc(infile))!=EOF)
   {
      i=0;
      while ((c1=getc(infile))!='|')   /* Order Number */
         putc(c1,outfile);
      putc('|',outfile);
      while ((c1=getc(infile))!='|')   /* Order Group */
	 if (c1!=' ')
            putc(c1,outfile);
      putc('|',outfile);
      while ((c1=getc(infile))!='|')   /* A-End */
	 if (c1!=' ')
            putc(c1,outfile);
      putc('|',outfile);
      while ((c1=getc(infile))!='|')   /* B-End */
	 if (c1!=' ')
            putc(c1,outfile);
      putc('|',outfile);
      while ((c1=getc(infile))!=' ')   /* Circuit I.D. */
      {
	 circuitid[i++]=c1;
      }
      circuitid[i]='\0';
      i=i-3;
      if (circuitid[i-1]=='.')      /* Channel Number */
	 fprintf(outfile,"%s|0|",circuitid);
      else
      {
	 chan=(circuitid[i-1])-48;
	 if (circuitid[i-2]!='.')
	    chan=chan+((circuitid[i-2]-48)*10);
         fprintf(outfile,"%s|%d|",circuitid,chan);
      }
      while ((c1=getc(infile))==' ')
	 ;
      if (c1=='~')
         putc(' ',outfile);
      else
         putc(c1,outfile);
      while ((c1=getc(infile))!=' ')   /* Master Name */
      {
	 if (c1=='~')
	    putc(' ',outfile);
         else
	    putc(c1,outfile);
      }
      putc('|',outfile);
      while ((c1=getc(infile))==' ')
	 ;
      putc(c1,outfile);                  /* Description */
      while (((c1=getc(infile))!=EOL) && (c1!=EOF))
	 putc(c1,outfile);
      putc('\n',outfile);
   }
   exit(0);
}
