/************************************************************************
*
*	setxl.c
*
*	This program allows a user to redefine an Ann Arbor XL keyboard.
*
*	AUTHOR:      BSY on Charles River Data System
*	MODIFIED:    BT for SCO Xenix system, January 9, 1990
*	             BT for SCO Unix system, June 1990
*
************************************************************************/

#include <stdio.h>
/*
#include <standard.h>
#include <unos.h>
*/

#define KEYPATH 	"/usr/keytext/"
#define TKEYS		110
#define RS		0x1e
#define FALSE		0
#define TRUE		1

char *keyid[] = { "RS", "SU", "F1", "F2", "F3", "F4","F5", "F6", "F7", "F8",
		  "F9", "10", "11", "12", "13", "14", "15", "16",
		  "17", "18", "SE",
		  "EC", "!", "@", "#", "$", "%", "^", "&", "*", "(", ")","_",
		  "=", "`", "|", "BR", "ER", "ED", "DE", "IN", "PR",
		  "TA","q","w","e","r","t","y","u","i","o","p","[","]","LF",
		  "DL","TB","7","8","9","-",
		  "CL","CO","a","s","d","f","g","h","j","k","l",";","'",
		  "CR","BS","4","5","6","+",
		  "PA","SH","z","x","c","v","b","n","m","<",">","?",
		  "SF","SC","ZM",",","1","2","3","EN",
		  "S1","S2","SP","S3","S4","S5","S6","0","00","."};



char *keynum[] = { "120","121","122","123","124","125","126","127",
		  "128","129","130","131","132",
		  "133","134","135","136","137","138","139","140",
		  "80","81","82","83","84","85","86","87","88","89",
		  "90","91","92",
		  "93","94","95","141","142","143","144","145",
		  "60","61","62","63","64","65","66","67","68","69","70",
		  "71","72","73","74","110",
		  "116","117","118","119",
		  "40","41","42","43","44","45","46","47","48","49","50",
		  "51","52","53","54","111",
		  "112","113","114",
		  "20","21","22","23","24","25","26","27","28","29","30",
		  "31","32","33","34","105",
		  "106","107","108","104",
		  "0","1","2","3","4","5","6","100","102","103"};
struct keyinfo {
	char *keytext;
	char *keydis;
	char *keyshift;
	} nkey[112];;

main(argc, argv)
int argc;
char *argv[];
{
   char reply[10];
   char nfile[60];

   erase_screen();
   display_keys(nkey);
   if (argc > 1)				/* an argument */
   {						/* download argument */
      sprintf(nfile, "%s%s", KEYPATH, argv[1]);
      download_layout(nkey, nfile);
   }
   display_menu(1);
   gets(reply);
   curse(17,24);
   erase_line(17,1,0);
   while(strcmp(reply, "4") != 0)		/* reply not '4' - not quit */
   {
      if(strcmp(reply, "1") == 0)		/* reply 1 - modify */
      {
         new_key(nkey);
      }
      if(strcmp(reply, "2") == 0)		/* reply 2 - dload */
      {
	 display_menu(2);
	 gets(reply);
	 sprintf(nfile,  "%s%s", KEYPATH, reply);
         download_layout(nkey, nfile);
      }
      if(strcmp(reply, "3") == 0)		/* reply 3 */
      {
	 display_menu(5);
	 gets(reply);
	 sprintf(nfile, "%s%s", KEYPATH, reply);
         download_layout(nkey, nfile);
         new_key(nkey);
      }
      display_menu(1);
      curse(17,24);
      erase_line(17,1,0);
      gets(reply);
   }
   erase_screen();
   curse(1,1);
   exit(0);
}

/*******************************************************************
*
*	Set the display attribute:
*
*		0 = Normal
*		1 = bold,
*		4 = Underscore,
*		5 = Blinking,
*		7 = Reverse
*
********************************************************************/

blink(x)
int x;
{
   if(x == 0)
   {
      putchar(0x1b);
      printf("[m");				/* reset terminal */
   }
   else
   {
      putchar(0x1b);
      printf("[%dm", x);
   }
}

/********************************************************************
*
*	Move the cursor to the given x,y coordinate.
*
********************************************************************/

curse(x,y)
int x,y;
{
   putchar(0x1b);
   printf("[%d;%dH", x, y);
}

/*********************************************************************
*
*	This function will display the map of the keyboard
*
**********************************************************************/

display_keys(nkey)
struct keyinfo nkey[];
{
   int  key;

   blink(0);
   for (key = 0; key <= TKEYS; key++)
   {
      write_key(key);
   }
}

/**********************************************************************
*
*	Display the menu
*
**********************************************************************/

display_menu(menu)
int menu;
{

   if(menu == 1)
   {
      curse(11,15);
      blink(1);
      printf("Ann Arbor XL Series keyboard modifer");
      blink(0);
      curse(12,5);
      printf("1. Define new key assignments");
      curse(13,5);
      printf("2. Download an existing layout");
      curse(14,5);
      printf("3. Modify an existing layout");
      curse(15,5);
      printf("4. Exit this program");
      curse(17,5);
      printf("Make your choice - ");
   }
   if(menu == 2)
   {
      erase_line(12,10,2);
      curse(12,5);
      printf("Enter the name of the key to modify as shown above");
      curse(13,5);
      printf("or - 'E' to exit this function");
      curse(14,5);
      printf("or - 'S' to save the current setting for future downloads.");
      curse(17,5);
      printf("Make your choice - ");
   }
   if(menu == 3)
   {
      erase_line(12,6,2);
      curse (12,5);
      printf("      Use the following codes for special characters");
      curse(13,5);
      blink(1);
      printf("~M = Return    ~ and a character = Ctrl and that character   ");
      curse(14,5);
      printf("~[ = ESCAPE    ~~ = ~         ~| = |                         ");
      curse(15,5);
      printf("To set key to null, press return by itself.                  ");
      blink(0);
      curse(17,5);
      printf("Press RETURN when complete.");
   }
   if(menu == 4)
   {
      erase_line(12,6,2);
      curse(17,5);
      printf("Enter a layout to download - ");
   }
   if(menu == 5)
   {
      erase_line(12,6,2);
      curse(17,5);
      printf("Enter a layout to modify - ");
   }
}


/*******************************************************************
*
*	Send the download sequence to the CRT
*
********************************************************************/

download(nkey, i)
struct keyinfo nkey[];
int i;
{
   putchar(0x1b);
   if (strcmp(nkey[i].keytext, "\0") == 0)
   {
      printf("P>|%s|%x", keynum[i], 0x00);
   }
   else
   {
      printf("P>|%s;0;0;0;0;|%s", keynum[i], nkey[i].keytext);
   }
   putchar(0x1b);
   putchar(0x5c);
}

/*******************************************************************
*
*	Download a existing layout
*
*******************************************************************/

download_layout(nkey, nfile )
struct keyinfo nkey[];
char nfile[60];
{
   FILE *flay;
   char reply[20], *strsave();
   char *ptr1, *ptr2, nline[256];
   int i, n;

   if((flay = fopen(nfile, "r")) == NULL)
   {
      curse(19,5);
      printf("Unable to open file %s", nfile);
      return;
   }
   ptr2 = nline;
   i = 0;
   while((n = getc(flay)) != EOF)
   {
      if(n == RS)
      {
         *ptr2++ = '\0';
	 nkey[i].keytext = strsave(nline);
	 ptr2 = nline;
	 i++;
      }
      else
      {
	  *ptr2++ = n;
      }
   }
   curse(19,5);
   fclose(flay);
   curse(19,5);
   printf("Now rebuilding key");
   for(i = 0; i <= TKEYS; i++)
   {
      if(strlen(nkey[i].keytext) != 0)
      {
	  curse(19,24);
	  erase_line(19,1, 0);
	  printf("%s (%s)\n", keyid[i], nkey[i].keytext);
	  download(nkey, i);
	  blink(7);
	  write_key(i);
	  blink(0);
      }
   }
   erase_line(19,1,2);
}



/********************************************************************
*
*	Erase the screen
*
********************************************************************/

erase_screen()
{
   putchar(0x1b);
   printf("[2J");
}

/******************************************************************
*
*	Erase line x and y lines after it.
*       When z=0 Erase from cursor to end.
*	When z=1 Erase from start to cursor.
*	When z=2 Erase all of line.
*
******************************************************************/

erase_line(x,y,z)
int x,y,z;
{
   int i;

   for(i=0;i < y; i++)
   {
      putchar(0x1b);
      printf("[%dd", x);
      putchar(0x1b);
      printf("[%dK",z);
      x++;
   }
}

/****************************************************************
*
*	Define new keys to download
*
*****************************************************************/

new_key(nkey)
struct keyinfo nkey[];
{
   int i, x;
   char reply[80], line[80], *strsave();

   display_menu(2);
   curse(17,24);
   gets(reply);
   while(strcmp(reply, "E") != 0)
   {
      for(i=0; i <= TKEYS; i++)
      {
	  if(strcmp(reply, keyid[i]) == 0)
	  {
	      blink(1);
	      write_key(i);
	      blink(0);
	      display_menu(3);
	      if(nkey[i].keytext != '\0')
	      {
		  curse(20,5);
		  printf("Key %s is currently '%s'",
		          keyid[i], nkey[i].keytext);
	      }
	      curse(18,5);
	      gets(line);
	      erase_line(18,1,2);
	      if(strlen(line) != 0)
	      {
		  nkey[i].keytext = strsave(line);
		  download(nkey, i);
		  blink(7);
		  write_key(i);
		  blink(0);
	      }
	      else
	      {          
		  nkey[i].keytext = '\0';
		  download(nkey, i);   
		  write_key(i);
	      }
	      display_menu(2);
	      curse(17,24);
	      erase_line(17,1,0);
	      break;
	   }
      }
      if(strcmp(reply, "S") == 0)
      {
	  save_layout(nkey);
      }
      else if(i >= TKEYS)
      {
	  curse(19,5);
	  printf("'%s' is not valid, reenter", reply);
      }
      erase_line(20,1,2);
      curse(17,24);
      gets(reply);
      curse(17,24);
      erase_line(17,1,0);
      erase_line(19,1,2);
   }
}

/******************************************************************
*
*	Save the download sequences to a file
*
******************************************************************/


save_layout(nkey)
struct keyinfo nkey[];
{
   int i;
   FILE *flay;
   char reply[20], nfile[60];
   char *ptr1;

   erase_line(17,1,2);
   curse(17,5);
   printf("Enter a file name - ");
   gets(reply);

   sprintf(nfile, "%s%s", KEYPATH, reply);

   if((flay = fopen(nfile, "w")) == NULL)
   {
      curse(19,5);
      printf("Unable to create file %s", nfile);
      return;
   }

   for(i = 0; i <= TKEYS; i++)
   {
      if(nkey[i].keytext != '\0')
      {
	  fputs(nkey[i].keytext, flay);
      }
      fputc(RS, flay);
   }

   curse(19,5);
   printf("%s has now been saved.", nfile);
   fclose(flay);
   erase_line(17,1,2);
   curse(17,5);
   printf("Make your choice - ");
}


/******************************************************************
*
*	Save the string in a safe place
*
******************************************************************/

char *strsave(s)
char *s;
{
   char *p, *malloc();

   if (( p = malloc(strlen(s)+1)) != NULL)
      strcpy(p, s);
   return(p);
}



/******************************************************************
*
*	Find the location to display each key, 'key' is the position
*	that is curently active
*
******************************************************************/

write_key(key)
int key;
{
   if(key <= 20)
   {
      if(key == 0)
         curse(2, 3);
      else
         curse(2, (key + 1) * 3);
   }
   else if(key <= 36) 
	curse(4, (key - 20) * 3);
   else if(key <= 41)
	curse(3, (key - 20) * 3);
   else if (key <= 42)
	curse(5, (key - 41) * 3);
   else if(key <= 56)
	curse(5, (key - 41) * 3 + 1);
   else if(key <= 61) 
	curse(5, (key - 40) * 3);
   else if(key <= 76)
	curse(6, (key - 61) * 3);
   else if(key <= 80)
	curse(6, (key - 59) * 3);
   else if(key <= 82)
	curse(7, (key - 80) * 3);
   else if(key <= 95) 
	curse(7, (key - 80) * 3 + 1);
   else if(key <= 100) 
	curse(7, (key - 79) * 3);
   else if(key <= 102)
	curse(8, (key - 100) * 3);
   else if(key == 103)
	curse(8, 20);
   else if(key <= 107)
	curse(8, (key - 92) * 3 + 1);
   else if(key <= 110)
	curse(8, (key - 90) * 3);

   printf("%s", keyid[key]);
   return;
}
