/*************************************************************************
*
*	circrep.fs      
*
*	FORM:	circrep        
*	DESCRIPTION:	This is the script that produces the circuit
*			report.
*
*	AUTHOR:    JWS
*	DATE:      08/14/90
*	REVIEWER:  JWS
*
****************************************************************************/

#define set_select(prevf,curf,fieldname) \
   SET curf:fieldname:SEARCH_RANGES TO prevf:fieldname:SEARCH_RANGES

#define regset '(8U(s0p16.67h8.5v0s0b0T&l0o'

#define pcol(X) '&a',X,'C'

#define setund '&dD'

#define unsetund '&d@'

#define heading(pageno) \
   WRITE PIPELINE circrep:pipe1 regset, setund, pcol(1), current_date$(), \
      '   ', current_time$(), '                                          ', \
      'Circuit Report                                        Page: ', \
      pageno, unsetund, '\n'

#define FormFeed char_code_to_str$(12)

#define addline \
   IF $LINENO > 54 THEN \
   BEGIN \
      WRITE PIPELINE circrep:pipe1 char_code_to_str$(12); \
      SET $PAGE TO $PAGE + 1; \
      heading($PAGE); \
      SET $LINENO TO 0; \
   END \
   ELSE \
      SET $LINENO TO $LINENO + 1

FORM circrep         

TARGET_TABLE mastcir

LOCAL sel, circid, typ, vendor, ord, speed, mname, site, phone, location,
   aend, acb, apara, bend, bcb, bpara, tn, member, access, mname, nomtx,
   nomrx, route;

BEFORE FORM

   SET $mnametitle TO 'Master Name: '
   SET $typetitle TO 'Type: '
   SET $desctitle TO 'Description: '
   SET $circidtitle TO 'Circuit I.D.: '
   SET $ordtitle TO 'Order Number: '
   SET $mtstring TO ''  /* get it, mtstring = emptystring */
   SET $space TO ' '
   SET circrep:$sel TO UNDEFINED
   SET circrep:$printer TO getenv$('SPOOLER')
   SET circrep: AUTO_FIND TO TRUE

BEFORE FIND

   set_select(mastcircin,circrep,mc_name)
   set_select(mastcircin,circrep,mc_type)
   set_select(mastcircin,circrep,mc_desc1)
   set_select(mastcircin,circrep,mc_desc2)
   set_select(mastcircin,circrep,mc_desc3)

   IF circrep:$sel = 2 THEN
   BEGIN
      SET $PAGE TO 1
      SET $LINENO TO 0
      CREATE PIPELINE circrep:$pipe1 '/usr/db/ACL4/aclenv/netops/cprobrep',
               circrep:$printer
      WRITE PIPELINE circrep:$pipe1 regset
      heading(1);
   END

ON FIND
   IF circrep:$sel=2 THEN
   BEGIN
      DISPLAY 'Circuit: ' + circrep:$mc_name FOR FYI_MESSAGE
      IF $LINENO > 54 THEN
      BEGIN
	 SET $PAGE TO $PAGE + 1
	 WRITE PIPELINE circrep:$pipe1 FormFeed
	 heading($PAGE)
	 SET $LINENO TO 0
      END
      WRITE PIPELINE circrep:$pipe1 pcol(1), mnametitle, circrep:mc_name
      SET $LINENO TO $LINENO + 1
      WRITE PIPELINE circrep:$pipe1 pcol(8), typetitle, circrep:mc_type
      SET $LINENO TO $LINENO + 1
      WRITE PIPELINE circrep:$pipe1 pcol(1), desctitle, circrep:mc_desc1
      SET $LINENO TO $LINENO + 1
      IF ((desc2 <> UNDEFINED) AND (desc2 <> '')) THEN
      BEGIN
         WRITE PIPELINE circrep:$pipe1 pcol(15), circrep:$mc_desc2
         SET $LINENO TO $LINENO + 1
      END
      IF ((desc3 <> UNDEFINED) AND (desc3 <> '')) THEN
      BEGIN
         WRITE PIPELINE circrep:$pipe1 pcol(15), circrep:$mc_desc3
         SET $LINENO TO $LINENO + 1
      END
      WRITE PIPELINE circrep:$pipe1 space
      addline
      SET circid, typ, vendor, ord, speed, site, phone, location,
         aend, acb, apara, bend, bcb, bpara, tn, member, access,
	 nomtx, nomrx, route TO
	 SELECT #ci_crcid, #ci_type, #ci_vendo, #ci_ord, #ci_speed,
	    #ci_site, #ci_phone, #ci_loc, #ci_end_a, #ci_a_cb,
	    #ci_a_par, #ci_end_b, #ci_b_cb, #ci_b_par, #ci_tn, #ci_membr,
	    #ci_accss, #ci_nomtx, #ci_nomrx, #ci_route
         FROM cirinfo
         WHERE #ci_mname = circrep:$mc_name
	 ORDER BY #ci_crcid ASCENDING
	 EXECUTING BEGIN
	    IF vendor = 'DPL' THEN
	    BEGIN
	       WRITE PIPELINE circrep:$pipe1 pcol(20), circidtitle,
		  circid, pcol(55), 'Vendor: DPL'
               SET $LINENO TO $LINENO + 1
               WRITE PIPELINE circrep:$pipe1 pcol(20), ordtitle,
		  ord, pcol(56), 'Speed: ', speed
               SET $LINENO TO $LINENO + 1
               WRITE PIPELINE circrep:pipe1 pcol(28), 'Site: ',
		  site, pcol(49), 'Phone Number: ', phone
               SET $LINENO TO $LINENO + 1
	       WRITE PIPELINE circrep:$pipe1 pcol(28), 'Type: ',
		  typ, pcol(53), 'Location: ', location
               SET $LINENO TO $LINENO + 1
	       WRITE PIPELINE circrep:$pipe1 pcol(30), 'A-End: ', 
		  aend, pcol(52), 'C.B.: ', acb, pcol(74), 'A-Para: ',
		  apara
               SET $LINENO TO $LINENO + 1
               WRITE PIPELINE circrep:$pipe1 pcol(30), 'B-End: ', bend,
		  pcol(52), 'C.B.: ', bcb, pcol(74), 'B-Para: ', bpara
               SET $LINENO TO $LINENO + 1
	       WRITE PIPELINE circrep:$pipe1 space
	       addline
            END
	    ELSE
	    BEGIN
	       WRITE PIPELINE circrep:$pipe1 pcol(20), circidtitle, circid,
		  pcol(57), 'Vendor: ', vendor
               SET $LINENO TO $LINENO + 1
	       WRITE PIPELINE circrep:$pipe1 pcol(30), 'TN: ', tn,
		  pcol(57), 'Member: ', member
               SET $LINENO TO $LINENO + 1
	       WRITE PIPELINE circrep:$pipe1 pcol(21), 'Access Code: ',
		  access, pcol(59), 'Site: ', site
               SET $LINENO TO $LINENO + 1
	       WRITE PIPELINE circrep:$pipe1 pcol(22), 'Nominal TX: ',
		  nomtx, pcol(53), 'Nominal RX: ', nomrx
               SET $LINENO TO $LINENO + 1
	       WRITE PIPELINE circrep:$pipe1 pcol(24), 'Location: ',
		  location
               SET $LINENO TO $LINENO + 1
	       WRITE PIPELINE circrep:$pipe1 space
	       addline
            END
         END
         WRITE PIPELINE circrep:pipe1 '- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -'
         addline
   END
   IF circrep:$sel=3 THEN
   BEGIN
      IF $LINENO > 54 THEN
      BEGIN
	 SET $PAGE TO $PAGE + 1
	 WRITE PIPELINE circrep:$pipe1 FormFeed
	 heading($PAGE)
	 SET $LINENO TO 0
      END
      WRITE PIPELINE circrep:$pipe1 pcol(1), mnametitle, circrep:mc_name
      SET $LINENO TO $LINENO + 1
      WRITE PIPELINE circrep:$pipe1 pcol(8), typetitle, circrep:mc_type
      SET $LINENO TO $LINENO + 1
      IF circrep:mc_desc1 <> '' THEN
      BEGIN
         WRITE PIPELINE circrep:$pipe1 pcol(1), desctitle,
	    circrep:mc_desc1
         SET $LINENO TO $LINENO + 1
      END
      IF circrep:mc_desc2 <> '' THEN
      BEGIN
         WRITE PIPELINE circrep:$pipe1 pcol(15), circrep:mc_desc2
         SET $LINENO TO $LINENO + 1
      END
      IF circrep:mc_desc3 <> '' THEN
      BEGIN
         WRITE PIPELINE circrep:$pipe1 pcol(15), circrep:mc_desc3
         SET $LINENO TO $LINENO + 1
      END
      WRITE PIPELINE circrep:$pipe1 space
      addline
      SET circid, typ, vendor, ord, speed, site, phone, location,
         aend, acb, apara, bend, bcb, bpara, tn, member, access,
	 nomtx, nomrx, route TO
	 SELECT #ci_crcid, #ci_type, #ci_vendo, #ci_ord, #ci_speed,
	    #ci_site, #ci_phone, #ci_loc, #ci_end_a, #ci_a_cb,
	    #ci_a_par, #ci_end_b, #ci_b_cb, #ci_b_par, #ci_tn, #ci_membr,
	    #ci_accss, #ci_nomtx, #ci_nomrx, #ci_route
         FROM cirinfo
         WHERE #ci_mname = circrep:$mc_name
	 ORDER BY #ci_site ASCENDING
	 EXECUTING BEGIN
	    IF vendor = 'DPL' THEN
	    BEGIN
	       WRITE PIPELINE circrep:$pipe1 pcol(20), circidtitle,
		  circid, pcol(57), typetitle, typ
               SET $LINENO TO $LINENO + 1
               WRITE PIPELINE circrep:$pipe1 pcol(20), ordtitle,
		  ord, pcol(56), 'Speed: ', speed
               SET $LINENO TO $LINENO + 1
               WRITE PIPELINE circrep:$pipe1 pcol(28), 'Site: ', site,
		  pcol(49), 'Phone Number: ', phone
               SET $LINENO TO $LINENO + 1
	       WRITE PIPELINE circrep:$pipe1 pcol(24), 'Location: ',
		  location
               SET $LINENO TO $LINENO + 1
	       WRITE PIPELINE circrep:$pipe1 pcol(30), 'A-End: ', 
		  aend, pcol(52), 'C.B.: ', acb, pcol(74), 'A-Para: ',
		  apara
               SET $LINENO TO $LINENO + 1
               WRITE PIPELINE circrep:$pipe1 pcol(30), 'B-End: ',
		  bend, pcol(52), 'C.B.: ', bcb, pcol(74), 'B-Para: ',
		  bpara
               addline
            END
	    ELSE
	    BEGIN
	       WRITE PIPELINE circrep:$pipe1 pcol(20), circidtitle,
		  circid, pcol(57), 'Vendor: ', vendor
               SET $LINENO TO $LINENO + 1
	       WRITE PIPELINE circrep:$pipe1 pcol(30), 'TN: ', tn,
		  pcol(57), 'Member: ', member
               SET $LINENO TO $LINENO + 1
	       WRITE PIPELINE circrep:$pipe1 pcol(21), 'Access Code: ',
		  access, pcol(59), 'Site: ', site
               SET $LINENO TO $LINENO + 1
	       WRITE PIPELINE circrep:$pipe1 pcol(22), 'Nominal TX: ',
		  nomtx, pcol(53), 'Nominal RX: ', nomrx
               SET $LINENO TO $LINENO + 1
	       WRITE PIPELINE circrep:$pipe1 pcol(24), 'Location: ',
		  location
               addline
            END /* ELSE */
         END /* EXECUTING BEGIN */
         WRITE PIPELINE circrep:pipe1 '- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -'
         addline
   END /* IF sel=3 */

AFTER FIND
   IF ((circrep:$sel=2) OR (circrep:$sel=3)) THEN
   BEGIN
      CLOSE PIPELINE circrep:$pipe1
      DISPLAY 'Done printing.  Press RETURN to continue.' FOR FYI_MESSAGE WAIT;
      SET circrep:$sel TO UNDEFINED
   END

FIELD sel
   BEFORE FIELD
      SET circrep:$sel TO UNDEFINED
   ON FIELD
      INPUT
      SWITCH circrep:$sel
      BEGIN
	 CASE 1:
   BEGIN
      SET $PAGE TO 1
      SET $LINENO TO 0
      CREATE PIPELINE circrep:$pipe1 '/usr/db/ACL4/aclenv/netops/cprobrep',
         circrep:$printer
      heading(1);
      WRITE PIPELINE circrep:$pipe1 pcol(1), setund, 'Master Circuit: ',
         pcol(20), 'Sub-Circuits: ', pcol(125), unsetund ;
      SET $LINENO TO $LINENO + 1
      WRITE PIPELINE circrep:$pipe1 pcol(1), mnametitle,
	circrep:mc_name
      SET $LINENO TO $LINENO + 1
      WRITE PIPELINE circrep:$pipe1 pcol(8), typetitle, circrep:$mc_type
      SET $LINENO TO $LINENO + 1
      IF circrep:$mc_desc1 <> '' THEN
      BEGIN
         WRITE PIPELINE circrep:$pipe1 pcol(1), desctitle,
	    circrep:$mc_desc1
         SET $LINENO TO $LINENO + 1
      END
      IF circrep:$mc_desc2 <> '' THEN
      BEGIN
         WRITE PIPELINE circrep:$pipe1 pcol(15), circrep:$mc_desc2
         SET $LINENO TO $LINENO + 1
      END
      IF circrep:$mc_desc3 <> '' THEN
      BEGIN
         WRITE PIPELINE circrep:$pipe1 pcol(15), circrep:$mc_desc3
         SET $LINENO TO $LINENO + 1
      END
      WRITE PIPELINE circrep:$pipe1 space
      addline
      SET circid, typ, vendor, ord, speed, site, phone, location,
         aend, acb, apara, bend, bcb, bpara, tn, member, access,
	 nomtx, nomrx, route TO
	 SELECT #ci_crcid, #ci_type, #ci_vendo, #ci_ord, #ci_speed,
	    #ci_site, #ci_phone, #ci_loc, #ci_end_a, #ci_a_cb,
	    #ci_a_par, #ci_end_b, #ci_b_cb, #ci_b_par, #ci_tn, #ci_membr,
	    #ci_accss, #ci_nomtx, #ci_nomrx, #ci_route
         FROM cirinfo
         WHERE #ci_mname = circrep:$mc_name
	 EXECUTING BEGIN
	    IF vendor = 'DPL' THEN
	    BEGIN
	       WRITE PIPELINE circrep:$pipe1 pcol(20), circidtitle,
		  circid, pcol(57), typetitle, typ
               SET $LINENO TO $LINENO + 1
               WRITE PIPELINE circrep:$pipe1 pcol(20), ordtitle,
		  ord, pcol(56), 'Speed: ', speed
               SET $LINENO TO $LINENO + 1
               WRITE PIPELINE circrep:$pipe1 pcol(28), 'Site: ', site,
		  pcol(49), 'Phone Number: ', phone
               SET $LINENO TO $LINENO + 1
	       WRITE PIPELINE circrep:$pipe1 pcol(24), 'Location: ',
		  location
               SET $LINENO TO $LINENO + 1
	       WRITE PIPELINE circrep:$pipe1 pcol(30), 'A-End: ', 
		  aend, pcol(52), 'C.B.: ', acb, pcol(74), 'A-Para: ',
		  apara
               SET $LINENO TO $LINENO + 1
               WRITE PIPELINE circrep:$pipe1 pcol(30), 'B-End: ',
		  bend, pcol(52), 'C.B.: ', bcb, pcol(74), 'B-Para: ',
		  bpara
               SET $LINENO TO $LINENO + 1
	       WRITE PIPELINE circrep:$pipe1 space
               addline
            END
	    ELSE
	    BEGIN
	       WRITE PIPELINE circrep:$pipe1 pcol(20), circidtitle, circid,
		  pcol(57), 'Vendor: ', vendor
               SET $LINENO TO $LINENO + 1
	       WRITE PIPELINE circrep:$pipe1 pcol(30), 'TN: ', tn,
		  pcol(57), 'Member: ', member
               SET $LINENO TO $LINENO + 1
	       WRITE PIPELINE circrep:$pipe1 pcol(21), 'Access Code: ',
		  access, pcol(59), 'Site: ', site
               SET $LINENO TO $LINENO + 1
	       WRITE PIPELINE circrep:$pipe1 pcol(22), 'Nominal TX: ',
		  nomtx, pcol(53), 'Nominal RX: ', nomrx
               SET $LINENO TO $LINENO + 1
	       WRITE PIPELINE circrep:$pipe1 pcol(24), 'Location: ',
		  location
               SET $LINENO TO $LINENO + 1
	       WRITE PIPELINE circrep:$pipe1 space
               addline
            END
         END
         WRITE PIPELINE circrep:$pipe1 '- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -'
         addline
	 CLOSE PIPELINE circrep:$pipe1
	 DISPLAY 'Done printing.  Press RETURN to continue.'
            FOR FYI_MESSAGE WAIT;
      SET circrep:$sel TO UNDEFINED
   END
	 CASE 2:
	 BEGIN
	    DISPLAY 'Pirinting selected records, please wait...'
	    FOR FYI_MESSAGE
            NEXT ACTION IS FIND
         END
	 CASE 3:
	 BEGIN
           SET $PAGE TO 1
           SET $LINENO TO 0
           CREATE PIPELINE circrep:$pipe1 '/usr/db/ACL4/aclenv/netops/cprobrep',
              circrep:$printer
           heading(1);
           NEXT ACTION IS FIND
         END
         DEFAULT:
	 BEGIN
	    beep$(1)
	    DISPLAY 'Please choose only 1 or 2.  Press RETURN to try again.'
	       FOR FYI_MESSAGE WAIT;
	    RESTART ON FIELD
         END
      END
