/**************************************************************************
*
*	clsprjrep.fs    
*
*	FORM:	clsprjrep      
*	DESCRIPTION:
*
*	AUTHOR:    JWS
*	DATE:      08/27/91
*	REVIEWER:  JWS
*
****************************************************************************/

#define set_select(prevf,curf,fieldname) \
   SET curf:fieldname:SEARCH_RANGES TO prevf:fieldname:SEARCH_RANGES

#define pcol(X) '&a',X,'C'

#define FormFeed ''

#define nice_font '(8U(s1p12.0v0s0b5T&l0o'

#define regset '(8U(s0p16.67h8.5v0s0b0T&l0o'

FORM clsprjrep       

TARGET_TABLE proj

LOCAL sel, task_amount, budgeted_flag, total_tasks, total_tasks_over,
      over_budget_amount, over_budgeted_flag;

BEFORE FORM
   IF ((user_name$() <> 'yearsley') AND (user_name$() <> 'john')) THEN
   BEGIN
      DISPLAY 'You do not have authorization to use this report.  Press RETURN'
         FOR FYI_MESSAGE WAIT;
      DISPLAY 'Press RETURN and then PREVIOUS-FORM to continue with your work.'
         FOR FYI_MESSAGE WAIT;
   END
   SET sel TO UNDEFINED
   SET clsprjrep:$printer TO getenv$('SPOOLER')
   SET clsprjrep:AUTO_FIND TO TRUE

BEFORE FIND
   set_select(project,clsprjrep,pj_name)
   set_select(project,clsprjrep,pj_stat)
   set_select(project,clsprjrep,pj_site)
   set_select(project,clsprjrep,pj_start)
   set_select(project,clsprjrep,pj_due)
   set_select(project,clsprjrep,pj_compl)
   set_select(project,clsprjrep,pj_cc)
   set_select(project,clsprjrep,pj_reqby)
   set_select(project,clsprjrep,pj_desc)
   set_select(project,clsprjrep,pj_desc2)
   set_select(project,clsprjrep,pj_desc3)
   set_select(project,clsprjrep,pj_north)
   set_select(project,clsprjrep,pj_south)
   set_select(project,clsprjrep,pj_us)

ON FIND
IF ((user_name$() = 'yearsley') OR (user_name$() = 'john')) THEN
BEGIN
   IF sel = '1' THEN
   BEGIN
      SET task_amount TO 0
      SET budgeted_flag TO 'Y'
      SET total_tasks TO 0
      SET total_tasks_over TO 0
      SET over_budget_amount TO 0
      SET over_budget_flag TO FALSE
      SET budgeted_flag, task_amount TO
         SELECT #tk_budgt, #tk_amou
         FROM task
         WHERE #tk_proj=pj_name
      EXECUTING BEGIN
         SET total_tasks TO (total_tasks + 1)
         IF budgeted_flag = 'N' THEN
         BEGIN
            SET total_tasks_over TO (total_tasks_over + 1)
            SET over_budget_flag TO TRUE
            SET over_budget_amount TO (over_budget_amount + task_amount)
         END
      END
      WRITE PIPELINE clsprjrep:$pipe1 nice_font, pcol(138), 'Delmarva'
      WRITE PIPELINE clsprjrep:$pipe1 nice_font, pcol(142), 'Power'
      WRITE PIPELINE clsprjrep:$pipe1 '________________________________________________________________________________________'
      WRITE PIPELINE clsprjrep:$pipe1 pcol(119), 'Internal Correspondence'
      WRITE PIPELINE clsprjrep:$pipe1 ''
      WRITE PIPELINE clsprjrep:$pipe1 ''
      WRITE PIPELINE clsprjrep:$pipe1 ''
      WRITE PIPELINE clsprjrep:$pipe1 'Date:\t\t\t  ', current_date$()
      WRITE PIPELINE clsprjrep:$pipe1 ''
      WRITE PIPELINE clsprjrep:$pipe1 'Subject:\t\t Project Complete'
      WRITE PIPELINE clsprjrep:$pipe1 ''
      WRITE PIPELINE clsprjrep:$pipe1 'From:\t\t\t Bruce S. Yearsley'
      WRITE PIPELINE clsprjrep:$pipe1 ''
      WRITE PIPELINE clsprjrep:$pipe1 'To:\t\t\t  ', pj_reqby
      WRITE PIPELINE clsprjrep:$pipe1 ''
      WRITE PIPELINE clsprjrep:$pipe1 ''
      WRITE PIPELINE clsprjrep:$pipe1 '\t\tProject ', pj_name,' was completed on ',pj_compl, '.  Please sign "Step D" of the request'
      WRITE PIPELINE clsprjrep:$pipe1 '\t\tform to close out this project and return to Sue Rinehart in Planning & Control at the'
      WRITE PIPELINE clsprjrep:$pipe1 '\t\tData Center.'
      WRITE PIPELINE clsprjrep:$pipe1 '\t\t'
      IF over_budget_flag = TRUE THEN
      BEGIN
         WRITE PIPELINE clsprjrep:$pipe1 '\t\tNote that there were ', val_to_str$(total_tasks_over), ' tasks (out of ', val_to_str$(total_tasks), ') that were unbudgeted.  This amounted to a total'
         WRITE PIPELINE clsprjrep:$pipe1 '\t\tof $', val_to_str$(over_budget_amount), ' in unbudgeted equipment and technician hours.'
      END
      WRITE PIPELINE clsprjrep:$pipe1 ''
      WRITE PIPELINE clsprjrep:$pipe1 ''
      WRITE PIPELINE clsprjrep:$pipe1 '\t\t\t\t\t\t\t\tThank You,'
      WRITE PIPELINE clsprjrep:$pipe1 ''
      WRITE PIPELINE clsprjrep:$pipe1 ''
      WRITE PIPELINE clsprjrep:$pipe1 ''
      WRITE PIPELINE clsprjrep:$pipe1 '\t\t\t\t\t\t\t\tBruce Yearsley'
      WRITE PIPELINE clsprjrep:$pipe1 '\t\t\t\t\t\t\t\tInformation Systems'
      WRITE PIPELINE clsprjrep:$pipe1 FormFeed
   END
END

AFTER FIND 
    IF sel = '1' THEN
    BEGIN
	CLOSE PIPELINE clsprjrep:$pipe1
	DISPLAY 'Done printing.  Please press RETURN to continue.'
           FOR FYI_MESSAGE WAIT;
    END

FIELD sel
   ON FIELD
      SET sel TO ''
      REFRESH SCREEN
      INPUT
      SWITCH sel
      BEGIN
         CASE '1':
            BEGIN
               DISPLAY 'Printing report.  Please wait.' FOR FYI_MESSAGE;
               CREATE PIPELINE clsprjrep:$pipe1 '/usr/db/ACL4/aclenv/netops/cprobrep',
                  clsprjrep:$printer
               NEXT ACTION IS FIND
            END
         DEFAULT:
            BEGIN
               DISPLAY 'Please enter 1 or F1 only.  Press RETURN to try again.'
                  FOR FYI_MESSAGE WAIT;
               RESTART ON FIELD
            END
      END
