/**************************************************************************
*
*    crosconrep.fs   
*
*    FORM:    crosconrep     
*    DESCRIPTION:	This script prints the report on DSX Jack
*			Cross Connections.
*
*    AUTHOR:    PRG
*    DATE:      2/1/91
*    REVIEWER:  PRG
*
****************************************************************************/

#define ESC char_code_to_str$(27)
#define MAXLINES 80
#define set_select(prevf,curf,fieldname) \
   SET curf:fieldname:SEARCH_RANGES TO prevf:fieldname:SEARCH_RANGES
#define pcol(X) '&a',X,'C'
#define FormFeed char_code_to_str$(12)
#define mtstring ''  /* get it, mtstring = emptystring */
#define regset '(8U(s0p16.67h8.5v0s0b0T&l0o'
#define setund '&dD'
#define unsetund '&d@'
#define heading(pageno) \
   WRITE PIPELINE crosconrep:$pipe1 regset, pcol(1), current_date$(), ' ', current_time$(), pcol(52), 'Cross Connect Report', pcol(110), 'Page: ', pageno, regset; \
   WRITE PIPELINE crosconrep:$pipe1 '';\
   WRITE PIPELINE crosconrep:$pipe1 pcol(45), 'X Side of Circuit', pcol(93), 'Y Side of Circuit'; \
   WRITE PIPELINE crosconrep:$pipe1 setund, 'Circuit ID', pcol(27), 'Site ID', pcol(38), 'Panel Name', pcol(57), 'Side', pcol(65), 'Jack #', pcol(76), 'C Type', pcol(86), 'Panel Name', pcol(105), 'Side', pcol(114), 'Jack #', unsetund;

#define addline \
   IF $LINENO > 57 THEN \
   BEGIN \
      WRITE PIPELINE crosconrep:$pipe1 FormFeed; \
      SET $PAGE TO ($PAGE + 1); \
      heading($PAGE); \
      SET $LINENO TO 5; \
   END \
   ELSE \
      SET $LINENO TO ($LINENO + 1)

FORM crosconrep       

TARGET_TABLE crosscon

LOCAL PAGE, LINENO

BEFORE FORM 
    SET crosconrep:sel TO UNDEFINED
    SET crosconrep:$printer TO getenv$('SPOOLER')
    SET crosconrep:AUTO_FIND TO TRUE

FIELD sel
    INIT FIELD
        SET crosconrep:$sel TO UNDEFINED
    ON FIELD
        INPUT
        IF sel='1' THEN
        BEGIN
            DISPLAY 'Printing report ... Please wait' FOR FYI_MESSAGE
            CREATE PIPELINE crosconrep:$pipe1 '/usr/db/ACL4/aclenv/netops/cprobrep',crosconrep:$printer
            SET $LINENO TO 1
            SET $PAGE TO 1
            heading($PAGE);
            addline
            addline
            addline
            addline
            IF crosconrep:$sel='1' THEN
            BEGIN
                SET $cirid, $site, $xpanl, $xside, $xjack, $ctype, $ypanl, $yside, $yjack TO
                SELECT #cr_cirid, #cr_site, #cr_xpanl, #cr_xside, #cr_xjack, #cr_ctype, #cr_ypanl, #cr_yside, #cr_yjack
                FROM crosscon 
                WHERE crosscon:$cr_cirid = #cr_cirid
                ORDER BY #cr_cirid ASCENDING, #cr_site ASCENDING
                EXECUTING BEGIN
                    WRITE PIPELINE crosconrep:$pipe1 $cirid, pcol(27), $site, pcol(38), $xpanl, pcol(57), $xside, pcol(65), $xjack, pcol(76), $ctype, pcol(86), $ypanl, pcol(105), $yside, pcol(114), $yjack;
                    addline
                END
            END
            CLOSE PIPELINE crosconrep:$pipe1
            DISPLAY 'Done printing ... Press RETURN' FOR FYI_MESSAGE WAIT
        END
