/**************************************************************************
*
*    crosscon.fs     
*
*    FORM:    crosscon       
*    DESCRIPTION:	This script handles the crosscon form that
*			tracks DSX Jack Cross Connections.
*
*    AUTHOR:    PRG
*    DATE:      1/30/91
*    REVIEWER:  PRG
*
****************************************************************************/

FORM crosscon        

TARGET_TABLE crosscon

LOCAL update_ok;

BEFORE UPDATE
    beep$(1);
    DISPLAY 'You cannot update cross connections.  You must delete then add.' FOR FYI_MESSAGE WAIT
    REJECT OPERATION
 
BEFORE ADD
    SET update_ok TO TRUE 

    /* check if user is hooking a jack to itself */

    IF $cr_xpanl=$cr_ypanl AND
       $cr_xside=$cr_yside AND
       $cr_xjack=$cr_yjack THEN
    BEGIN
        beep$(1);
        DISPLAY 'You cannot hook a jack to itself.' FOR FYI_MESSAGE WAIT;
        SET update_ok TO FALSE
    END
	ELSE
    BEGIN
        /* update "x" side jack records */

        SET circuit_id TO 
            SELECT #dj_cirid
            FROM dsxjack
            WHERE #dj_panel=$cr_xpanl AND 
                  #dj_side=$cr_xside AND
                  #dj_jackn=$cr_xjack 
  
        /* if no records were selected */ 
        IF status$() = -35 THEN   
        BEGIN
            DISPLAY 'No records were found with the current X or Y side of circuit' FOR FYI_MESSAGE WAIT
            DISPLAY 'Check panel name, side, and jack number or ZOOM to DSX Jack Summary to verify.' FOR FYI_MESSAGE WAIT
            SET update_ok TO FALSE
        END

        /* check to see if that jack is already taken */

        IF circuit_id<>'' AND circuit_id<>UNDEFINED THEN
        BEGIN
            DISPLAY 'Sorry that "X" side jack number is already taken.'
            FOR FYI_MESSAGE WAIT;
            SET update_ok TO FALSE;
        END
        
       /* update "y" side jack records */
    
        SET circuit_id TO 
            SELECT #dj_cirid
            FROM dsxjack
            WHERE #dj_panel=$cr_ypanl AND 
                  #dj_side=$cr_yside AND
                  #dj_jackn=$cr_yjack 
        
        /* if no records were selected */ 
        IF status$() = -35 THEN   
        BEGIN
            DISPLAY 'No records were found with the current X or Y side of circuit' FOR FYI_MESSAGE WAIT
            DISPLAY 'Check panel name, side, and jack number or ZOOM to DSX Jack Summary to verify.' FOR FYI_MESSAGE WAIT
            SET update_ok TO FALSE
        END
    
        /* check to see if that jack is already taken */

        IF circuit_id<>'' AND circuit_id<>UNDEFINED THEN
        BEGIN
            DISPLAY 'Sorry that "Y" side jack number is already taken.'
            FOR FYI_MESSAGE WAIT;
            SET update_ok TO FALSE;
        END
   
        /* if the jack numbers exist and they are free add */
        /*             add the cross connection            */

        IF update_ok=TRUE THEN
        BEGIN
            UPDATE dsxjack 
            SET #dj_cirid TO crosscon:$cr_cirid
                WHERE #dj_panel=$cr_xpanl AND 
                      #dj_side=$cr_xside AND
                      #dj_jackn=$cr_xjack 
            UPDATE dsxjack 
            SET #dj_cirid TO crosscon:$cr_cirid
                WHERE #dj_panel=$cr_ypanl AND 
                      #dj_side=$cr_yside AND
                      #dj_jackn=$cr_yjack 
        END
        ELSE 
        BEGIN
            REJECT OPERATION
        END
    END

ON CLEAR TO ADD
    /* sets cross connection type to default to 'X' */
    SET cr_ctype TO 'X'    

BEFORE DELETE
    /* Checks to see if user really wants to delete the cross 
       connection.  If he does then "blank out" the dj_cirid field
       in the dsxjack table so that the jack record reflects the 
       the cross connect deletion. */

    IF (yesno$('Do you really want to delete this cross connection? ',-1)) THEN
    BEGIN
        DISPLAY 'Deleting...' FOR FYI_MESSAGE
        UPDATE dsxjack
            SET #dj_cirid, #dj_ename, #dj_taken TO '','','N'
            WHERE (#dj_panel=$cr_xpanl AND
                   #dj_side=$cr_xside AND
                   #dj_jackn=$cr_xjack) OR
                  (#dj_panel=$cr_ypanl AND
                   #dj_side=$cr_yside AND
                   #dj_jackn=$cr_yjack)
    END
    ELSE
        REJECT OPERATION

FIELD cr_cirid
	 WHEN FIELD CHANGES
		  SET cr_cirid: CLEAR_ADD_EXP TO cr_cirid

FIELD cr_xpanl
    /* When zooming from the X side set the circuit_side variable to
       'X' so that the dsxjacks form will find the correct jacks and
       return the correct information to the crosscon form */
    BEFORE FIELD
        SET circuit_side TO 'X'
        ENABLE ZOOM TO dsxjacks 

FIELD cr_ypanl
    /* When zooming from the Y side set the circuit_side variable to
       'Y' so that the dsxjacks form will find the correct jacks and
       return the correct information to the crosscon form */
    BEFORE FIELD
        SET circuit_side TO 'Y'
        ENABLE ZOOM TO dsxjacks
