/**************************************************************************
*
*    dsxjacks.fs     
*
*    FORM:    dsxjacks       
*    DESCRIPTION:	This script handles the DSX Jack Summary form
*			to display multiple DSX jacks per screen.
*
*    AUTHOR:    PRG
*    DATE:      1/30/91
*    REVIEWER:  PRG
*
****************************************************************************/

FORM dsxjacks        

TARGET_TABLE dsxjack

BEFORE FORM

    IF PREV_FORM = 'dsxpanel' THEN
    BEGIN  
        SET dj_panel: CLEAR_FIND_EXP TO dsxpanel:$dp_panel
        SET dsxjacks: AUTO_FIND TO TRUE
    END

	 /* 
	  * When zooming from the crosscon form off the 'X' side of the 
	  * circuit this will automatically pull up the jacks that are 
	  * not taken on the current panel.
	  */

    IF PREV_FORM='crosscon' AND crosscon:circuit_side='X' THEN
    BEGIN
        SET dj_panel: CLEAR_FIND_EXP TO crosscon:$cr_xpanl
        SET dj_taken: CLEAR_FIND_EXP TO 'N'
        SET dsxjacks: AUTO_FIND TO TRUE
    END
	 
	 /* 
	  * When zooming from the crosscon form off the 'Y' side of the 
	  * circuit this will automatically pull up the jacks that are 
	  * not taken on the current panel.
	  */

    IF PREV_FORM='crosscon' AND crosscon:circuit_side='Y' THEN
    BEGIN
        SET dj_panel: CLEAR_FIND_EXP TO crosscon:$cr_ypanl
        SET dj_taken: CLEAR_FIND_EXP TO 'N'
        SET dsxjacks: AUTO_FIND TO TRUE
    END

AFTER ZOOM
	 /* 
	  * The after zoom section executes the commands that pull the 
	  * information from dsxjacks to the crosscon form.  It checks
	  * the site from the crosscon form.  If no site is available
	  * it puts the site into the crosscon from this dsxjack table.
	  * If there is a site specified in the crosscon form then it 
	  * checks to see if the data that you tried to pull back from 
	  * this (dsxjacks) form has the same site id as the crosscon 
	  * information.  If the sites differ then the selection of the 
	  * jack is rejected.
	  */

    IF PREV_FORM = 'crosscon' THEN
    BEGIN
        IF crosscon:circuit_side='X' THEN
        BEGIN
            SET $site TO SELECT #dj_site FROM dsxjack 
                WHERE dsxjacks:$dj_panel = #dj_panel AND
                      dsxjacks:$dj_side  = #dj_side AND
                      dsxjacks:$dj_jackn = #dj_jackn
            IF crosscon:$cr_site = UNDEFINED OR crosscon:$cr_site = '' THEN
            BEGIN
                SET crosscon:$cr_site TO $site 
                UPDATE dsxjack SET #dj_taken TO 'T' 
                    WHERE dsxjacks:$dj_panel = #dj_panel AND
                          dsxjacks:$dj_side  = #dj_side AND
                          dsxjacks:$dj_jackn = #dj_jackn
                SET crosscon:$cr_xpanl TO dsxjacks:$dj_panel
                SET crosscon:$cr_xside TO dsxjacks:$dj_side
                SET crosscon:$cr_xjack TO dsxjacks:$dj_jackn
            END
            ELSE IF crosscon:$cr_site <> $site THEN
                 BEGIN
                    beep$(1);
                    DISPLAY 'Cross connects can not be done across sites.' FOR FYI_MESSAGE WAIT;
                 END
                 ELSE /* cr_site is valid */
                    BEGIN
                        SET crosscon:$cr_site TO $site
                        UPDATE dsxjack SET #dj_taken TO 'T' 
                            WHERE dsxjacks:$dj_panel = #dj_panel AND
                                  dsxjacks:$dj_side  = #dj_side AND
                                  dsxjacks:$dj_jackn = #dj_jackn
                        SET crosscon:$cr_xpanl TO dsxjacks:$dj_panel
                        SET crosscon:$cr_xside TO dsxjacks:$dj_side
                        SET crosscon:$cr_xjack TO dsxjacks:$dj_jackn
                    END
        END
        ELSE
        BEGIN
            SET $site TO SELECT #dj_site FROM dsxjack 
                WHERE dsxjacks:$dj_panel = #dj_panel AND
                      dsxjacks:$dj_side  = #dj_side AND
                      dsxjacks:$dj_jackn = #dj_jackn
            IF crosscon:$cr_site = UNDEFINED AND crosscon:$cr_site = '' THEN
            BEGIN
                SET crosscon:$cr_site TO $site
                UPDATE dsxjack SET #dj_taken TO 'T' 
                    WHERE dsxjacks:$dj_panel = #dj_panel AND
                          dsxjacks:$dj_side  = #dj_side AND
                          dsxjacks:$dj_jackn = #dj_jackn
                SET crosscon:$cr_ypanl TO dsxjacks:$dj_panel
                SET crosscon:$cr_yside TO dsxjacks:$dj_side
                SET crosscon:$cr_yjack TO dsxjacks:$dj_jackn
            END
            ELSE IF crosscon:$cr_site <> $site THEN
                 BEGIN
                    beep$(1);
                    DISPLAY 'Cross connects can not be done across sites.' FOR FYI_MESSAGE WAIT;
                 END
                 ELSE /* cr_site is valid */
                    BEGIN
                        SET crosscon:$cr_site TO $site
                        UPDATE dsxjack SET #dj_taken TO 'T' 
                            WHERE dsxjacks:$dj_panel = #dj_panel AND
                                  dsxjacks:$dj_side  = #dj_side AND
                                  dsxjacks:$dj_jackn = #dj_jackn
                        SET crosscon:$cr_ypanl TO dsxjacks:$dj_panel
                        SET crosscon:$cr_yside TO dsxjacks:$dj_side
                        SET crosscon:$cr_yjack TO dsxjacks:$dj_jackn
                    END
        END
    END
