/**************************************************************************
*
*    dsxpanel.fs     
*
*    FORM:    dsxpanel       
*    DESCRIPTION:	This script handles the form that displays the
*			the DSX Panels.
*
*    AUTHOR:    PRG
*    DATE:      1/30/91
*    REVIEWER:  PRG
*
****************************************************************************/

FORM dsxpanel        

TARGET_TABLE dsxpanel

LOCAL a_njacks, b_njacks;

BEFORE FORM
    SET dsxpanel:AUTO_COMMIT TO TRUE

AFTER UPDATE
    /* Create jack number and side records for the current panel */

	 /* A side jacks */
    FOR (SET $num_jacks TO (a_njacks + 1); $num_jacks <= dsxpanel:$dp_njcka;
         SET $num_jacks TO $num_jacks + 1)
        INSERT INTO dsxjack
            #dj_panel, #dj_side, #dj_jackn, #dj_site, #dj_taken:
            dsxpanel:$dp_panel, 'A', $num_jacks, dsxpanel:$dp_site, 'N';

	 /* B side jacks */
    FOR (SET $num_jacks TO (b_njacks + 1); $num_jacks <= dsxpanel:$dp_njckb;
         SET $num_jacks TO $num_jacks + 1)
        INSERT INTO dsxjack
            #dj_panel, #dj_side, #dj_jackn, #dj_site, #dj_taken:
            dsxpanel:$dp_panel, 'B', $num_jacks, dsxpanel:$dp_site, 'N';
    
AFTER ADD 

    /* Create jack number and side records for the current panel */

	 /* A side jacks */
    FOR (SET $num_jacks TO 1; $num_jacks <= dsxpanel:$dp_njcka;
         SET $num_jacks TO $num_jacks + 1)
        INSERT INTO dsxjack
            #dj_panel, #dj_side, #dj_jackn, #dj_site, #dj_taken:
            dsxpanel:$dp_panel, 'A', $num_jacks, dsxpanel:$dp_site, 'N';

    /* B side jacks */
    FOR (SET $num_jacks TO 1; $num_jacks <= dsxpanel:$dp_njckb;
         SET $num_jacks TO $num_jacks + 1)
        INSERT INTO dsxjack
            #dj_panel, #dj_side, #dj_jackn, #dj_site, #dj_taken:
            dsxpanel:$dp_panel, 'B', $num_jacks, dsxpanel:$dp_site, 'N';

BEFORE DELETE
    IF (yesno$('Do you really want to delete this panel and all of its jack records?',-1)) THEN
    BEGIN
        DISPLAY 'Deleting jack records for ' + $dp_panel + '...' FOR FYI_MESSAGE
        DELETE dsxjack WHERE #dj_panel = $dp_panel
        DISPLAY 'Deleting cross connect records for ' + $dp_panel + '...' FOR FYI_MESSAGE
        DELETE crosscon WHERE #cr_xpanl = $dp_panel
        DELETE crosscon WHERE #cr_ypanl = $dp_panel
    END
    ELSE
        REJECT OPERATION
        DISPLAY 'Record was not deleted.' FOR FYI_MESSAGE

FIELD dp_site
    BEFORE FIELD
        ENABLE ZOOM TO site

    /* verify that the site exists */

    ON FIELD
        INPUT
        SET err TO
        SELECT #si_id
        FROM site
        WHERE #si_id = dsxpanel:$dp_site
        IF status$() < 0 THEN
        BEGIN
            beep$(1)
            DISPLAY 'That site is not in the database.' FOR FYI_MESSAGE WAIT
            RESTART ON FIELD
        END

FIELD dp_njcka
    BEFORE FIELD
		  /* initialize the number of jacks for 'A' side at the start */
        SET a_njacks TO dsxpanel:$dp_njcka

FIELD dp_njckb
    BEFORE FIELD
		  /* initialize the number of jacks for 'B' side at the start */
        SET b_njacks TO dsxpanel:$dp_njckb
