/**************************************************************************
*
*    dsxreport.fs    
*
*    FORM:    dsxreport      
*    DESCRIPTION:	This script generates the report for DSX jacks
*			and panels.
*
*    AUTHOR:    PRG
*    DATE:      2/3/91
*    REVIEWER:  PRG
*
****************************************************************************/

#define ESC char_code_to_str$(27)
#define MAXLINES 80
#define set_select(prevf,curf,fieldname) \
   SET curf:fieldname:SEARCH_RANGES TO prevf:fieldname:SEARCH_RANGES
#define pcol(X) '&a',X,'C'
#define FormFeed char_code_to_str$(12)
#define mtstring ''  /* get it, mtstring = emptystring */
#define regset '(8U(s0p16.67h8.5v0s0b0T&l0o'
#define setund '&dD'
#define unsetund '&d@'
#define heading(pageno) \
   WRITE PIPELINE dsxreport:$pipe1 regset ,pcol(1), \
   current_date$(),'   ', current_time$(), \
   '                      DSX Jack Allocation Report                                 Page: ', pageno,'\n', regset; \
   WRITE PIPELINE dsxreport:$pipe1 setund, 'Panel Name', pcol(19), 'Side', pcol(24), 'Jack #', pcol(32), 'Equipment Name', pcol(58),'Circuit ID', unsetund; \

#define addline \
   IF $LINENO > 57 THEN \
   BEGIN \
      WRITE PIPELINE dsxreport:$pipe1 FormFeed; \
      SET $PAGE TO ($PAGE + 1); \
      heading($PAGE); \
      SET $LINENO TO 3; \
   END \
   ELSE \
      SET $LINENO TO ($LINENO + 1)

FORM dsxreport       

TARGET_TABLE dsxpanel

BEFORE FORM 
    SET dsxreport:sel TO UNDEFINED
    SET dsxreport:$printer TO getenv$('SPOOLER')
    SET dsxreport:AUTO_FIND TO TRUE

BEFORE FIND
    set_select(dsxpanel,dsxreport,dp_panel)
    set_select(dsxpanel,dsxreport,dp_site)
    set_select(dsxpanel,dsxreport,dp_loc)
    set_select(dsxpanel,dsxreport,dp_ptype)
    set_select(dsxpanel,dsxreport,dp_njcka)
    set_select(dsxpanel,dsxreport,dp_njckb)

ON FIND
    IF dsxreport:$sel='2' THEN
    BEGIN
        SET $p_side, $jackn, $eq_name, $cir_id TO
        SELECT #dj_side, #dj_jackn, #dj_ename, #dj_cirid
        FROM dsxjack
        WHERE dp_panel = #dj_panel
        ORDER BY #dj_panel ASCENDING, #dj_side ASCENDING, #dj_jackn ASCENDING
        EXECUTING BEGIN
            WRITE PIPELINE dsxreport:$pipe1 dp_panel, pcol(19), $p_side,
               pcol(24), $jackn, pcol(32), $eq_name, pcol(58), $cir_id
            addline
        END
    END

AFTER FIND
    IF dsxreport:$sel='2' THEN
    BEGIN
        CLOSE PIPELINE dsxreport:$pipe1
        DISPLAY 'Done printing ... Press RETURN' FOR FYI_MESSAGE WAIT
    END

FIELD sel
    INIT FIELD
        SET dsxreport:$sel TO UNDEFINED
    ON FIELD
        INPUT
        IF sel='1' THEN
        BEGIN
            DISPLAY 'Printing Report ... Please hold.' FOR FYI_MESSAGE
            CREATE PIPELINE dsxreport:$pipe1 '/usr/db/ACL4/aclenv/netops/cprobrep',dsxreport:$printer
            SET $LINENO TO 0
            SET $PAGE TO 1
            WRITE PIPELINE dsxreport:$pipe1 regset
            heading($PAGE);
            addline
            addline
            SET $p_side, $jackn, $eq_name, $cir_id TO
            SELECT #dj_side, #dj_jackn, #dj_ename, #dj_cirid
            FROM dsxjack
            WHERE dsxpanel:$dp_panel = #dj_panel
            ORDER BY #dj_panel ASCENDING, #dj_side ASCENDING, #dj_jackn ASCENDING
            EXECUTING BEGIN
                WRITE PIPELINE dsxreport:$pipe1 dp_panel, pcol(19), $p_side,
                   pcol(24), $jackn, pcol(32), $eq_name, pcol(58), $cir_id
                addline
            END
            CLOSE PIPELINE dsxreport:$pipe1
        END
        ELSE IF sel='2' THEN
        BEGIN
            CREATE PIPELINE dsxreport:$pipe1 '/usr/db/ACL4/aclenv/netops/cprobrep',dsxreport:$printer
            SET $LINENO TO 1
            SET $PAGE TO 1
            heading($PAGE);
            addline
            addline
            NEXT ACTION IS FIND
        END
