/**************************************************************************
*
*	hdcallsrep.fs   
*
*	FORM:	hdcallsrep     
*	DESCRIPTION:	This form generates the report for the Help
*			Desk Calls Category database.
*
*	AUTHOR:    BT
*	DATE:      Summer 1990
*	REVIEWER:  BT
*
****************************************************************************/

#define set_select(prevf,curf,fieldname) \
   SET curf:fieldname:SEARCH_RANGES TO prevf:fieldname:SEARCH_RANGES

FORM hdcallsrep      

TARGET_TABLE hdcalls

LOCAL sel,printer

BEFORE FORM
   SET hdcallsrep:sel:STOP_FOR_INPUT TO TRUE
   SET hdcallsrep:FIRST_FIELD TO 'sel'
   SET hdcallsrep:AUTO_FIND TO TRUE   
   SET sel TO UNDEFINED
   SET printer TO getenv$('SPOOLER')

BEFORE FIND
   set_select(hdcalls,hdcallsrep,ca_date)
   set_select(hdcalls,hdcallsrep,ca_name)
   set_select(hdcalls,hdcallsrep,ca_total)
   set_select(hdcalls,hdcallsrep,ca_dir)
   set_select(hdcalls,hdcallsrep,ca_seq)
   set_select(hdcalls,hdcallsrep,ca_abd)
   set_select(hdcalls,hdcallsrep,ca_avg)
   set_select(hdcalls,hdcallsrep,ca_tna)
   IF sel = 1 THEN
   BEGIN
      CREATE PIPELINE hdcallsrep:pipe1 'RPT /usr/db/ACL4/rptdir/hdcalls1.r -', printer;
      DISPLAY 'Creating Pipeline' FOR FYI_MESSAGE;
   END
   
ON FIND
   IF sel = 1 THEN
   BEGIN
      DISPLAY 'Printing ' + val_to_str$(ca_date)
      FOR FYI_MESSAGE
      WRITE PIPELINE hdcallsrep:pipe1 ca_date, ca_name, ca_total, ca_dir, ca_seq, ca_abd, ca_avg, ca_tna
   END

AFTER FIND
   IF sel = 1 THEN
   BEGIN
      CLOSE PIPELINE hdcallsrep:pipe1;
      DISPLAY 'Report finished, press RETURN to continue.'
      FOR FYI_MESSAGE WAIT ;
      SET sel TO UNDEFINED
   END

FIELD sel
   ON FIELD
      REFRESH SCREEN
      INPUT
      SWITCH sel
      BEGIN
         CASE 1:
            BEGIN
               DISPLAY 'Printing Report on selected records' FOR FYI_MESSAGE;
               NEXT ACTION IS FIND
            END
         DEFAULT: 
            BEGIN 
               DISPLAY 'Sorry but there is no choice other than 1.  Press RETURN to continue.' FOR FYI_MESSAGE WAIT;
               RESTART ON FIELD
            END
      END
