/**************************************************************************
*
*	lancard.fs      
*
*	FORM:	lancard        
*	DESCRIPTION:	This script handles the form that keeps track
*			of all of the ethernet and, optionally, IP
*			addresses of nodes on any of our LAN's.  When
*			a new node is added or an old node is changed
*			or deleted, a report is built for the Sniffer
*			ethernet analyzer.
*
*	AUTHOR:    JWS
*	DATE:      Spring 1991
*	REVIEWER:  JWS
*
****************************************************************************/

FORM lancard         

TARGET_TABLE lancard

LOCAL node, ethernet, ip

BEFORE FORM
   SET AUTO_COMMIT TO TRUE
   IF PREV_FORM = 'node' THEN
   BEGIN
      SET lancard:ln_node: CLEAR_ADD_EXP TO node:no_id
      SET lancard:ln_node: CLEAR_FIND_EXP TO node:no_id
      SET AUTO_FIND TO TRUE
   END

ON CLEAR TO ADD
   IF PREV_FORM = 'node' THEN
      SET lancard:ln_node: CLEAR_ADD_EXP TO lancard:no_id

AFTER ADD
   DISPLAY 'Please hold ... Creating document for Sniffer' FOR FYI_MESSAGE;
   CREATE PIPELINE lancard:$pipe1 '/usr/db/ACL4/aclenv/netops/cprobrep' OUTPUT IS '/usr/db/ACL4/logs/startup.end';
   SET node, ethernet, ip TO
   SELECT #ln_node, #ln_8023, #ln_tcpip FROM lancard
   EXECUTING BEGIN
      IF strlen$(ethernet)=12 THEN
      BEGIN
         WRITE PIPELINE lancard:$pipe1 'station "', node, '" = addrtype"DLC" ', ethernet;
         IF ((ip <> UNDEFINED) AND (ip <> '')) THEN
            WRITE PIPELINE lancard:$pipe1 'station "', node, '" = addrtype"IP" [', ip, ']';
      END
   END
   CLOSE PIPELINE lancard:$pipe1

AFTER UPDATE
   DISPLAY 'Please hold ... Creating document for Sniffer' FOR FYI_MESSAGE;
   CREATE PIPELINE lancard:$pipe1 '/usr/db/ACL4/aclenv/netops/cprobrep' OUTPUT IS '/usr/db/ACL4/logs/startup.end';
   SET node, ethernet, ip TO
   SELECT #ln_node, #ln_8023, #ln_tcpip FROM lancard
   EXECUTING BEGIN
      IF strlen$(ethernet)=12 THEN
      BEGIN
         WRITE PIPELINE lancard:$pipe1 'station "', node, '" = addrtype"DLC" ', ethernet;
         IF ((ip <> UNDEFINED) AND (ip <> '')) THEN
            WRITE PIPELINE lancard:$pipe1 'station "', node, '" = addrtype"IP" [', ip, ']';
      END
   END
   CLOSE PIPELINE lancard:$pipe1

AFTER DELETE
   DISPLAY 'Please hold ... Creating document for Sniffer' FOR FYI_MESSAGE;
   CREATE PIPELINE lancard:$pipe1 '/usr/db/ACL4/aclenv/netops/cprobrep' OUTPUT IS '/usr/db/ACL4/logs/startup.end';
   SET node, ethernet, ip TO
   SELECT #ln_node, #ln_8023, #ln_tcpip FROM lancard
   EXECUTING BEGIN
      IF strlen$(ethernet)=12 THEN
      BEGIN
         WRITE PIPELINE lancard:$pipe1 'station "', node, '" = addrtype"DLC" ', ethernet;
         IF ((ip <> UNDEFINED) AND (ip <> '')) THEN
            WRITE PIPELINE lancard:$pipe1 'station "', node, '" = addrtype"IP" [', ip, ']';
      END
   END
   CLOSE PIPELINE lancard:$pipe1

ON NEXT FORM
   IF ln_8023 = UNDEFINED THEN
   BEGIN
      beep$(1)
      DISPLAY 'Cannot go to the next form without selecting a record.  Press RETURN to continue.'
         FOR FYI_MESSAGE WAIT
      REJECT OPERATION
   END

/*
FIELD ln_node
   ON FIELD
      INPUT
      SET err TO SELECT #no_id FROM node WHERE #no_id = ln_node
      IF status$() < 0 THEN
      BEGIN
         beep$(1)
         DISPLAY 'That node does not exist, create it before creating LAN Card record.' FOR FYI_MESSAGE WAIT;
         RESTART ON FIELD
      END
*/

FIELD ln_8023
   ON FIELD
      INPUT
      IF ((lancard:ln_8023=UNDEFINED) OR (lancard:ln_8023='')) THEN
      BEGIN
/*         SET $dummy TO
            SELECT #nxt_num FROM nextnum WHERE #nxt_name='ether_num'
         DISPLAY 'The string value of dummy is ' + val_to_str$($dummy) FOR FYI_MESSAGE WAIT;
         SET lancard:ln_8023 TO val_to_str$($dummy)
         UPDATE nextnum
            SET #nxt_num TO (#nxt_num + 1) WHERE #nxt_name='ether_num' */
         beep$(1);
         DISPLAY 'Ethernet address must be entered.  Press RETURN.' FOR FYI_MESSAGE WAIT;
/*         DISPLAY 'A unique value has been temporarily assigned, correct ASAP.  Press RETURN.' FOR FYI_MESSAGE WAIT; */
      END
      SET dummy2 TO substr$(ln_8023,1,4)
      IF ((dummy2='3COM') OR (dummy2='WSTD') OR (dummy2='WEST')) THEN
      BEGIN
         beep$(1)
         DISPLAY 'Please enter the full ethernet address, do not use the vendor name.' FOR FYI_MESSAGE WAIT;
         SET lancard:ln_8023 TO UNDEFINED
         RESTART ON FIELD
      END
