/**************************************************************************
*
*	lancardrep.fs   
*
*	FORM:	lancardrep     
*	DESCRIPTION:	This script does the report generation for
*			the LAN Card database.  Note that the
*			ACCELL/4GL does not have enough power to
*			sort by IP addresses.  The reason is that
*			138.39.5.100 is put before 138.39.5.2.  We
*			therefore wrote an HLI program to do this
*			manually.
*
*	AUTHOR:    JWS
*	DATE:      Spring 1991
*	REVIEWER:  JWS
*
***************************************************************************/

#define set_select(prevf,curf,fieldname) \
   SET curf:fieldname:SEARCH_RANGES TO prevf:fieldname:SEARCH_RANGES

#define regset '(8U(s0p16.67h8.5v0s0b0T&l0o'

#define pcol(X) '&a',X,'C'

#define setund '&dD'

#define unsetund '&d@'

#define heading(pageno) \
   WRITE PIPELINE lancardrep:pipe1 regset, setund, pcol(1), current_date$(), \
      '   ', current_time$(), '                                   ', \
      'Network Addresses Report                                      Page: ', \
      pageno, unsetund, '\n' \
   WRITE PIPELINE lancardrep:pipe1 '' \
   WRITE PIPELINE lancardrep:pipe1 pcol(15), setund, 'Site', pcol(25), \
      'IP Address', pcol(45), 'Node', pcol(70), 'Ethernet Address', \
      pcol(90), 'MMAC        ', unsetund;

#define FormFeed char_code_to_str$(12)

/***************************************************************************
*                                    Script                                *
***************************************************************************/

FORM lancardrep      

TARGET_TABLE lancard

LOCAL sel, site;

BEFORE FORM
   SET lancardrep:sel TO UNDEFINED
   SET lancardrep: sel: STOP_FOR_INPUT TO TRUE
   SET lancardrep:$printer TO getenv$('SPOOLER')
   SET lancardrep: AUTO_FIND TO TRUE

BEFORE FIND
   set_select(lancard,lancardrep,ln_node);
   set_select(lancard,lancardrep,ln_sbnet);
   set_select(lancard,lancardrep,ln_8023);
   set_select(lancard,lancardrep,ln_tcpip);
   set_select(lancard,lancardrep,ln_mmac);
   IF sel='2' THEN
      CREATE PIPELINE lancardrep:pipe1 'RPT /usr/db/ACL4/rptdir/lancard1.r -', lancardrep:$printer;

ON FIND
   IF sel='2' THEN
   BEGIN
      DISPLAY 'Printing information on node ' + ln_node + '.' FOR FYI_MESSAGE;
      SET site TO SELECT #no_site FROM node WHERE #no_id = ln_node
      WRITE PIPELINE lancardrep:pipe1 site, ln_tcpip, ln_node, ln_8023, ln_mmac
   END

AFTER FIND
   IF sel='2' THEN
   BEGIN
      CLOSE PIPELINE lancardrep:pipe1
      DISPLAY 'Done printing report.  Press RETURN to continue.' FOR FYI_MESSAGE WAIT;
   END

FIELD sel
   BEFORE FIELD
      SET sel TO UNDEFINED
   ON FIELD
      INPUT
      SWITCH sel
      BEGIN
         CASE '1': BEGIN
                      CREATE PIPELINE lancardrep:pipe1 '/usr/db/ACL4/aclenv/netops/cprobrep', lancardrep:$printer;
                      heading(1)
                      SET site TO SELECT #no_site FROM node WHERE #no_id=ln_node
                      WRITE PIPELINE lancardrep:pipe1 pcol(15), site, pcol(25), lancard:ln_tcpip, pcol(45), lancard:ln_node, pcol(70), lancard:ln_8023, pcol(90), lancard:ln_mmac
                      CLOSE PIPELINE lancardrep:pipe1
                      DISPLAY 'Done printing single record.  Press RETURN to continue.' FOR FYI_MESSAGE WAIT
                   END
         CASE '2': NEXT ACTION IS FIND
         DEFAULT: beep$(2);
                  DISPLAY 'Please enter only 1, 2, or 3.  Press RETURN to try again.' FOR FYI_MESSAGE WAIT;
                  SET sel TO UNDEFINED
                  RESTART ON FIELD
      END
