/**************************************************************************
*
*	logcon.fs       
*
*	FORM:	logcon         
*	DESCRIPTION:	This script controls the form that tracks the
*			Logical Connection PC printer sharing device.
*
*	AUTHOR:    JWS
*	DATE:      08/10/90
*	REVIEWER:  JWS
*
****************************************************************************/

FORM logcon          

TARGET_TABLE logcon

BEFORE FORM
   IF PREV_FORM = 'node' THEN
   BEGIN
      IF node:$is_it_lc = 1 THEN
      BEGIN
         SET logcon:lc_id: CLEAR_FIND_EXP TO node:no_id
         SET logcon: AUTO_FIND TO TRUE
      END
      ELSE
      BEGIN
         SET logcon:lc_id: CLEAR_FIND_EXP TO node:no_lcid
         SET logcon: AUTO_FIND TO TRUE
      END
   END

ON CLEAR TO ADD
   IF PREV_FORM = 'node' THEN
   BEGIN
      IF node:$is_it_lc = 1 THEN
      BEGIN
         SET logcon:lc_id TO node:no_id
         SET logcon:lc_id: STOP_FOR_INPUT TO FALSE
      END
      ELSE
      BEGIN
         SET logcon:lc_id TO node:no_lcid
         SET logcon:lc_id: STOP_FOR_INPUT TO FALSE
      END
   END

AFTER ZOOM
   IF PREV_FORM = 'node' THEN
      IF node:no_lcid = UNDEFINED THEN
         SET node:no_lcid TO logcon:lc_id

FIELD lc_srpar
   BEFORE FIELD
      IF logcon:lc_srpar = UNDEFINED THEN
         SET logcon:lc_srpar TO 'S'
   ON FIELD
      INPUT
      IF ((logcon:lc_srpar <> 'S') AND (logcon:lc_srpar <> 'P')) THEN
      BEGIN
	 beep$(1)
         DISPLAY 'Valid choices are S and P ONLY.  Press RETURN to continue.'
         FOR FYI_MESSAGE WAIT;
         RESTART ON FIELD
      END
   WHEN FIELD CHANGES
      IF logcon:lc_srpar = 'P' THEN
         SET logcon:lc_comm TO 'N/A'
      IF logcon:lc_srpar = 'S' THEN
         SET logcon:lc_comm TO '9600,8,N,1'

FIELD lc_comm
   BEFORE FIELD
      IF ((logcon:lc_srpar = 'S') AND (lc_comm = UNDEFINED)) THEN
         SET logcon:lc_comm TO '9600,8,N,1'
      IF  logcon:lc_srparr = 'P' THEN
	 SET logcon:lc_comm TO 'N/A'

FIELD lc_conn
   ON FIELD
      INPUT
      UPDATE node SET #no_lcid TO logcon:lc_id WHERE #no_id = logcon:lc_conn

FIELD lc_fixed
   BEFORE FIELD
      IF logcon:lc_fixed = UNDEFINED THEN
         SET logcon:lc_fixed TO 'Y'
   ON FIELD
      INPUT
      IF ((lc_fixed <> 'Y') AND (lc_fixed <> 'N')) THEN
      BEGIN
	 beep$(1)
	 DISPLAY 'Please enter Y or N only.  Press RETURN to continue.' FOR FYI_MESSAGE WAIT;
         RESTART ON FIELD
      END
