/**************************************************************************
*
*	logconrep.fs    
*
*	FORM:	logconrep      
*	DESCRIPTION:	This script generates the reports for the
*			Logical Connections that allow PC to do
*			printer (and other device) sharing.
*
*	AUTHOR:    JWS
*	DATE:      08/15/90
*	REVIEWER:  JWS
*
****************************************************************************/

#define ESC char_code_to_str$(27)
#define MAXLINES 80
#define set_select(prevf,curf,fieldname) \
    SET curf:fieldname:SEARCH_RANGES TO prevf:fieldname:SEARCH_RANGES
#define pcol(X) \
    ESC,'&a',X,'C'
#define FormFeed char_code_to_str$(12)
#define mtstring ''
#define regset \
     ESC,'(8U',ESC,'(s0p16.67h8.5v0s0b0T',ESC,'&l0o'
#define heading(pageno) \
     WRITE PIPELINE logconrep:pipe1 regset, pcol(1), \
     current_date$(), '   ', \
     current_time$(), '     ', \
     '                                      Logcon Report               ', \
     '                           Page: ', pageno, '\n', \
     regset;
#define setund ESC,'&dD'
#define unsetund ESC,'&d@'
#define addline \
   IF $LINENO > 60 THEN \
   BEGIN \
      WRITE PIPELINE logconrep:pipe1 FormFeed; \
      SET PAGE TO (PAGE + 1); \
      heading(PAGE);  \
      SET $LINENO TO 0; \
   END \
   ELSE \
      SET $LINENO TO $LINENO + 1

FORM logconrep       

TARGET_TABLE logcon

LOCAL site, dept, phone, desc1, desc2, desc3, desc4, port, srpar,
   comm, conn, sel;

BEFORE FORM
   SET logconrep:sel TO UNDEFINED
   SET logconrep:$printer TO getenv$('SPOOLER')
   SET logconrep:AUTO_FIND TO TRUE
   SET header TO '                                          Logcon '+
      'Report                                    Page: '

BEFORE FIND
   set_select(logcon,logconrep,lc_id)
   set_select(logcon,logconrep,lc_port)
   set_select(logcon,logconrep,lc_fixed)
   set_select(logcon,logconrep,lc_srpar)
   set_select(logcon,logconrep,lc_comm)
   set_select(logcon,logconrep,lc_conn)

ON FIND
   IF sel=2 THEN
   BEGIN 
      CREATE PIPELINE logconrep:pipe1 '/usr/db/ACL4/aclenv/netops/cprobrep',
         logconrep:$printer
      SET $LINENO to 1
      SET $PAGE TO 1
      heading($PAGE);
      WRITE PIPELINE logconrep:pipe1 pcol(1), setund, 'LogCon I.D.',
         pcol(20), 'Detail', pcol(125), unsetund;
      addline
      SET sernum, site, dept, phone, desc1, desc2, desc3, desc4 TO
         SELECT #no_ser, #no_sit, #no_dept, #no_phone, #no_c1,
             #no_c2, #no_c3, #no_c4
         FROM node WHERE #no_id = logcon:lc_id
         ORDER BY #no_id ASCENDING
      EXECUTING BEGIN
         WRITE PIPELINE logconrep:pipe1 pcol(4), logcon:lc_id, pcol(20),
            'Serial Number: ', sernum
         addline
         WRITE PIPELINE logconrep:pipe1 pcol(20), 'Site: ', site,
            pcol(35), 'Dept: ', dept, pcol(60), 'Phone: ', phone
         addline
         WRITE PIPELINE logconrep:pipe1 pcol(20), 'Comments: ', desc1
         addline
         IF ((desc2 <> UNDEFINED) AND (desc2 <> '')) THEN
         BEGIN
            WRITE PIPELINE logconrep:pipe1 pcol(30), desc2
            addline
         END
         IF ((desc3 <> UNDEFINED) AND (desc3 <> '')) THEN
         BEGIN
            WRITE PIPELINE logconrep:pipe1 pcol(30), desc3
            addline
         END
         IF ((desc4 <> UNDEFINED) AND (desc4 <> '')) THEN
         BEGIN
            WRITE PIPELINE logconrep:pipe1 pcol(30), desc4
            addline
         END
         WRITE PIPELINE logconrep:pipe1 pcol(25), setund, 'Port',
            pcol(32), 'Ser/Par', pcol(41), 'Baud, D, P, S',
            pcol(59), 'Connection',
         unsetund
         addline
         SET port, srpar, comm, conn TO SELECT #lc_port, #lc_srpar,
            #lc_comm, #lc_conn FROM logcon WHERE logcon:lc_id = #lc_id
         EXECUTING BEGIN
            WRITE PIPELINE logconrep:pipe1 pcol(27), port,
               pcol(35), srpar, pcol(41), comm, pcol(59), conn
            addline
         END
         WRITE PIPELINE logconrep:pipe1 ' '
         addline
      END
   END
   IF sel = 3 THEN
   BEGIN
      CREATE PIPELINE logconrep:pipe1 '/usr/db/ACL4/aclenv/netops/cprobrep',
         logconrep:$printer
      SET $LINENO to 1
      SET $PAGE TO 1
      heading($PAGE);
      WRITE PIPELINE logconrep:pipe1 pcol(1), setund, 'LogCon I.D.',
         pcol(20), 'Detail', pcol(125), unsetund;
      addline
      SET sernum, site, dept, phone, desc1, desc2, desc3, desc4 TO
         SELECT #no_ser, #no_sit, #no_dept, #no_phone, #no_c1,
             #no_c2, #no_c3, #no_c4
         FROM node WHERE #no_id = logcon:lc_id
	 ORDER BY #no_sit ASCENDING
      EXECUTING BEGIN
         WRITE PIPELINE logconrep:pipe1 pcol(4), logcon:lc_id, pcol(20),
            'Serial Number: ', sernum
         addline
         WRITE PIPELINE logconrep:pipe1 pcol(20), 'Site: ', site,
            pcol(35), 'Dept: ', dept, pcol(60), 'Phone: ', phone
         addline
         WRITE PIPELINE logconrep:pipe1 pcol(20), 'Comments: ', desc1
         addline
         IF ((desc2 <> UNDEFINED) AND (desc2 <> '')) THEN
         BEGIN
            WRITE PIPELINE logconrep:pipe1 pcol(30), desc2
            addline
         END
         IF ((desc3 <> UNDEFINED) AND (desc3 <> '')) THEN
         BEGIN
            WRITE PIPELINE logconrep:pipe1 pcol(30), desc3
            addline
         END
         IF ((desc4 <> UNDEFINED) AND (desc4 <> '')) THEN
         BEGIN
            WRITE PIPELINE logconrep:pipe1 pcol(30), desc4
            addline
         END
         WRITE PIPELINE logconrep:pipe1 pcol(25), setund, 'Port',
            pcol(32), 'Ser/Par', pcol(41), 'Baud, D, P, S',
            pcol(59), 'Connection',
         unsetund
         addline
         SET port, srpar, comm, conn TO SELECT #lc_port, #lc_srpar,
            #lc_comm, #lc_conn FROM logcon WHERE logcon:lc_id = #lc_id
         EXECUTING BEGIN
            WRITE PIPELINE logconrep:pipe1 pcol(27), port,
               pcol(35), srpar, pcol(41), comm, pcol(59), conn
            addline
         END
         WRITE PIPELINE logconrep:pipe1 ' '
         addline
      END
   END

AFTER FIND
   IF ((sel = 2) OR (sel = 3)) THEN
   BEGIN
      CLOSE PIPELINE logconrep:pipe1
      DISPLAY 'Done printing.  Press ENTER to continue.' FOR FYI_MESSAGE WAIT;
      SET sel TO UNDEFINED
   END
 
FIELD sel
   BEFORE FIELD
      SET sel TO UNDEFINED
   ON FIELD
      INPUT
      SWITCH sel
      BEGIN
	 CASE 1:
	 BEGIN
            CREATE PIPELINE logconrep:$pipe1 '/usr/db/ACL4/aclenv/netops/cprobrep',
               logconrep:$printer
            SET $LINENO to 0
            heading(1);
            WRITE PIPELINE logconrep:pipe1 pcol(1), setund, 'LogCon I.D.',
      pcol(20), 'Detail', pcol(125), unsetund;
   addline
            SET sernum, site, dept, phone, desc1, desc2, desc3, desc4 TO
               SELECT #no_ser, #no_sit, #no_dept, #no_phone, #no_c1,
                      #no_c2, #no_c3, #no_c4
               FROM node WHERE #no_id = logcon:lc_id
            EXECUTING BEGIN
               WRITE PIPELINE logconrep:pipe1 pcol(4), logcon:lc_id, pcol(20),
                  'Serial Number: ', sernum
               addline
               WRITE PIPELINE logconrep:pipe1 pcol(20), 'Site: ', site,
               pcol(35), 'Dept: ', dept, pcol(60), 'Phone: ', phone
               addline
               WRITE PIPELINE logconrep:pipe1 pcol(20), 'Comments: ', desc1
               addline
               IF ((desc2 <> UNDEFINED) AND (desc2 <> '')) THEN
               BEGIN
                  WRITE PIPELINE logconrep:pipe1 pcol(30), desc2
                  addline
               END
               IF ((desc3 <> UNDEFINED) AND (desc3 <> '')) THEN
               BEGIN
                  WRITE PIPELINE logconrep:pipe1 pcol(30), desc3
                  addline
               END
               IF ((desc4 <> UNDEFINED) AND (desc4 <> '')) THEN
               BEGIN
                  WRITE PIPELINE logconrep:pipe1 pcol(30), desc4
                  addline
               END
               WRITE PIPELINE logconrep:pipe1 pcol(25), setund, 'Port',
		  pcol(32), 'Ser/Par', pcol(41), 'Baud, D, P, S',
		  pcol(59), 'Connection',
               unsetund
               addline
               SET port, srpar, comm, conn TO SELECT #lc_port, #lc_srpar,
                  #lc_comm, #lc_conn FROM logcon WHERE logcon:lc_id = #lc_id
               EXECUTING BEGIN
                  WRITE PIPELINE logconrep:pipe1 pcol(27), port,
		     pcol(35), srpar, pcol(41), comm, pcol(59), conn
                  addline
               END
               WRITE PIPELINE logconrep:pipe1 ' '
               addline
               CLOSE PIPELINE logconrep:pipe1
               DISPLAY 'Done printing.  Press ENTER to continue.'
                  FOR FYI_MESSAGE WAIT;
               SET sel TO UNDEFINED
            END
         END
	 CASE 2:
	    NEXT ACTION IS FIND
         CASE 3:
	    NEXT ACTION IS FIND
      END
