/**************************************************************************
*
*	mastcircin.fs   
*
*	FORM:	mastcircin     
*	DESCRIPTION:	This script handles the form for the Master
*			Circuit database.
*
*	AUTHOR:    JWS
*	DATE:      07/23/90
*	REVIEWER:  JWS
*
****************************************************************************/

FORM mastcircin      

TARGET_TABLE mastcir

BEFORE FORM
   IF PREV_FORM = 'problem' THEN
   BEGIN
      IF problem:pr_node <> UNDEFINED THEN
      BEGIN
         SET mastcircin:mc_name TO problem:pr_node
         SET mastcircin: AUTO_FIND TO TRUE
      END
   END

ON NEXT FORM
   IF mastcircin:mc_name=UNDEFINED THEN
   BEGIN
      beep$(3)
      DISPLAY 'Cannot NEXT-FORM without Master name.  Hit RETURN to continue.' FOR FYI_MESSAGE WAIT;
      REJECT OPERATION
   END
   ELSE
      UPDATE CURRENT RECORD

ON NEXT RECORD
   UPDATE CURRENT RECORD

FIELD mc_name
   BEFORE FIELD
      ENABLE ZOOM TO circsum

AFTER ZOOM
   IF PREV_FORM = 'problem' THEN
      SET problem:pr_node TO mastcircin:mc_name
