/**************************************************************************
*
*	netops.as       
*
*	APPLICATION:	netops         
*	DESCRIPTION:	This is the "Application Script" that serves
*			as a starting point for all other forms.  It
*			also sets variables that are used later, an
*			example is "user".
*
*	AUTHOR:    BSY  (Modified by DWM, BT, JWS, PRG)
*	DATE:      7/20/89
*	REVIEWER:
*
*  There is only ONE APPLICATION script for every application.
*
****************************************************************************/

APPLICATION netops

REQUIRED FORMS
   node IN 'netops.fa',
   site IN 'netops.fa',
   vendor IN 'netops.fa',
   vendortext IN 'netops.fa',
   nodes IN 'netops.fa',
   vendorcode IN 'netops.fa',
   problem IN 'netops.fa',
   problems IN 'netops.fa',
   probres IN 'netops.fa',
   probcode IN 'netops.fa',
   pchard IN 'netops.fa',
   pcsoft IN 'netops.fa',
   tprt IN 'netops.fa',
   ecode IN 'netops.fa',
   partsout IN 'netops.fa',
   poreport IN 'netops.fa',
   part IN 'netops.fa',
   parts IN 'netops.fa',
   project IN 'netops.fa',
   task IN 'netops.fa',
   probreport IN 'netops.fa',
   pcreport IN 'netops.fa',
   vendorrep IN 'netops.fa',
   noderep IN 'netops.fa',
   siterep IN 'netops.fa',
   pchardrep IN 'netops.fa',
   pcsoftrep IN 'netops.fa',
   holiday IN 'netops.fa',
   vencoderep IN 'netops.fa',
   projectrep IN 'netops.fa',
   employee IN 'netops.fa',
   softvendor IN 'netops.fa',
   projresp IN 'netops.fa',
   hdtype IN 'netops.fa',
   mastcircin IN 'netops.fa',
   circsum IN 'netops.fa',
   dplcirinfo IN 'netops.fa',
   nondplcirc IN 'netops.fa',
   nextnum IN 'netops.fa',
   phone IN 'netops.fa',
   hdcalls IN 'netops.fa',
   taskrep IN 'netops.fa',
   hdmsforms IN 'netops.fa',
   circrep IN 'netops.fa',
   logcon IN 'netops.fa',
   hdcallsrep IN 'netops.fa',
   sendprob IN 'netops.fa',
   sendprview IN 'netops.fa',
   contact IN 'netops.fa',
   logconrep IN 'netops.fa',
   callcat IN 'netops.fa',
   callcatdsp IN 'netops.fa',
   callcattot IN 'netops.fa',
   callcatgr IN 'netops.fa',
   netsupp IN 'netops.fa',
   partreport IN 'netops.fa',
   orderrep IN 'netops.fa',
   dsxjacks IN 'netops.fa',
   dsxpanel IN 'netops.fa',
   dsxjack IN 'netops.fa',
   crosscon IN 'netops.fa',
   dsxreport IN 'netops.fa',
   crosconrep IN 'netops.fa',
   lancard IN 'netops.fa',
   lancardrep IN 'netops.fa',
   updprices IN 'netops.fa',
   cronmail IN 'netops.fa',
   t1circ IN 'netops.fa',
   pcsoft_ind IN 'netops.fa',
   lansort IN 'netops.fa',
   pcsoftrep2 IN 'netops.fa',
   tcpipudt IN 'netops.fa',
   clsprjrep IN 'netops.fa',
   messages IN 'netops.fa',
   nodemvrep IN 'netops.fa'

BEFORE FORM
   SET user TO '[' + user_name$() + ']'

AFTER FORM RETURN
   SET t_start TO UNDEFINED

ON NEXT FORM
   IF t_start = UNDEFINED THEN
   BEGIN
      beep$(1);
      DISPLAY 'You must enter a number or name of a form before pressing NEXT-FORM.' FOR FYI_MESSAGE WAIT
      REJECT OPERATION
   END

FIELD t_start
   INIT FIELD
      ENABLE ZOOM TO hdmsforms RETURN KEY
   ON FIELD
      SET termtype TO getenv$('TERM')
      INPUT;
      IF t_start = UNDEFINED THEN
         RESTART ON FIELD
      SWITCH t_start
      BEGIN
         CASE '0':
         CASE 'forms': DISPLAY 'Loading HDMS Form List...' FOR FYI_MESSAGE

         CASE '1':
         CASE 'nodes': DISPLAY 'Loading Node Summary Screen...' FOR FYI_MESSAGE

         CASE '2':
         CASE 'node': DISPLAY 'Loading Node Info Screen...' FOR FYI_MESSAGE

         CASE '3':
         CASE 'pchard': DISPLAY 'Loading PC Hardware....' FOR FYI_MESSAGE

         CASE '4':
         CASE 'pcsoft': DISPLAY 'Loading PC Software Codes...' FOR FYI_MESSAGE

         CASE '5':
         CASE 'problems': DISPLAY 'Loading Problems Summary...' FOR FYI_MESSAGE

         CASE '6':
         CASE 'problem': DISPLAY 'Loading Problem Tracking...' FOR FYI_MESSAGE

         CASE '7':
         CASE 'project': DISPLAY 'Loading Project Manager...' FOR FYI_MESSAGE

         CASE '8':
         CASE 'site': DISPLAY 'Loading Site Screen...' FOR FYI_MESSAGE

         CASE '9':
         CASE 'vendor': DISPLAY 'Loading Vendor Screen...' FOR FYI_MESSAGE

         CASE '10':
         CASE 'vcodes': DISPLAY 'Loading Vendor Codes Screen...' FOR FYI_MESSAGE

         CASE '11':
         CASE 'mastcir': DISPLAY 'Loading Master Circuit Screen...' FOR FYI_MESSAGE

         CASE '12':
         CASE 'partsout': DISPLAY 'Loading Parts Out screen...' FOR FYI_MESSAGE

         CASE '13':
         CASE 'task': DISPLAY 'Loading Tasks Database...' FOR FYI_MESSAGE

         CASE '14':
         CASE 'part':
         CASE 'softcat': DISPLAY 'Loading Software Catalog...' FOR FYI_MESSAGE

         CASE 'employee':
         CASE 'users': DISPLAY 'Loading Employee Screen...' FOR FYI_MESSAGE

         CASE 'softvendor': DISPLAY 'Loading Software Vendor Database...' FOR FYI_MESSAGE

         CASE 'vtext': DISPLAY 'Loading Vendor Text Screen...' FOR FYI_MESSAGE

         CASE 'holiday': DISPLAY 'Loading Holiday Database...' FOR FYI_MESSAGE

         CASE 'pcodes': DISPLAY 'Loading Problem Codes Database...' FOR FYI_MESSAGE

         CASE 'mastcir': DISPLAY 'Loading Master Circuit Database...' FOR FYI_MESSAGE

         CASE 'dpl': DISPLAY 'Loading DP&L Circuit Info Database...' FOR FYI_MESSAGE

         CASE 'parts':
         CASE 'softsum': DISPLAY 'Loading Software Summary Database...' FOR FYI_MESSAGE

         CASE 'nondpl': DISPLAY 'Loading non-DP&L Circuit Database...' FOR FYI_MESSAGE

         CASE 'cirsum': DISPLAY 'Loading Circuit Summary Database...' FOR FYI_MESSAGE

         CASE 'nextnum': DISPLAY 'Loading Next Number Database...' FOR FYI_MESSAGE

         CASE 'phone': DISPLAY 'Loading Corp Phone Dir Database...' FOR FYI_MESSAGE

         CASE 'hdtype': DISPLAY 'Loading Hard Disk Type Database...' FOR FYI_MESSAGE

         CASE 'hdcalls': DISPLAY 'Loading HelpDesk Calls Database...' FOR FYI_MESSAGE

         CASE 'sendprob': DISPLAY 'Loading Forwarded Problem Log...' FOR FYI_MESSAGE

         CASE 'contact': DISPLAY 'Loading Problem Contact Database...' FOR FYI_MESSAGE

         CASE 'logcon': DISPLAY 'Loading Logical Connection Database..' FOR FYI_MESSAGE

         CASE 'circrep': DISPLAY 'Loading Circuit Database...' FOR FYI_MESSAGE

         CASE 'callcat':
         CASE 'cc': DISPLAY 'Loading Call Catalogies...' FOR FYI_MESSAGE

         CASE 'ccdisp': DISPLAY 'Loading Display CallCat Results...' FOR FYI_MESSAGE

         CASE 'cctotal': DISPLAY 'Loading CallCat Totals...' FOR FYI_MESSAGE

         CASE 'netsupp': DISPLAY 'Loading Network Supp Database...' FOR FYI_MESSAGE
         CASE 'dsxjacks': DISPLAY 'Loading DSX Jack Summary...' FOR FYI_MESSAGE
         CASE 'dsxpanel': DISPLAY 'Loading DSX Panel Record...' FOR FYI_MESSAGE
         CASE 'crosscon': DISPLAY 'Loading DSX Cross Connect Record...' FOR FYI_MESSAGE
         CASE 'dsxjack': DISPLAY 'Loading DSX Jack Record...' FOR FYI_MESSAGE
         CASE 'lancard' : DISPLAY 'Loading LAN Card Record...' FOR FYI_MESSAGE
         CASE 'updprices' : DISPLAY 'Loading Update Prices Form...' FOR FYI_MESSAGE
         CASE 'cronmail' : DISPLAY 'Loading cronmail Form...' FOR FYI_MESSAGE
         CASE 'probres' : DISPLAY 'Loading probres Form...' FOR FYI_MESSAGE
         CASE 't1circ' : DISPLAY 'Loading t1circ Form...' FOR FYI_MESSAGE
         CASE 'softsite' : DISPLAY 'Loading softsite Form...' FOR FYI_MESSAGE
         CASE 'lansort' : DISPLAY 'Loading lansort Form...' FOR FYI_MESSAGE
         CASE 'messages' : DISPLAY 'Loading messages Form...' FOR FYI_MESSAGE
         CASE 'nodemvrep' : DISPLAY 'Loading nodemvrep Form...' FOR FYI_MESSAGE
         DEFAULT: DISPLAY t_start + ' is not a valid choice, press RETURN to try again.' FOR FYI_MESSAGE WAIT
                  SET t_start TO ''
                  RESTART ON FIELD
      END
      NEXT ACTION IS NEXT FORM

CHOOSE FIRST FORM
   WHEN t_start = 'forms' OR t_start = '0' OR t_start='h' OR t_start='H'
      START TX RECORD_CONSISTENCY
      USING hdmsforms;
   WHEN t_start = 'nodes' OR t_start = '1'
      START TX RECORD_CONSISTENCY
      USING nodes;
   WHEN t_start = 'node' OR t_start = '2'
      START TX RECORD_CONSISTENCY
      USING node;
   WHEN t_start = 'pchard' OR t_start = '3'
      START TX RECORD_CONSISTENCY
      USING pchard;
   WHEN t_start = 'pcsoft' OR t_start = '4'
      START TX RECORD_CONSISTENCY
      USING pcsoft;
   WHEN t_start = 'problems' OR t_start = '5'
      START TX RECORD_CONSISTENCY
      USING problems;
   WHEN t_start = 'problem' OR t_start = '6'
      START TX RECORD_CONSISTENCY
      USING problem;
   WHEN t_start = 'project' OR t_start = '7'
      START TX RECORD_CONSISTENCY
      USING project;
   WHEN t_start = 'site' OR t_start = '8'
      START TX RECORD_CONSISTENCY
      USING site;
   WHEN t_start = 'vendor' OR t_start = '9'
      START TX RECORD_CONSISTENCY
      USING vendor;
   WHEN t_start = 'vcodes' OR t_start = '10'
      START TX RECORD_CONSISTENCY
      USING vendorcode;
   WHEN t_start = 'mastcir' OR t_start = '11'
      START TX RECORD_CONSISTENCY
      USING mastcircin;
   WHEN t_start = 'partsout' OR t_start = '12'
      START TX RECORD_CONSISTENCY
      USING partsout;
   WHEN t_start = 'task' OR t_start = '13'
      START TX RECORD_CONSISTENCY
      USING task;
   WHEN t_start = 'part' OR t_start = '14' OR t_start = 'softcat'
      START TX RECORD_CONSISTENCY
      USING part;
   WHEN t_start = 'parts' OR t_start = 'softsum'
      START TX RECORD_CONSISTENCY
      USING parts;
   WHEN t_start = 'vtext'
      START TX RECORD_CONSISTENCY
      USING vendortext;
   WHEN t_start = 'holiday'
      START TX RECORD_CONSISTENCY
      USING holiday;
   WHEN t_start = 'employee' OR t_start = 'users'
      START TX RECORD_CONSISTENCY
      USING employee;
   WHEN t_start = 'softvendor'
      START TX RECORD_CONSISTENCY
      USING softvendor;
   WHEN t_start = 'pcodes'
      START TX RECORD_CONSISTENCY
      USING probcode;
   WHEN t_start = 'dpl'
      START TX RECORD_CONSISTENCY
      USING dplcirinfo;
   WHEN t_start = 'nondpl'
      START TX RECORD_CONSISTENCY
      USING nondplcirc;
   WHEN t_start = 'cirsum'
      START TX RECORD_CONSISTENCY
      USING circsum;
   WHEN t_start = 'nextnum'
      START TX RECORD_CONSISTENCY
      USING nextnum;
   WHEN t_start = 'phone'
      START TX RECORD_CONSISTENCY
      USING phone;
   WHEN t_start = 'hdtype'
      START TX RECORD_CONSISTENCY
      USING hdtype;
   WHEN t_start = 'hdcalls'
      START TX RECORD_CONSISTENCY
      USING hdcalls;
   WHEN t_start = 'sendprob'
      START TX RECORD_CONSISTENCY
      USING sendprview;
   WHEN t_start = 'contact'
      START TX RECORD_CONSISTENCY
      USING contact;
   WHEN t_start = 'logcon'
      START TX RECORD_CONSISTENCY
      USING logcon;
   WHEN t_start = 'circrep'
      START TX RECORD_CONSISTENCY
      USING circrep;
   WHEN t_start = 'callcat' OR t_start = 'cc'
      START TX RECORD_CONSISTENCY
      USING callcat;
   WHEN t_start = 'ccdisp'
      START TX RECORD_CONSISTENCY
      USING callcatdsp;
   WHEN t_start = 'cctotal'
      START TX RECORD_CONSISTENCY
      USING callcattot;
   WHEN t_start = 'netsupp'
      START TX RECORD_CONSISTENCY
      USING netsupp;
   WHEN t_start = 'dsxjacks'
      START TX RECORD_CONSISTENCY
      USING dsxjacks;
   WHEN t_start = 'dsxpanel'
      START TX RECORD_CONSISTENCY
      USING dsxpanel;
   WHEN t_start = 'dsxjack'
      START TX RECORD_CONSISTENCY
      USING dsxjack;
   WHEN t_start = 'crosscon'
      START TX RECORD_CONSISTENCY
      USING crosscon;
   WHEN t_start = 'lancard'
      START TX RECORD_CONSISTENCY
      USING lancard;
   WHEN t_start = 'updprices'
      START TX RECORD_CONSISTENCY
      USING updprices;
   WHEN t_start = 'cronmail'
      START TX RECORD_CONSISTENCY
      USING cronmail;
   WHEN t_start = 'probres'
      START TX RECORD_CONSISTENCY
      USING probres;
   WHEN t_start = 't1circ'
      START TX RECORD_CONSISTENCY
      USING t1circ;
   WHEN t_start = 'softsite'
      START TX RECORD_CONSISTENCY
      USING pcsoft_ind;
   WHEN t_start = 'lansort'
      START TX RECORD_CONSISTENCY
      USING lansort;
   WHEN t_start = 'messages'
      START TX RECORD_CONSISTENCY
      USING messages;
   WHEN t_start = 'nodemvrep'
      START TX RECORD_CONSISTENCY
      USING nodemvrep;
