/**************************************************************************
*
*	node.fs         
*
*	FORM:	node           
*	DESCRIPTION:	This is one of the more complicated scripts.
*			It manages the Node Information screen that
*			tracks all of our "nodes."  A node can be a
*			CRT, PC, mainframe controller, phone, or
*			any other device that we maintain.
*
*	AUTHORS:   BSY  (Modified by BT, DWM & JWS)
*	DATE:	   7/24/89
*	REVIEWER:  BSY
*
****************************************************************************/

FORM node            

TARGET_TABLE node

LOCAL err, temp_ser;

BEFORE FORM
   SET node: AUTO_COMMIT TO TRUE
   IF node:PREV_FORM = 'task' THEN
   BEGIN
      SET node:no_task:CLEAR_FIND_EXP TO task:tk_taskno
      SET node:no_prnum:CLEAR_FIND_EXP TO task:tk_proj
      SET node:no_task:CLEAR_ADD_EXP TO task:tk_taskno
      SET node:no_prnum:CLEAR_ADD_EXP TO task:tk_proj
      SET node:no_ser:CLEAR_ADD_EXP TO task:tk_proj + val_to_str$(task:tk_taskno)
      SET node:AUTO_FIND TO TRUE
   END
   IF PREV_FORM = 'lancard' THEN
   BEGIN
      IF ((lancard:ln_node<>'') AND (lancard:ln_node<>UNDEFINED)) THEN
      BEGIN
         SET node:no_id: CLEAR_FIND_EXP TO lancard:ln_node
         SET AUTO_FIND TO TRUE
      END
   END
   IF PREV_FORM = 'problem' THEN
   BEGIN
      IF problem:pr_node <> UNDEFINED THEN
      BEGIN
	 SET node:no_id:CLEAR_FIND_EXP TO problem:pr_node
	 SET node:AUTO_FIND TO TRUE
      END
   END
   IF PREV_FORM = 'pchard' THEN
   BEGIN
      SET node:AUTO_FIND TO TRUE
      SET node: no_id: CLEAR_FIND_EXP TO ph_node
   END
   IF PREV_FORM = 'nodes' THEN
   BEGIN
      SET node:AUTO_FIND TO TRUE
      SET node:no_id: CLEAR_FIND_EXP TO nodes:no_id
   END

ON NEXT FORM
   IF no_id = UNDEFINED THEN
   BEGIN 
      beep$(1);
      DISPLAY 'Cannot NEXT-FORM without Node ID.  Hit RETURN.' FOR FYI_MESSAGE WAIT;
      REJECT OPERATION
   END
   ELSE
   BEGIN
      UPDATE CURRENT RECORD
      IF substr$(no_id, 1, 2) = 'LC' THEN
         SET node:$is_it_lc TO 1
   END

ON CLEAR TO ADD					/* Set defaults for C.T.A */
   SET no_trob_prt to 'NCC'			/* Trob Pntr set to NCC */
   SET no_prob_esc_code to 0			/* 0 esc code */
   SET no_install_date to current_date$()
   SET no_prt_dest to 'N/A'
   SET no_floor_jack to 'N/A'
   SET node:$addmode to 1
   SET node:no_contract TO ''
   SET no_osit: STOP_FOR_INPUT TO FALSE

ON CLEAR TO FIND
   SET no_osit: STOP_FOR_INPUT TO TRUE

BEFORE FIND 
   SET count TO 0

ON FIND
   SET count TO count + 1

AFTER FIND
   SET no_osit: STOP_FOR_INPUT TO FALSE
   IF node:PREV_FORM = 'task' THEN
   BEGIN
      IF count = 0 THEN 
	  NEXT ACTION IS CLEAR TO ADD
   END

ON NEXT RECORD
   UPDATE CURRENT RECORD

AFTER ZOOM
   IF PREV_FORM = 'problem' THEN
      SET problem:pr_node TO node:no_id

FIELD no_ser
   ON FIELD
      SET temp_ser TO no_ser
      INPUT
      IF ((no_ser <> temp_ser) AND (temp_ser <> '') AND (temp_ser <> UNDEFINED)) THEN
         SET node:no_install_date TO current_date$()

FIELD no_id
   ON FIELD
      INPUT
      IF node:$addmode = 1 THEN 	      	/* Check for CLEAR TO ADD */
      BEGIN
         IF no_id = 'COMPAQ' THEN		/* Find next Compaq number */
         BEGIN
            SET node:$next TO 
	    SELECT #nxt_num FROM nextnum
	    WHERE #nxt_field_name = 'compaq_num'
	    SET node:$value TO val_to_str$(node:$next)
	    SWITCH strlen$(node:$value)
	    BEGIN
	       CASE 3:
	          SET node:$no_id TO node:no_id + node:$value
	       CASE 2:
		  SET node:$no_id TO node:no_id + '0' + node:$value
	       DEFAULT:
		  SET node:$no_id TO node:no_id + '00' + node:$value
	    END
	    /* Update the compaq num */
	    UPDATE nextnum SET #nxt_num TO node:$next+1
	    WHERE #nxt_field_name = 'compaq_num'
	 END
	IF node:no_id = 'LC' THEN
	BEGIN
           SET node:$is_it_lc TO 1
           SET node:$next TO
           SELECT #nxt_num FROM nextnum
              WHERE #nxt_field_name = 'lc_num'
           SET node:$value TO val_to_str$(node:$next)
           SWITCH strlen$(node:$value)
           BEGIN
              CASE 3: SET node:$no_id TO node:no_id + node:$value
              CASE 2: SET node:$no_id TO node:no_id + '0' + node:$value
              CASE 1: SET node:$no_id TO node:no_id + '00' + node:$value
           END
           UPDATE nextnum
              SET #nxt_num TO node:$next+1 WHERE #nxt_field_name = 'lc_num'
           SET node:no_lcid TO node:no_id
        END
        IF no_id = 'IBM' THEN			/* Find next IBM number */
	BEGIN	
	   SET node:$next TO SELECT #nxt_num
              FROM nextnum WHERE #nxt_field_name = 'ibm_num'
           SET node:$value TO val_to_str$(node:$next)
	   SWITCH strlen$(node:$value)
	   BEGIN
	      CASE 3: SET node:$no_id TO node:no_id + node:$value
	      CASE 2: SET node:$no_id TO node:no_id + '0' + node:$value
	      DEFAULT: SET node:$no_id TO node:no_id + '00' + node:$value
	   END
	   /* Update the ibm num */
	   UPDATE nextnum SET #nxt_num TO node:$next+1
	   WHERE #nxt_field_name = 'ibm_num'
        END
        IF no_id = 'PCL' THEN			/* Find next PCL number */
        BEGIN	
	   SET node:$next TO SELECT #nxt_num FROM nextnum
              WHERE #nxt_field_name = 'pcl_num'
	   SET node:$value TO val_to_str$(node:$next)
	   SWITCH strlen$(node:$value)
	   BEGIN
	      CASE 3: SET node:$no_id TO node:no_id+node:$value
	      CASE 2: SET node:$no_id TO node:no_id+'0'+node:$value
	      DEFAULT: SET node:$no_id TO node:no_id+'00'+node:$value
	   END
	   /* Update the pcl num */
	   UPDATE nextnum
              SET #nxt_num TO node:$next+1 WHERE #nxt_field_name = 'pcl_num'
        END
	IF no_id = 'TOSHIBA' THEN		/*Find next TOSHIBA number */
	BEGIN	
	   SET node:$next TO SELECT #nxt_num
              FROM nextnum WHERE #nxt_field_name = 'toshiba_num'
	   SET node:$value TO val_to_str$(node:$next)
	   SWITCH strlen$(node:$value)
	   BEGIN
	      CASE 3: SET node:$no_id TO node:no_id + node:$value
	      CASE 2: SET node:$no_id TO node:no_id + '0' + node:$value
	      DEFAULT: SET node:$no_id TO node:no_id + '00' + node:$value
	   END
	   UPDATE nextnum SET #nxt_num TO
              node:$next+1 WHERE #nxt_field_name = 'toshiba_num'
        END
    END

/*------------------------------------------------------------------------*/

FIELD no_vendor
   BEFORE FIELD
      ENABLE ZOOM to vendor RETURN KEY
      SET node:old_vendor TO node:no_vendor
   ON FIELD
      INPUT
      IF node:old_vendor <> node:no_vendor THEN
      BEGIN
	 SET node:old_vendor TO node:no_vendor
	 SET node:no_vendor TO
	 SELECT #ve_id
	 FROM vendor
	 WHERE #ve_id = node:no_vendor
	 IF status$() < 0 THEN
	 BEGIN 
	    DISPLAY node:old_vendor + ' was not found, hit RETURN to continue.'
	    FOR FYI_MESSAGE WAIT
	    RESTART ON FIELD
	 END
      END

/*------------------------------------------------------------------------*/

FIELD no_site  
   BEFORE FIELD
      ENABLE ZOOM to site RETURN KEY
      SET node:old_site TO node:no_site
      SET node:temp_site TO node:no_site
   ON FIELD
      INPUT
      IF ((node:old_site <> node:no_site) AND (old_site <> '') AND (old_site <> UNDEFINED)) THEN
      BEGIN
         SET node:old_site TO node:no_site
         SET node:no_site TO
            SELECT #si_id
            FROM site
            WHERE #si_id = node:no_site
         IF status$() < 0 THEN
         BEGIN 
            DISPLAY node:old_site + ' was not found, hit RETURN to continue.'
               FOR FYI_MESSAGE WAIT
            RESTART ON FIELD
         END
         ELSE
         BEGIN
            SET node:no_osit TO node:temp_site
            SET node:no_move_date TO current_date$()
         END
      END

/*------------------------------------------------------------------------*/

FIELD no_trob_prt
   BEFORE FIELD
      ENABLE ZOOM to tprt RETURN KEY			/* turn ZOOM on */
      SET node:tmp TO UNDEFINED				/* clear tmp var */
   ON FIELD
      INPUT;
      IF node:no_trob_prt <> UNDEFINED THEN		/* if only [RETURN] */
      BEGIN						/* is pressed */
	 SET node:tmp TO				/* don't need the */
	 SELECT #tp_name FROM tprt			/* returned value */
	 WHERE #tp_name = node:no_trob_prt		/* find old value */
	 IF status$() <> 0 THEN				/* if not fine */
	 BEGIN
	    DISPLAY node:no_trob_prt +
		' is not a valid printer, press ZOOM for printer ids'
	    FOR FYI_MESSAGE WAIT			/* Wait for [RET] */
	    SET node:no_trob_prt
	    TO UNDEFINED			/* clear the field */
	    RESTART ON FIELD		/* ask again */
	 END /* if status */
      END /* if node: */

/*------------------------------------------------------------------------*/

FIELD no_prob_esc_code
   BEFORE FIELD
      ENABLE ZOOM to ecode RETURN KEY
      SET node:tmp TO UNDEFINED
      SET node:hours TO UNDEFINED
      SET node:days  TO UNDEFINED
   ON FIELD
      INPUT;
      IF node:no_prob_esc_code <> UNDEFINED THEN
      BEGIN
         SET node:tmp TO
            SELECT #ec_num FROM ecode
            WHERE #ec_num = node:no_prob_esc_code
         IF status$() <> 0 THEN
         BEGIN
            DISPLAY 'Invalid escalation code, press ZOOM for escalation codes.' FOR FYI_MESSAGE WAIT
            SET node:no_prob_esc_code to -1
            RESTART ON FIELD
         END
      END
   WHEN FIELD CHANGES
      SET node:hours TO SELECT #ec_hours
         FROM ecode WHERE #ec_num = no_prob_esc_code
      SET node:days TO SELECT #ec_days
         FROM ecode WHERE #ec_num = no_prob_esc_code
      SET no_code_des TO val_to_str$(node:days) + ' Dy/ ' + val_to_str$(node:hours) + ' Hr'

FIELD no_contract
   ON FIELD
      INPUT
      IF ((no_contract<>'NONE') AND (no_contract<>'T&M') AND
         (no_contract<>'40HR') AND (no_contract<>'7DAY') AND
         (no_contract<>'TAC') AND (no_contract<>'SWAP') AND
         (no_contract<>'ONSS') AND (no_contract<>'')) THEN
      BEGIN
         DISPLAY 'Invalid choice, please try again' FOR FYI_MESSAGE WAIT;
         SET no_contract TO ''
         RESTART ON FIELD
      END
   WHEN FIELD CHANGES
      IF (no_contract = 'NONE') THEN
         SET no_contract: BLINK TO TRUE
      ELSE
         SET no_contract: BLINK TO FALSE

/*------------------------------------------------------------------------*/
FIELD no_jes_line
   ON FIELD
      INPUT
      IF no_jes_line = 'U' THEN		/* Find next VPS number */
      BEGIN	
         SET node:$next TO SELECT #nxt_num
            FROM nextnum WHERE #nxt_field_name = 'vps_num'
         SET node:$value TO val_to_str$(node:$next)
         SET node:$no_jes_line TO node:no_jes_line + node:$value
         /* Update the VPS num */
         UPDATE nextnum SET #nxt_num TO
            node:$next + 1 WHERE #nxt_field_name = 'vps_num'
      END

/*------------------------------------------------------------------------*/

FIELD no_hard_disk_ty
   BEFORE FIELD
      ENABLE ZOOM TO hdtype RETURN KEY

/*------------------------------------------------------------------------*/

FIELD no_pri_user
   BEFORE FIELD
      SET node:$no_update TO 0
      ENABLE ZOOM TO phone 

/*------------------------------------------------------------------------*/

FIELD no_cc_head
   BEFORE FIELD
      SET node:$noupdate TO 1
      ENABLE ZOOM TO phone RETURN KEY
   AFTER FIELD
      SET node:$noupdate TO 0

/*------------------------------------------------------------------------*/

FIELD no_phone
   BEFORE FIELD
      SET node:$noupdate TO 0
      ENABLE ZOOM TO phone

/*------------------------------------------------------------------------*/

FIELD no_lcid
   BEFORE FIELD
      IF no_lcid<>UNDEFINED THEN
      BEGIN
         IF (substr$(no_lcid, 1, 2)<>'LC') THEN
            SET no_lcid TO ''
      END
      ELSE
      BEGIN
         SET no_lcid TO 'NONE'
      END
      ENABLE ZOOM TO logcon
   ON FIELD
      INPUT
      IF ((node:no_lcid <> '') AND (node:no_lcid <> 'NONE')) THEN
      BEGIN
         SET err TO SELECT #no_id FROM node WHERE #no_id=node:no_lcid
         IF status$() < 0 THEN
         BEGIN
            beep$(1)
            DISPLAY 'Invalid Logcon, enter it on Node Information first.'
               FOR FYI_MESSAGE WAIT;
            SET no_lcid TO UNDEFINED
            RESTART ON FIELD
         END
      END

