/**************************************************************************
*
*	noderep.fs      
*
*	FORM:	noderep        
*	DESCRIPTION:	This is the script that generates the reports
*			for the Node Information database.
*
*	AUTHOR:    DWM
*	DATE:      01/15/90
*	REVIEWER:  DWM
*
****************************************************************************/

#define set_select(prevf,curf,fieldname) \
   SET curf:fieldname:SEARCH_RANGES TO prevf:fieldname:SEARCH_RANGES

FORM noderep         

TARGET_TABLE node

LOCAL sel,printer;

BEFORE FORM
   SET noderep:sel:STOP_FOR_INPUT TO TRUE
   SET noderep:FIRST_FIELD TO 'sel'
   SET noderep:AUTO_FIND TO TRUE   
   SET sel TO UNDEFINED
   SET printer TO getenv$('SPOOLER')

BEFORE FIND
   set_select(node,noderep,no_id)
   set_select(node,noderep,no_site)
   set_select(node,noderep,no_osit)
   set_select(node,noderep,no_group)
   set_select(node,noderep,no_location)
   set_select(node,noderep,no_model)
   set_select(node,noderep,no_dept)
   set_select(node,noderep,no_ser)
   set_select(node,noderep,no_phone)
   set_select(node,noderep,no_vendor)
   set_select(node,noderep,no_floor_jack)
   set_select(node,noderep,no_serv_num)
   set_select(node,noderep,no_trob_prt)
   set_select(node,noderep,no_install_date)
   set_select(node,noderep,no_move_date)
   set_select(node,noderep,no_prob_esc_code)
   set_select(node,noderep,no_comment1)
   set_select(node,noderep,no_comment2)
   set_select(node,noderep,no_comment3)
   set_select(node,noderep,no_comment4)
   set_select(node,noderep,no_prnum)
   set_select(node,noderep,no_pur_date)
   set_select(node,noderep,no_pur_ven)
   set_select(node,noderep,no_pur_order)
   set_select(node,noderep,no_pri_user)
   set_select(node,noderep,no_cost_center)
   set_select(node,noderep,no_cc_head)
   set_select(node,noderep,no_total_mem)
   set_select(node,noderep,no_hard_disk_ty)
   set_select(node,noderep,no_vtam_id)
   set_select(node,noderep,no_copro)
   set_select(node,noderep,no_keyid)

   IF sel = 2 THEN
   BEGIN
      DISPLAY 'Generating report sorted by node.'
      CREATE PIPELINE noderep:pipe1 'RPT /usr/db/ACL4/rptdir/n1.r -', printer;
      DISPLAY 'Printing report ... Please wait' FOR FYI_MESSAGE ;
   END

   IF sel = 3 THEN
   BEGIN
      DISPLAY 'Generating report sorted by Site and S/N.'
      CREATE PIPELINE noderep:pipe1 'RPT /usr/db/ACL4/rptdir/n4.r -' ,
				    printer;
      DISPLAY 'Printing report .. Please wait' FOR FYI_MESSAGE ;
   END

   IF sel = 4 THEN
   BEGIN
      DISPLAY 'Generating report sorted by S/N.'
      CREATE PIPELINE noderep:pipe1 'RPT /usr/db/ACL4/rptdir/n7.r -' ,
				    printer;
      DISPLAY 'Printing report ... Please wait' FOR FYI_MESSAGE ;
   END

ON FIND
   IF sel = 2 or sel = 3 or sel = 4 THEN
      WRITE PIPELINE noderep:pipe1 no_site, no_osit, no_id,no_ser, no_model,
         no_vendor, no_location, no_phone

AFTER FIND
   IF sel = 2 or sel = 3 or sel = 4 THEN
   BEGIN
      CLOSE PIPELINE noderep:pipe1;
      DISPLAY 'Printing Report on selected records. Hit return to continue.'
      FOR FYI_MESSAGE WAIT ;
      SET sel TO UNDEFINED
   END

FIELD sel
   ON FIELD
      REFRESH SCREEN
   INPUT
      SWITCH sel
      BEGIN
         CASE 1 : 
            BEGIN
               DISPLAY 'Printing Report on selected records' FOR FYI_MESSAGE;
               CREATE PIPELINE noderep:pipe1 'RPT /usr/db/ACL4/rptdir/n1.r -',
                  printer;
               WRITE PIPELINE noderep:pipe1 no_site, no_osit, no_id, no_ser,
                  no_model, no_vendor, no_location, no_phone
               CLOSE PIPELINE noderep:pipe1;
               DISPLAY 'Done printing Single record. Hit RETURN to continue'
                  FOR FYI_MESSAGE WAIT;
               SET sel TO UNDEFINED
            END
         CASE 2:
         CASE 3:
         CASE 4:
            BEGIN
               DISPLAY 'Printing Report on selected records' FOR FYI_MESSAGE;
               NEXT ACTION IS FIND
            END
         DEFAULT : 
            BEGIN 
               DISPLAY 'Enter only 1, 2, 3, or 4.  Press RETURN to continue'
                  FOR FYI_MESSAGE WAIT;
               RESTART ON FIELD
            END
      END
