/**************************************************************************
*
*	orderrep.fs     
*
*	FORM:	orderrep       
*	DESCRIPTION:	This is a special report generator written for
*			User Services that prints reports that are
*			sorted by Vendor and Project Number to make
*			orders easier.
*
*	AUTHOR:    JWS
*	DATE:      01/23/91
*	REVIEWER:  JWS
*
***************************************************************************/

#define set_select(prevf,curf,fieldname) \
   SET curf:fieldname:SEARCH_RANGES TO prevf:fieldname:SEARCH_RANGES

FORM orderrep        

TARGET_TABLE node

LOCAL soft_title, soft_amount, soft_ver, soft_vend, hard_title, hard_amount,
   hard_vend, hard_dummy1;

BEFORE FORM
   SET sel TO UNDEFINED
   SET orderrep:$printer TO getenv$('SPOOLER')
   SET orderrep:AUTO_FIND TO TRUE

BEFORE FIND
   set_select(node,orderrep,no_ser)
   set_select(node,orderrep,no_id)
   set_select(node,orderrep,no_group)
   set_select(node,orderrep,no_model)
   set_select(node,orderrep,no_vendor)
   set_select(node,orderrep,no_site)
   set_select(node,orderrep,no_location)
   set_select(node,orderrep,no_dept)
   set_select(node,orderrep,no_phone)
   set_select(node,orderrep,no_cost_center)
   set_select(node,orderrep,no_pur_po)
   set_select(node,orderrep,no_main_po)
   set_select(node,orderrep,no_install_date)
   set_select(node,orderrep,no_comment1)
   set_select(node,orderrep,no_comment2)
   set_select(node,orderrep,no_comment3)
   set_select(node,orderrep,no_comment4)
   set_select(node,orderrep,no_prt_dest)
   set_select(node,orderrep,no_trob_prt)
   set_select(node,orderrep,no_prob_esc_code)
   set_select(node,orderrep,no_serv_code)
   set_select(node,orderrep,no_floor_jack)
   set_select(node,orderrep,no_prnum)
   set_select(node,orderrep,no_cc_head)
   set_select(node,orderrep,no_pri_user)
   set_select(node,orderrep,no_keyid)
   set_select(node,orderrep,no_pur_date)
   set_select(node,orderrep,no_pur_order)
   set_select(node,orderrep,no_vtam_id)
   set_select(node,orderrep,no_next_hard)
   set_select(node,orderrep,no_next_soft)
   set_select(node,orderrep,no_serv_num)
   set_select(node,orderrep,no_copro)
   set_select(node,orderrep,no_hard_disk_ty)
   set_select(node,orderrep,no_pur_ven)
   set_select(node,orderrep,no_hard_disk_si)
   set_select(node,orderrep,no_move_date)
   set_select(node,orderrep,no_total_mem)
   set_select(node,orderrep,no_priority)
   set_select(node,orderrep,no_task)
   set_select(node,orderrep,no_lcid)
   set_select(node,orderrep,no_vps_id)
   set_select(node,orderrep,no_jes_line)
   set_select(node,orderrep,no_contract)
   IF sel='1' THEN
   BEGIN
      DISPLAY 'Printing report on selected records.' FOR FYI_MESSAGE;
      CREATE PIPELINE orderrep:$pipe1 'RPT /usr/db/ACL4/rptdir/orderrep.r -',
         orderrep:$printer;
   END

ON FIND
   IF sel='1' THEN
   BEGIN
      SET dummy TO SELECT no_id FROM node
         WHERE ((#no_prnum=no_prnum) AND (#no_task=no_task))
      SET $soft_title TO UNDEFINED
      SET $soft_amount TO UNDEFINED
      SET $soft_title, $soft_amount, $soft_ver, $soft_vend TO
         SELECT #ps_soft, #ps_amoun, #ps_ver, #ps_vend
         FROM pcsoft WHERE #ps_node=dummy
      EXECUTING BEGIN
         WRITE PIPELINE orderrep:pipe1 'SOFT', pad_str_right$($soft_title,
            ' ', 30), $soft_ver, $soft_vend, $soft_amount, no_prnum;
      END
      SET $hard_title TO UNDEFINED
      SET $hard_amount TO UNDEFINED
      SET $hard_title, $hard_dummy1, $hard_vend, $hard_amount TO
         SELECT #ph_mod, #ph_sn, #ph_ven, #ph_amount
         FROM pchard WHERE #ph_node=dummy
         EXECUTING BEGIN
            WRITE PIPELINE orderrep:pipe1 'HARD', pad_str_right$($hard_title,
               ' ', 30), $hard_dummy1, $hard_vend, $hard_amount, no_prnum;
      END
   END

AFTER FIND
   IF sel='1' THEN
   BEGIN
      CLOSE PIPELINE orderrep:$pipe1
      DISPLAY 'Finished printing.  Press RETURN to continue.' FOR FYI_MESSAGE
      WAIT;
      SET sel TO UNDEFINED
   END

FIELD sel
   BEFORE FIELD
      SET sel TO UNDEFINED
   ON FIELD
      REFRESH SCREEN
      INPUT
      IF sel='1' THEN
         NEXT ACTION IS FIND
