/**************************************************************************
*
*	partreport.fs   
*
*	FORM:	partreport     
*	DESCRIPTION:	This script generates reports for the Hardware/
*			Software Catalog.  Note that it pulls data
*			from different places within the HDMS database,
*			so it is fairly complex in terms of flow
*			control and imbedded SQL queries.  In other
*			words -- it is a good example to look at when
*			you're trying to write a complex script.
*
*	AUTHOR:    JWS
*	DATE:      01/07/91
*	REVIEWER:  JWS
*
****************************************************************************/

#define ESC char_code_to_str$(27)
#define MAXLINES 80
#define set_select(prevf,curf,fieldname) \
   SET curf:fieldname:SEARCH_RANGES TO prevf:fieldname:SEARCH_RANGES
#define pcol(X) '&a',X,'C'
#define FormFeed char_code_to_str$(12)
#define mtstring ''  /* get it, mtstring = emptystring */
#define regset '(8U(s0p16.67h8.5v0s0b0T&l0o'
#define setund '&dD'
#define unsetund '&d@'
#define heading(pageno) \
   WRITE PIPELINE partreport:$pipe1 regset ,pcol(1), \
   current_date$(),'   ', current_time$(), \
   '                                          Parts Catalog Listing                                    Page: ', pageno,'\n', \
   regset;
#define addline \
   IF $LINENO > 57 THEN \
   BEGIN \
      WRITE PIPELINE partreport:$pipe1 FormFeed; \
      SET $PAGE TO ($PAGE + 1); \
      heading($PAGE); \
      SET $LINENO TO 0; \
   END \
   ELSE \
      SET $LINENO TO ($LINENO + 1)

FORM partreport      

TARGET_TABLE parts

LOCAL version, vendor, media, part_no, price, already

BEFORE FORM
   SET partreport:sel TO UNDEFINED
   SET partreport:$printer TO getenv$('SPOOLER')
   SET partreport:AUTO_FIND TO TRUE

BEFORE FIND
   set_select(part,partreport,pa_name)
   set_select(part,partreport,pa_manf)
   set_select(part,partreport,pa_com1)
   set_select(part,partreport,pa_com2)
   set_select(part,partreport,pa_com3)
   set_select(part,partreport,pa_com4)
   set_select(part,partreport,pa_amount)

ON FIND
   IF partreport:sel=2 THEN
   BEGIN
      WRITE PIPELINE partreport:$pipe1 pa_name, pcol(48), pa_manf
      addline
      WRITE PIPELINE partreport:$pipe1 'Estimated Amount: $', pa_amount
      addline;
      IF pa_com1<>'' THEN
      BEGIN
         WRITE PIPELINE partreport:$pipe1 pcol(48), pa_com1
         addline
      END
      IF pa_com2<>'' THEN
      BEGIN
         WRITE PIPELINE partreport:$pipe1 pcol(48), pa_com2
         addline
      END
      IF pa_com3<>'' THEN
      BEGIN
         WRITE PIPELINE partreport:$pipe1 pcol(48), pa_com3
         addline
      END
      IF pa_com4<>'' THEN
      BEGIN
         WRITE PIPELINE partreport:$pipe1 pcol(48), pa_com4
         addline
      END
      SET $already TO 0
      SET $version, $vendor, $media, $part_no, $price TO
         SELECT #sv_ver, #sv_vend, #sv_media, #sv_part, #sv_price
         FROM softvend WHERE #sv_sname=pa_name
         ORDER BY #sv_ver DESCENDING
      EXECUTING BEGIN
         IF $already=0 THEN
         BEGIN
            SET $already TO 1
            WRITE PIPELINE partreport:$pipe1 ' '
            addline
            WRITE PIPELINE partreport:$pipe1 pcol(10), setund, 'Version',
               pcol(25), 'Vendor', pcol(40), 'Media', pcol(50),
               'Part Number', pcol(65), 'Price', unsetund
            addline
         END
         WRITE PIPELINE partreport:$pipe1 pcol(10), $version, pcol(25),
            $vendor, pcol(40), $media, pcol(50), $part_no, pcol(65), $price
         addline
      END
      IF $already=0 THEN
      BEGIN
         WRITE PIPELINE partreport:$pipe1 pcol(10), ' *** No data in HDMS ***'
         addline
      END
      WRITE PIPELINE partreport:$pipe1 ' '
      addline
   END

AFTER FIND
   IF partreport:$sel=2 THEN
   BEGIN
      CLOSE PIPELINE partreport:$pipe1
      DISPLAY 'Done printing ... Press RETURN' FOR FYI_MESSAGE WAIT
      SET sel TO UNDEFINED
   END

FIELD sel
   ON FIELD
      INPUT
      IF partreport:sel=1 THEN
      BEGIN
         DISPLAY 'Printing report ... Please hold' FOR FYI_MESSAGE
         CREATE PIPELINE partreport:$pipe1 '/usr/db/ACL4/aclenv/netops/cprobrep',
            partreport:$printer
         SET $LINENO TO 0
         SET $PAGE TO 1
         WRITE PIPELINE partreport:$pipe1 regset
         heading($PAGE);
         addline
         WRITE PIPELINE partreport:$pipe1 setund, 'Part ID', pcol(48),
            'Manufacturer/Comments', unsetund;
         addline
         WRITE PIPELINE partreport:$pipe1 part:pa_name, pcol(48), part:pa_manf
         addline
         WRITE PIPELINE partreport:$pipe1 'Estimated Amount: $', part:pa_amount
         addline;
         IF part:pa_com1<>'' THEN
         BEGIN
            WRITE PIPELINE partreport:$pipe1 pcol(48), part:pa_com1
            addline
         END
         IF part:pa_com2<>'' THEN
         BEGIN
            WRITE PIPELINE partreport:$pipe1 pcol(48), part:pa_com2
            addline
         END
         IF part:pa_com3<>'' THEN
         BEGIN
            WRITE PIPELINE partreport:$pipe1 pcol(48), part:pa_com3
            addline
         END
         IF part:pa_com4<>'' THEN
         BEGIN
            WRITE PIPELINE partreport:$pipe1 pcol(48), part:pa_com4
            addline
         END
         WRITE PIPELINE partreport:$pipe1 ' '
         addline
         WRITE PIPELINE partreport:$pipe1 pcol(10), setund, 'Version',
            pcol(25), 'Vendor', pcol(40), 'Media', pcol(50), 'Part Number',
            pcol(65), 'Price', unsetund
         addline
         SET $version, $vendor, $media, $part_no, $price TO
         SELECT #sv_ver, #sv_vend, #sv_media, #sv_part, #sv_price
         FROM softvend WHERE #sv_sname=part:pa_name
         ORDER BY #sv_ver DESCENDING
         EXECUTING BEGIN
            WRITE PIPELINE partreport:$pipe1 pcol(10), $version, pcol(25),
               $vendor, pcol(40), $media, pcol(50), $part_no, pcol(65), $price
            addline
         END
         CLOSE PIPELINE partreport:$pipe1
         DISPLAY 'Done printing ... Press RETURN' FOR FYI_MESSAGE WAIT
         SET sel TO UNDEFINED
      END
      IF partreport:sel=2 THEN
      BEGIN
         DISPLAY 'Printing report ... Please hold' FOR FYI_MESSAGE
         CREATE PIPELINE partreport:$pipe1 '/usr/db/ACL4/aclenv/netops/cprobrep',
            partreport:$printer
         SET $LINENO TO 1
         SET $PAGE TO 1
         WRITE PIPELINE partreport:$pipe1 regset
         heading($PAGE);
         addline
         WRITE PIPELINE partreport:$pipe1 setund, 'Part ID', pcol(48),
            'Manufacturer/Comments', unsetund;
         addline
         NEXT ACTION IS FIND
      END
